/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei.kiln;

import com.teammetallurgy.atum.utils.AtumUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class KilnRecipeWrapper
implements IRecipeWrapper {
    private final ResourceLocation id;
    private final List<List<ItemStack>> inputs;
    private final ItemStack output;
    private final float experience;

    public KilnRecipeWrapper(ResourceLocation id, NonNullList<ItemStack> input, ItemStack output, float experience) {
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>((Collection<ItemStack>)input);
        this.id = id;
        this.inputs = Collections.singletonList(inputList);
        this.output = output;
        this.experience = experience;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.experience > 0.0f) {
            String experienceString = AtumUtils.format("gui.jei.category.smelting.experience", Float.valueOf(this.experience));
            minecraft.field_71466_p.func_78276_b(experienceString, -1, recipeHeight - 13, Color.gray.getRGB());
        }
    }
}

