/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.particle;

import com.teammetallurgy.atum.client.particle.IAtumParticleFactory;
import com.teammetallurgy.atum.client.particle.ParticleBase;
import javax.annotation.Nonnull;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="atum", value={Side.CLIENT})
public class ParticleLightSparkle
extends ParticleBase {
    private static final ResourceLocation LIGHT_SPARKLE = new ResourceLocation("atum", "particle/light_sparkle");
    private float particleScaleOverTime;

    public ParticleLightSparkle(World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.field_187129_i *= (double)0.01f;
        this.field_187130_j *= (double)0.01f;
        this.field_187131_k *= (double)0.01f;
        this.field_187130_j += 0.1;
        this.field_70544_f *= 0.4f;
        this.particleScaleOverTime = this.field_70544_f;
        this.field_70547_e = 16;
        this.func_187117_a(ParticleLightSparkle.getSprite(LIGHT_SPARKLE));
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        float f = ((float)this.field_70546_d + partialTicks) / (float)this.field_70547_e * 32.0f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        this.field_70544_f = this.particleScaleOverTime * f;
        super.func_180434_a(buffer, entity, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_187127_g == this.field_187124_d) {
            this.field_187129_i *= 1.1;
            this.field_187131_k *= 1.1;
        }
        this.field_187129_i *= (double)0.86f;
        this.field_187130_j *= (double)0.86f;
        this.field_187131_k *= (double)0.86f;
        if (this.field_187132_l) {
            this.field_187129_i *= (double)0.7f;
            this.field_187131_k *= (double)0.7f;
        }
    }

    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        ParticleLightSparkle.registerSprite(LIGHT_SPARKLE);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements IAtumParticleFactory {
        @Override
        public Particle createParticle(String name, @Nonnull World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleLightSparkle(world, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }
}

