/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBranch
extends Block {
    public static final PropertyEnum<EnumFacing> FACING = PropertyEnum.func_177709_a((String)"facing", EnumFacing.class);
    private static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    private static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    private static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    private static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    private static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private static final Map<EnumFacing, AxisAlignedBB> bounds;
    private static final Map<EnumFacing, AxisAlignedBB> connectedBounds;
    private static final AxisAlignedBB EAST_AABB;
    private static final AxisAlignedBB WEST_AABB;
    private static final AxisAlignedBB NORTH_AABB;
    private static final AxisAlignedBB SOUTH_AABB;
    private static final AxisAlignedBB UP_AABB;
    private static final AxisAlignedBB DOWN_AABB;

    public BlockBranch() {
        super(Material.field_151575_d);
        this.func_149711_c(0.8f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149713_g(1);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175684_a(pos, (Block)this, 1);
        }
    }

    private boolean canSurviveAt(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        IBlockState neighbor = world.func_180495_p(pos.func_177971_a(facing.func_176730_m()));
        return neighbor.func_185904_a() == Material.field_151575_d;
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return BlockAtumPlank.getStick(BlockAtumPlank.WoodType.DEADWOOD);
    }

    public int func_149745_a(Random random) {
        return random.nextDouble() <= (double)0.15f ? 1 : 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        return true;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
        IBlockState neighbor = source.func_180495_p(pos.func_177971_a(facing.func_176730_m()));
        if (neighbor.func_177230_c() == this) {
            AxisAlignedBB box = connectedBounds.get(facing);
            AxisAlignedBB expandedBox = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
            return expandedBox.func_72321_a(0.3125 * (double)facing.func_82601_c(), 0.3125 * (double)facing.func_96559_d(), 0.3125 * (double)facing.func_82599_e());
        }
        return bounds.get(facing);
    }

    @Nonnull
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(FACING, (Comparable)facing.func_176734_d());
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.field_82609_l[meta]);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing enumFacing = (EnumFacing)state.func_177229_b(FACING);
        return enumFacing.ordinal();
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing enumFacing = (EnumFacing)state.func_177229_b(FACING);
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(enumFacing != EnumFacing.NORTH && this.shouldConnect(EnumFacing.NORTH, world, pos))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(enumFacing != EnumFacing.EAST && this.shouldConnect(EnumFacing.EAST, world, pos))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(enumFacing != EnumFacing.SOUTH && this.shouldConnect(EnumFacing.SOUTH, world, pos))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(enumFacing != EnumFacing.WEST && this.shouldConnect(EnumFacing.WEST, world, pos))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(enumFacing != EnumFacing.UP && this.shouldConnect(EnumFacing.UP, world, pos))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(enumFacing != EnumFacing.DOWN && this.shouldConnect(EnumFacing.DOWN, world, pos)));
    }

    private boolean shouldConnect(EnumFacing direction, IBlockAccess worldIn, BlockPos pos) {
        IBlockState neighborState = worldIn.func_180495_p(pos.func_177971_a(direction.func_176730_m()));
        if (neighborState.func_177230_c() == this) {
            return neighborState.func_177229_b(FACING) == direction.func_176734_d();
        }
        return false;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return state.func_177226_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH)).func_177226_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a((IProperty)EAST, state.func_177229_b((IProperty)WEST)).func_177226_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    static {
        EAST_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 1.0, 0.6875, 0.6875);
        WEST_AABB = new AxisAlignedBB(0.0, 0.3125, 0.3125, 0.6875, 0.6875, 0.6875);
        NORTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.0, 0.6875, 0.6875, 0.6875);
        SOUTH_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 0.6875, 1.0);
        UP_AABB = new AxisAlignedBB(0.3125, 0.3125, 0.3125, 0.6875, 1.0, 0.6875);
        DOWN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.6875, 0.6875);
        bounds = new HashMap<EnumFacing, AxisAlignedBB>();
        connectedBounds = new HashMap<EnumFacing, AxisAlignedBB>();
        bounds.put(EnumFacing.EAST, EAST_AABB);
        bounds.put(EnumFacing.WEST, WEST_AABB);
        bounds.put(EnumFacing.NORTH, NORTH_AABB);
        bounds.put(EnumFacing.SOUTH, SOUTH_AABB);
        bounds.put(EnumFacing.UP, UP_AABB);
        bounds.put(EnumFacing.DOWN, DOWN_AABB);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            AxisAlignedBB box = bounds.get(facing);
            AxisAlignedBB expandedBox = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
            expandedBox.func_72321_a((double)(5 * facing.func_82601_c()), (double)(5 * facing.func_96559_d()), (double)(5 * facing.func_82599_e()));
            connectedBounds.put(facing, expandedBox);
        }
    }
}

