/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.blocks.base.IRenderMapper;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockReed;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockPapyrus
extends BlockReed
implements IRenderMapper {
    private static final PropertyBool TOP = PropertyBool.func_177716_a((String)"top");

    public BlockPapyrus() {
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176355_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180650_b(World world, BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if ((world.func_180495_p(pos.func_177977_b()).func_177230_c() == AtumBlocks.PAPYRUS || this.func_176353_e(world, pos, state)) && world.func_175623_d(pos.func_177984_a())) {
            int i = 1;
            while (world.func_180495_p(pos.func_177979_c(i)).func_177230_c() == this) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.func_177229_b((IProperty)field_176355_a);
                if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)true)) {
                    if (j == 15) {
                        world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                        world.func_180501_a(pos, state.func_177226_a((IProperty)field_176355_a, (Comparable)Integer.valueOf(0)), 4);
                    } else {
                        world.func_180501_a(pos, state.func_177226_a((IProperty)field_176355_a, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                    ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
                }
            }
        }
    }

    public boolean func_176196_c(World world, @Nonnull BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block.canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        if (block == this) {
            return true;
        }
        if (block != AtumBlocks.FERTILE_SOIL && block != AtumBlocks.FERTILE_SOIL_TILLED && block != AtumBlocks.SAND) {
            return false;
        }
        BlockPos blockpos = pos.func_177977_b();
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate = world.func_180495_p(blockpos.func_177972_a(enumfacing));
            if (iblockstate.func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == AtumBlocks.PAPYRUS && this == AtumBlocks.PAPYRUS) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return AtumItems.PAPYRUS_PLANT;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(AtumItems.PAPYRUS_PLANT);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176355_a, TOP});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockPos upperPos = pos.func_177982_a(0, 1, 0);
        return state.func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(world.func_175623_d(upperPos)));
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{field_176355_a};
    }
}

