/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.base.IRenderMapper;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumParticles;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFertileSoilTilled
extends BlockFarmland
implements IRenderMapper {
    public static final PropertyBool BLESSED = PropertyBool.func_177716_a((String)"blessed");

    public BlockFertileSoilTilled() {
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BLESSED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180650_b(@Nonnull World world, BlockPos pos, IBlockState state, Random rand) {
        int moisture = (Integer)state.func_177229_b((IProperty)field_176531_a);
        Block blockUp = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        if (((Boolean)state.func_177229_b((IProperty)BLESSED)).booleanValue() && blockUp instanceof IGrowable) {
            world.func_175684_a(pos.func_177984_a(), blockUp, this.func_149738_a(world));
        }
        if (!this.hasWater(world, pos) && !world.func_175727_C(pos.func_177984_a())) {
            if (moisture > 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!this.hasCrops(world, pos)) {
                BlockFertileSoilTilled.turnToSoil(world, pos);
            }
        } else if (moisture < 7) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public int func_149738_a(World world) {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)BLESSED)).booleanValue() && !world.func_180495_p(pos.func_177984_a()).func_185915_l() && rand.nextDouble() <= 0.15) {
            for (int amount = 0; amount < 3; ++amount) {
                double d0 = rand.nextGaussian() * 0.01;
                double d1 = rand.nextGaussian() * 0.005;
                double d2 = rand.nextGaussian() * 0.01;
                Atum.proxy.spawnParticle(AtumParticles.Types.TEFNUT, (Entity)Minecraft.func_71410_x().field_71439_g, (float)pos.func_177958_n() + rand.nextFloat(), (double)pos.func_177956_o() + 1.05, (float)pos.func_177952_p() + rand.nextFloat(), d0, d1, d2);
            }
        }
    }

    public void func_180658_a(@Nonnull World world, @Nonnull BlockPos pos, Entity entity, float fallDistance) {
        if (!world.field_72995_K && entity.canTrample(world, (Block)this, pos, fallDistance)) {
            BlockFertileSoilTilled.turnToSoil(world, pos);
        }
        entity.func_180430_e(fallDistance, 1.0f);
    }

    private static void turnToSoil(World world, BlockPos pos) {
        IBlockState state = AtumBlocks.FERTILE_SOIL.func_176223_P();
        world.func_175656_a(pos, state);
        AxisAlignedBB axisAlignedBB = field_194405_c.func_186670_a(pos);
        for (Entity entity : world.func_72839_b(null, axisAlignedBB)) {
            double axisY = Math.min(axisAlignedBB.field_72337_e - axisAlignedBB.field_72338_b, axisAlignedBB.field_72337_e - entity.func_174813_aQ().field_72338_b);
            entity.func_70634_a(entity.field_70165_t, entity.field_70163_u + axisY + 0.001, entity.field_70161_v);
        }
    }

    private boolean hasCrops(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return block instanceof IPlantable && this.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)block);
    }

    private boolean hasWater(World world, BlockPos pos) {
        for (BlockPos.MutableBlockPos mutableBlockPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-6, 0, -6), (BlockPos)pos.func_177982_a(6, 1, 6))) {
            if (world.func_180495_p((BlockPos)mutableBlockPos).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            BlockFertileSoilTilled.turnToSoil(world, pos);
        }
    }

    public void onPlantGrow(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, BlockPos source) {
        if (this == AtumBlocks.FERTILE_SOIL_TILLED) {
            world.func_180501_a(pos, AtumBlocks.FERTILE_SOIL.func_176223_P(), 2);
        }
        super.onPlantGrow(state, world, pos, source);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a()) {
            BlockFertileSoilTilled.turnToSoil(world, pos);
        }
    }

    public boolean canSustainPlant(@Nonnull IBlockState state, @Nonnull IBlockAccess world, BlockPos pos, @Nonnull EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177984_a());
        switch (plantType) {
            case Crop: 
            case Plains: {
                return true;
            }
        }
        return super.canSustainPlant(state, world, pos, direction, plantable);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState stateSide = world.func_180495_p(pos.func_177972_a(side));
                Block block = stateSide.func_177230_c();
                return !stateSide.func_185914_p() && block != AtumBlocks.FERTILE_SOIL && block != Blocks.field_185774_da;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, @Nullable Random rand, int fortune) {
        return AtumItems.FERTILE_SOIL_PILE;
    }

    public int func_149745_a(Random random) {
        return MathHelper.func_76136_a((Random)random, (int)3, (int)5);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176531_a, (Comparable)Integer.valueOf(meta & 7)).func_177226_a((IProperty)BLESSED, (Comparable)Boolean.valueOf(meta > 7));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)field_176531_a) + ((Boolean)state.func_177229_b((IProperty)BLESSED) != false ? 8 : 0);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176531_a, BLESSED});
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{BLESSED};
    }
}

