/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.beacon.tileentity;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.blocks.beacon.BlockRadiantBeacon;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRadiantBeacon
extends TileEntityBeacon {
    private final List<TileEntityBeacon.BeamSegment> beamSegments = Lists.newArrayList();

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void func_174908_m() {
        if (this.field_145850_b != null) {
            this.updateSegmentColors();
        }
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateSegmentColors() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.beamSegments.clear();
        this.field_146015_k = true;
        float[] defaultColor = ((EnumDyeColor)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b(BlockRadiantBeacon.COLOR)).func_193349_f();
        TileEntityBeacon.BeamSegment beamSegment = new TileEntityBeacon.BeamSegment(defaultColor);
        this.beamSegments.add(beamSegment);
        boolean flag = true;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int height = y + 1; height < 256; ++height) {
            float[] color;
            block12: {
                IBlockState state = this.field_145850_b.func_180495_p((BlockPos)pos.func_181079_c(x, height, z));
                if (state.func_177230_c() == Blocks.field_150399_cn) {
                    color = ((EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlass.field_176547_a)).func_193349_f();
                } else {
                    if (state.func_177230_c() != Blocks.field_150397_co || !(state.func_177230_c() instanceof BlockAir)) {
                        if (state.getLightOpacity((IBlockAccess)this.field_145850_b, (BlockPos)pos) >= 15) {
                            this.field_146015_k = false;
                            this.beamSegments.clear();
                            break;
                        }
                        float[] customColor = state.func_177230_c().getBeaconColorMultiplier(state, this.field_145850_b, (BlockPos)pos, this.func_174877_v());
                        if (customColor != null) {
                            color = customColor;
                            break block12;
                        } else {
                            beamSegment.func_177262_a();
                            continue;
                        }
                    }
                    color = ((EnumDyeColor)state.func_177229_b((IProperty)BlockStainedGlassPane.field_176245_a)).func_193349_f();
                }
            }
            if (!flag) {
                color = new float[]{(beamSegment.func_177263_b()[0] + color[0]) / 2.0f, (beamSegment.func_177263_b()[1] + color[1]) / 2.0f, (beamSegment.func_177263_b()[2] + color[2]) / 2.0f};
            }
            if (Arrays.equals(color, beamSegment.func_177263_b())) {
                beamSegment.func_177262_a();
            } else {
                beamSegment = new TileEntityBeacon.BeamSegment(color);
                this.beamSegments.add(beamSegment);
            }
            flag = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            for (EntityPlayerMP entityplayermp : this.field_145850_b.func_72872_a(EntityPlayerMP.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)x, (double)(y - 4), (double)z).func_72314_b(10.0, 5.0, 10.0))) {
                CriteriaTriggers.field_192131_k.func_192180_a(entityplayermp, (TileEntityBeacon)this);
            }
        }
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<TileEntityBeacon.BeamSegment> func_174907_n() {
        return this.beamSegments;
    }
}

