/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.base;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.stone.alabaster.BlockAlabasterBricks;
import com.teammetallurgy.atum.blocks.stone.ceramic.BlockCeramic;
import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneBricks;
import com.teammetallurgy.atum.blocks.stone.porphyry.BlockPorphyryBricks;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;

public class BlockAtumStairs
extends BlockStairs {
    private static final Map<BlockLimestoneBricks.BrickType, Block> BRICK_STAIRS = Maps.newEnumMap(BlockLimestoneBricks.BrickType.class);
    private static final Map<BlockAlabasterBricks.Type, Block> ALABASTER_STAIRS = Maps.newEnumMap(BlockAlabasterBricks.Type.class);
    private static final Map<BlockAlabasterBricks.Type, Block> PORPHYRY_STAIRS = Maps.newEnumMap(BlockAlabasterBricks.Type.class);
    private static final Map<EnumDyeColor, Block> CERAMIC_STAIRS = Maps.newEnumMap(EnumDyeColor.class);
    private static final Map<BlockAtumPlank.WoodType, Block> WOOD_STAIRS = Maps.newEnumMap(BlockAtumPlank.WoodType.class);

    public BlockAtumStairs(IBlockState modelState) {
        super(modelState);
        this.field_149783_u = true;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT));
    }

    public static void registerLimestoneStairs() {
        for (BlockLimestoneBricks.BrickType type : BlockLimestoneBricks.BrickType.values()) {
            BlockAtumStairs brickStair = new BlockAtumStairs(BlockLimestoneBricks.getBrick(type).func_176223_P());
            BRICK_STAIRS.put(type, (Block)brickStair);
            AtumRegistry.registerBlock((Block)brickStair, type.func_176610_l() + "_stairs");
        }
    }

    public static Block getBrickStairs(BlockLimestoneBricks.BrickType type) {
        return BRICK_STAIRS.get((Object)type);
    }

    public static void registerWoodStairs() {
        for (BlockAtumPlank.WoodType type : BlockAtumPlank.WoodType.values()) {
            BlockAtumStairs woodStair = new BlockAtumStairs(BlockAtumPlank.getPlank(type).func_176223_P());
            WOOD_STAIRS.put(type, (Block)woodStair);
            AtumRegistry.registerBlock((Block)woodStair, type.func_176610_l() + "_stairs");
            OreDictHelper.add((Block)woodStair, "stairWood");
        }
    }

    public static Block getWoodStairs(BlockAtumPlank.WoodType type) {
        return WOOD_STAIRS.get((Object)type);
    }

    public static void registerAlabasterStairs() {
        for (BlockAlabasterBricks.Type type : BlockAlabasterBricks.Type.values()) {
            BlockAtumStairs alabasterStair = new BlockAtumStairs(BlockAlabasterBricks.getBrick(type).func_176223_P());
            ALABASTER_STAIRS.put(type, (Block)alabasterStair);
            AtumRegistry.registerBlock((Block)alabasterStair, "alabaster_" + type.func_176610_l() + "_stairs");
        }
    }

    public static Block getAlabasterStairs(BlockAlabasterBricks.Type type) {
        return ALABASTER_STAIRS.get((Object)type);
    }

    public static void registerPorphyryStairs() {
        for (BlockAlabasterBricks.Type type : BlockAlabasterBricks.Type.values()) {
            BlockAtumStairs alabasterStair = new BlockAtumStairs(BlockPorphyryBricks.getBrick(type).func_176223_P());
            PORPHYRY_STAIRS.put(type, (Block)alabasterStair);
            AtumRegistry.registerBlock((Block)alabasterStair, "porphyry_" + type.func_176610_l() + "_stairs");
        }
    }

    public static Block getPorphyryStairs(BlockAlabasterBricks.Type type) {
        return PORPHYRY_STAIRS.get((Object)type);
    }

    public static void registerCeramicStairs() {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockAtumStairs ceramicStair = new BlockAtumStairs(BlockCeramic.getCeramicBlocks(color).func_176223_P());
            CERAMIC_STAIRS.put(color, (Block)ceramicStair);
            AtumRegistry.registerBlock((Block)ceramicStair, "ceramic_stairs_" + color.func_176610_l());
        }
    }

    public static Block getCeramicStairs(EnumDyeColor color) {
        return CERAMIC_STAIRS.get(color);
    }
}

