/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.omniwand.util;

import com.invadermonky.omniwand.config.ConfigHandler;
import com.invadermonky.omniwand.config.ConfigTags;
import com.invadermonky.omniwand.registry.Registry;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class WandHelper {
    public static String getModName(String mod) {
        return Loader.instance().getIndexedModList().containsKey(mod) ? ((ModContainer)Loader.instance().getIndexedModList().get(mod)).getName() : "";
    }

    public static String getModOrAlias(String modId) {
        return ConfigTags.getModAlias(modId);
    }

    public static String getModOrAlias(ItemStack stack) {
        return WandHelper.getModOrAlias(stack.func_77973_b().getCreatorModId(stack));
    }

    public static String getModOrAlias(IBlockState state) {
        return WandHelper.getModOrAlias(state.func_177230_c().getRegistryName().func_110624_b());
    }

    public static boolean isOmniwand(ItemStack stack) {
        return stack.func_77973_b() == Registry.OMNIWAND || WandHelper.isTransformedWand(stack);
    }

    public static boolean isTransformedWand(ItemStack stack) {
        return stack.func_77973_b() != Registry.OMNIWAND && WandHelper.getIsTransforming(stack) && !WandHelper.getWandData(stack).func_82582_d();
    }

    public static ItemStack getTransformedStack(ItemStack stack, String mod, boolean removeStack) {
        ItemStack newStack;
        String wandSlot = WandHelper.getModSlot(stack);
        if (stack.func_190926_b() || wandSlot.equals(mod) || !WandHelper.isOmniwand(stack)) {
            return stack;
        }
        NBTTagCompound wandData = WandHelper.getWandData(stack).func_74737_b();
        if (!wandData.func_74764_b(mod)) {
            mod = "omniwand";
        }
        if (!removeStack) {
            String displayName = WandHelper.getDisplayNameCache(stack);
            stack.func_151001_c(displayName);
            WandHelper.cleanStackTags(stack);
            NBTTagCompound currentStackTag = new NBTTagCompound();
            stack.func_77955_b(currentStackTag);
            wandData.func_74782_a(wandSlot, (NBTBase)currentStackTag);
        }
        if (wandData.func_74764_b(mod) && !mod.equals("omniwand")) {
            newStack = new ItemStack(wandData.func_74775_l(mod));
            wandData.func_82580_o(mod);
        } else {
            newStack = new ItemStack(Registry.OMNIWAND);
            wandData.func_82580_o("omniwand");
        }
        WandHelper.setWandData(newStack, wandData);
        WandHelper.setModSlot(newStack, mod);
        WandHelper.setAutoMode(newStack, newStack.func_77973_b() == Registry.OMNIWAND);
        WandHelper.setIsTransforming(newStack, newStack.func_77973_b() != Registry.OMNIWAND);
        if (newStack.func_77973_b() != Registry.OMNIWAND) {
            WandHelper.setDisplayNameCache(newStack, newStack.func_82833_r());
            String displayName = TextFormatting.RESET + new TextComponentTranslation("omniwand:sudo_name", new Object[]{TextFormatting.GREEN + newStack.func_82833_r() + TextFormatting.RESET}).func_150254_d();
            newStack.func_151001_c(displayName);
        }
        return newStack;
    }

    public static ItemStack removeItemFromWand(ItemStack stack, boolean isBroken, Consumer<ItemStack> consumer) {
        if (stack.func_190926_b() || !WandHelper.isOmniwand(stack) || stack.func_77973_b() == Registry.OMNIWAND) {
            return stack;
        }
        ItemStack original = stack.func_77946_l();
        ItemStack wandStack = WandHelper.getTransformedStack(stack, "omniwand", true);
        if (!isBroken) {
            original.func_151001_c(WandHelper.getDisplayNameCache(original));
            WandHelper.cleanStackTags(original);
            consumer.accept(original);
        }
        return wandStack;
    }

    public static void cleanStackTags(ItemStack stack) {
        if (stack.func_77973_b() == Registry.OMNIWAND) {
            return;
        }
        NBTTagCompound tag = WandHelper.getStackTag(stack);
        tag.func_82580_o("omniwand:data");
        tag.func_82580_o("omniwand:modSlot");
        tag.func_82580_o("omniwand:display");
        tag.func_82580_o("omniwand:transforming");
        tag.func_82580_o("omniwand:auto");
        String defaultName = stack.func_77973_b().func_77653_i(stack);
        if (stack.func_82833_r().equals(defaultName)) {
            tag.func_82580_o("display");
        }
        if (tag.func_82582_d()) {
            stack.func_77982_d(null);
        } else {
            stack.func_77982_d(tag);
        }
    }

    public static NBTTagCompound getWandData(ItemStack stack) {
        return WandHelper.getStackTag(stack).func_74775_l("omniwand:data");
    }

    public static void setWandData(ItemStack stack, NBTTagCompound tag) {
        WandHelper.getStackTag(stack).func_74782_a("omniwand:data", (NBTBase)tag);
    }

    public static boolean getAutoMode(ItemStack stack) {
        if (!WandHelper.getStackTag(stack).func_74764_b("omniwand:auto") && stack.func_77973_b() == Registry.OMNIWAND) {
            WandHelper.getStackTag(stack).func_74757_a("omniwand:auto", ConfigHandler.autoTransform);
        }
        return WandHelper.getStackTag(stack).func_74767_n("omniwand:auto");
    }

    public static void setAutoMode(ItemStack stack, boolean autoMode) {
        WandHelper.getStackTag(stack).func_74757_a("omniwand:auto", autoMode && ConfigHandler.autoTransform);
    }

    public static boolean getIsTransforming(ItemStack stack) {
        return stack.func_77942_o() && WandHelper.getStackTag(stack).func_74764_b("omniwand:transforming");
    }

    public static void setIsTransforming(ItemStack stack, boolean isTransforming) {
        WandHelper.getStackTag(stack).func_74757_a("omniwand:transforming", isTransforming);
    }

    public static String getDisplayNameCache(ItemStack stack) {
        NBTTagCompound tag = WandHelper.getStackTag(stack);
        return tag.func_74764_b("omniwand:display") ? tag.func_74779_i("omniwand:display") : stack.func_82833_r();
    }

    public static void setDisplayNameCache(ItemStack stack, String displayName) {
        WandHelper.getStackTag(stack).func_74778_a("omniwand:display", displayName);
    }

    public static String getModSlot(ItemStack stack) {
        NBTTagCompound tag = WandHelper.getStackTag(stack);
        return tag.func_74764_b("omniwand:modSlot") ? tag.func_74779_i("omniwand:modSlot") : "omniwand";
    }

    public static void setModSlot(ItemStack stack, String modName) {
        WandHelper.getStackTag(stack).func_74778_a("omniwand:modSlot", modName);
    }

    public static NBTTagCompound getStackTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

