/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.omniwand.recipes;

import com.invadermonky.omniwand.config.ConfigTags;
import com.invadermonky.omniwand.registry.Registry;
import com.invadermonky.omniwand.util.WandHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class AttachmentRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    public AttachmentRecipe() {
        this.setRegistryName(new ResourceLocation("omniwand", "attachment"));
    }

    public boolean func_77569_a(InventoryCrafting inv, @NotNull World worldIn) {
        boolean foundWand = false;
        boolean foundTarget = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.isTarget(stack) && !foundTarget) {
                foundTarget = true;
                continue;
            }
            if (stack.func_77973_b() == Registry.OMNIWAND && !foundWand) {
                foundWand = true;
                continue;
            }
            return false;
        }
        return foundWand && foundTarget;
    }

    @NotNull
    public ItemStack func_77572_b(InventoryCrafting inv) {
        String mod;
        ItemStack wand = ItemStack.field_190927_a;
        ItemStack target = ItemStack.field_190927_a;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() == Registry.OMNIWAND) {
                wand = stack;
                continue;
            }
            target = stack;
        }
        ItemStack wandCopy = wand.func_77946_l();
        NBTTagCompound wandData = WandHelper.getWandData(wandCopy);
        String modClean = mod = WandHelper.getModOrAlias(target);
        int i = 0;
        if (!ConfigTags.isTransformItem(target)) {
            mod = modClean + i++;
        }
        while (wandData.func_74764_b(mod)) {
            mod = modClean + i++;
        }
        WandHelper.setIsTransforming(target, false);
        NBTTagCompound targetCmp = new NBTTagCompound();
        target.func_77955_b(targetCmp);
        wandData.func_74782_a(mod, (NBTBase)targetCmp);
        WandHelper.setWandData(wandCopy, wandData);
        WandHelper.setIsTransforming(wandCopy, false);
        WandHelper.setAutoMode(wandCopy, true);
        return wandCopy;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @NotNull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public boolean isTarget(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() == 1 && !WandHelper.isOmniwand(stack)) {
            String mod = WandHelper.getModOrAlias(stack);
            return !mod.equals("omniwand") && ConfigTags.canItemStackAttach(stack);
        }
        return false;
    }
}

