/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.omniwand.items;

import com.invadermonky.omniwand.Omniwand;
import com.invadermonky.omniwand.config.ConfigHandler;
import com.invadermonky.omniwand.config.ConfigTags;
import com.invadermonky.omniwand.util.WandHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemWand
extends Item {
    public ItemWand() {
        this.setRegistryName(new ResourceLocation("omniwand", "wand"));
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77625_d(1);
    }

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World worldIn, EntityPlayer playerIn, @NotNull EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Omniwand.proxy.openWandGui(playerIn, stack);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@NotNull ItemStack wandStack, @Nullable World worldIn, @NotNull List<String> tooltip, @NotNull ITooltipFlag flagIn) {
        NBTTagCompound wandData = WandHelper.getWandData(wandStack);
        if (!wandData.func_150296_c().isEmpty() && GuiScreen.func_146272_n()) {
            ArrayList keys = new ArrayList(wandData.func_150296_c());
            Collections.sort(keys);
            String currentMod = "";
            for (String key : keys) {
                ItemStack storedItem = new ItemStack(wandData.func_74775_l(key));
                if (storedItem.func_190926_b()) continue;
                String name = WandHelper.getDisplayNameCache(storedItem);
                String mod = WandHelper.getModOrAlias(storedItem);
                if (ConfigHandler.restrictTooltip) {
                    if (!mod.equals(key) || !ConfigTags.isTransformItem(storedItem)) continue;
                    name = TextFormatting.GREEN + WandHelper.getModName(mod) + TextFormatting.AQUA + " \u2520> " + name;
                    tooltip.add(name);
                    continue;
                }
                if (!currentMod.equals(mod)) {
                    currentMod = mod;
                    tooltip.add(TextFormatting.GREEN + WandHelper.getModName(currentMod));
                }
                name = (key.equals(mod) ? TextFormatting.AQUA + " \u2520>" : " \u2520 ") + name;
                tooltip.add(name);
            }
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.omniwand:shiftinfo", (Object[])new Object[0]));
        }
    }
}

