/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.omniwand.config;

import com.invadermonky.omniwand.config.ConfigHandler;
import com.invadermonky.omniwand.util.LogHelper;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class ConfigTags {
    private static final THashMap<String, String> MOD_ALIASES = new THashMap();
    private static final THashSet<String> TRANSFORM_ITEMS = new THashSet(3);
    private static final THashMap<String, THashSet<String>> BLACKLIST = new THashMap();
    private static final THashMap<String, THashSet<String>> WHITELIST = new THashMap();
    private static final String MOD = "mod";
    private static final String ITEM = "item";
    private static final String NAME = "name";

    public static String getModAlias(String modId) {
        return (String)MOD_ALIASES.getOrDefault((Object)modId, (Object)modId);
    }

    public static boolean isTransformItem(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        String itemId = stack.func_77973_b().getRegistryName().toString();
        return TRANSFORM_ITEMS.contains((Object)itemId) || TRANSFORM_ITEMS.contains((Object)(itemId + ":" + stack.func_77960_j()));
    }

    public static boolean canItemStackAttach(ItemStack stack) {
        String itemMod = stack.func_77973_b().getCreatorModId(stack);
        String itemId = stack.func_77973_b().getRegistryName().toString();
        String metaId = itemId + ":" + stack.func_77960_j();
        String itemName = stack.func_77973_b().getRegistryName().func_110623_a();
        if (TRANSFORM_ITEMS.contains((Object)itemId) || TRANSFORM_ITEMS.contains((Object)metaId)) {
            return true;
        }
        if (((THashSet)WHITELIST.get((Object)ITEM)).contains((Object)itemId) || ((THashSet)WHITELIST.get((Object)ITEM)).contains((Object)metaId)) {
            return true;
        }
        if (((THashSet)BLACKLIST.get((Object)ITEM)).contains((Object)itemId) || ((THashSet)BLACKLIST.get((Object)ITEM)).contains((Object)itemId)) {
            return false;
        }
        if (((THashSet)BLACKLIST.get((Object)MOD)).contains((Object)itemMod)) {
            return false;
        }
        if (((THashSet)WHITELIST.get((Object)MOD)).contains((Object)itemMod)) {
            return true;
        }
        for (String name : (THashSet)BLACKLIST.get((Object)NAME)) {
            if (!itemName.contains(name)) continue;
            return false;
        }
        for (String name : (THashSet)WHITELIST.get((Object)NAME)) {
            if (!itemName.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static EnumHand getConfiguredHand() {
        return ConfigHandler.offhandTransform ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND;
    }

    private static void syncAliases() {
        MOD_ALIASES.clear();
        Pattern pattern = Pattern.compile("^([^=]+)=([^=]+)$");
        for (String alias : ConfigHandler.modAliases) {
            Matcher matcher = pattern.matcher(alias);
            if (matcher.find()) {
                MOD_ALIASES.put((Object)matcher.group(1), (Object)matcher.group(2));
                continue;
            }
            LogHelper.error("Invalid mod alias string: " + alias);
        }
    }

    private static void syncTransformItems() {
        TRANSFORM_ITEMS.clear();
        Pattern pattern = Pattern.compile("^([^:\\s]+:[^:\\s]+:?\\d*)$");
        for (String item : ConfigHandler.transformItems) {
            Matcher matcher = pattern.matcher(item = item.replace(" ", "").trim());
            if (matcher.find()) {
                TRANSFORM_ITEMS.add((Object)item);
                continue;
            }
            LogHelper.error("Invalid transform item string: " + item);
        }
    }

    private static void syncFilterList(THashMap<String, THashSet<String>> filterMap, String[] filterConfig) {
        filterMap.clear();
        filterMap.put((Object)MOD, (Object)new THashSet());
        filterMap.put((Object)ITEM, (Object)new THashSet());
        filterMap.put((Object)NAME, (Object)new THashSet());
        Pattern pattern = Pattern.compile("^(mod|item|name)=(.+)$");
        for (String filter : filterConfig) {
            Matcher matcher = pattern.matcher(filter);
            if (matcher.find()) {
                switch (matcher.group(1).toLowerCase()) {
                    case "mod": {
                        filterMap.putIfAbsent((Object)MOD, (Object)new THashSet());
                        ((THashSet)filterMap.get((Object)MOD)).add((Object)matcher.group(2));
                        break;
                    }
                    case "item": {
                        filterMap.putIfAbsent((Object)ITEM, (Object)new THashSet());
                        ((THashSet)filterMap.get((Object)ITEM)).add((Object)matcher.group(2));
                        break;
                    }
                    case "name": {
                        filterMap.putIfAbsent((Object)NAME, (Object)new THashSet());
                        ((THashSet)filterMap.get((Object)NAME)).add((Object)matcher.group(2));
                    }
                }
                continue;
            }
            LogHelper.error("Invalid filter string: " + filter);
        }
    }

    public static void syncConfig() {
        ConfigTags.syncAliases();
        ConfigTags.syncTransformItems();
        ConfigTags.syncFilterList(BLACKLIST, ConfigHandler.attachBlacklist);
        ConfigTags.syncFilterList(WHITELIST, ConfigHandler.attachWhitelist);
    }

    static {
        ConfigTags.syncConfig();
    }
}

