/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.omniwand.client;

import com.invadermonky.omniwand.Omniwand;
import com.invadermonky.omniwand.network.MessageGuiTransform;
import com.invadermonky.omniwand.util.WandHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiWand
extends GuiScreen {
    ItemStack wand;

    public GuiWand(ItemStack wand) {
        this.wand = wand;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTooltip(int x, int y, List<String> tooltipData) {
        int color1 = 0x505000FF;
        int color2 = -267386864;
        boolean lighting = GL11.glGetBoolean((int)2896);
        if (lighting) {
            RenderHelper.func_74518_a();
        }
        if (!tooltipData.isEmpty()) {
            int scaledHeight;
            int bottom;
            ScaledResolution res;
            int scaledWidth;
            int right;
            int var3;
            int var2;
            int var1 = 0;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            for (var2 = 0; var2 < tooltipData.size(); ++var2) {
                var3 = fontRenderer.func_78256_a(tooltipData.get(var2));
                if (var3 <= var1) continue;
                var1 = var3;
            }
            var2 = x + 12;
            var3 = y - 12;
            int var4 = 8;
            if (tooltipData.size() > 1) {
                var4 += 2 + (tooltipData.size() - 1) * 10;
            }
            if ((right = var2 + var1 + 5) > (scaledWidth = (res = new ScaledResolution(Minecraft.func_71410_x())).func_78326_a())) {
                bottom = right - scaledWidth;
                var2 -= bottom;
            }
            if ((bottom = var3 + var4 + 5) > (scaledHeight = res.func_78328_b())) {
                int diff = bottom - scaledHeight;
                var3 -= diff;
            }
            float z = 300.0f;
            GuiWand.drawGradientRect(var2 - 3, var3 - 4, z, var2 + var1 + 3, var3 - 3, color2, color2);
            GuiWand.drawGradientRect(var2 - 3, var3 + var4 + 3, z, var2 + var1 + 3, var3 + var4 + 4, color2, color2);
            GuiWand.drawGradientRect(var2 - 3, var3 - 3, z, var2 + var1 + 3, var3 + var4 + 3, color2, color2);
            GuiWand.drawGradientRect(var2 - 4, var3 - 3, z, var2 - 3, var3 + var4 + 3, color2, color2);
            GuiWand.drawGradientRect(var2 + var1 + 3, var3 - 3, z, var2 + var1 + 4, var3 + var4 + 3, color2, color2);
            int var5 = (color1 & 0xFFFFFF) >> 1 | color1 & 0xFF000000;
            GuiWand.drawGradientRect(var2 - 3, var3 - 3 + 1, z, var2 - 3 + 1, var3 + var4 + 3 - 1, color1, var5);
            GuiWand.drawGradientRect(var2 + var1 + 2, var3 - 3 + 1, z, var2 + var1 + 3, var3 + var4 + 3 - 1, color1, var5);
            GuiWand.drawGradientRect(var2 - 3, var3 - 3, z, var2 + var1 + 3, var3 - 3 + 1, color1, color1);
            GuiWand.drawGradientRect(var2 - 3, var3 + var4 + 2, z, var2 + var1 + 3, var3 + var4 + 3, var5, var5);
            GlStateManager.func_179097_i();
            for (int i = 0; i < tooltipData.size(); ++i) {
                String tooltip = tooltipData.get(i);
                fontRenderer.func_175063_a(tooltip, (float)var2, (float)var3, -1);
                if (i == 0) {
                    var3 += 2;
                }
                var3 += 10;
            }
            GlStateManager.func_179126_j();
        }
        if (!lighting) {
            RenderHelper.func_74518_a();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawGradientRect(int par1, int par2, float z, int par3, int par4, int par5, int par6) {
        float red_1 = (float)(par5 >> 24 & 0xFF) / 255.0f;
        float green_1 = (float)(par5 >> 16 & 0xFF) / 255.0f;
        float blue_1 = (float)(par5 >> 8 & 0xFF) / 255.0f;
        float alpha_1 = (float)(par5 & 0xFF) / 255.0f;
        float red_2 = (float)(par6 >> 24 & 0xFF) / 255.0f;
        float green_2 = (float)(par6 >> 16 & 0xFF) / 255.0f;
        float blue_2 = (float)(par6 >> 8 & 0xFF) / 255.0f;
        float alpha_2 = (float)(par6 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b((double)par3, (double)par2, (double)z).func_181666_a(green_1, blue_1, alpha_1, red_1).func_181675_d();
        buff.func_181662_b((double)par1, (double)par2, (double)z).func_181666_a(green_1, blue_1, alpha_1, red_1).func_181675_d();
        buff.func_181662_b((double)par1, (double)par4, (double)z).func_181666_a(green_2, blue_2, alpha_2, red_2).func_181675_d();
        buff.func_181662_b((double)par3, (double)par4, (double)z).func_181666_a(green_2, blue_2, alpha_2, red_2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        HashMap<String, ItemStack> stackMap = new HashMap<String, ItemStack>();
        if (this.wand.func_77942_o()) {
            NBTTagCompound data = WandHelper.getWandData(this.wand);
            ArrayList keys = new ArrayList(data.func_150296_c());
            Collections.sort(keys);
            for (String key : keys) {
                NBTTagCompound compoundTag = data.func_74775_l(key);
                if (compoundTag.func_82582_d()) continue;
                stackMap.put(key, new ItemStack(compoundTag));
            }
        }
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        int centerX = res.func_78326_a() / 2;
        int centerY = res.func_78328_b() / 2;
        int amountPerRow = Math.min(12, Math.max(8, stackMap.size() / 3));
        int rows = (int)Math.ceil((double)stackMap.size() / (double)amountPerRow);
        int iconSize = 20;
        int startX = centerX - amountPerRow * iconSize / 2;
        int startY = centerY - rows * iconSize + Math.min(90, Math.max(40, 10 * rows));
        int padding = 4;
        int extra = 2;
        GuiWand.func_73734_a((int)(startX - padding), (int)(startY - padding), (int)(startX + iconSize * amountPerRow + padding), (int)(startY + iconSize * rows + padding), (int)0x22000000);
        GuiWand.func_73734_a((int)(startX - padding - extra), (int)(startY - padding - extra), (int)(startX + iconSize * amountPerRow + padding + extra), (int)(startY + iconSize * rows + padding + extra), (int)0x22000000);
        ItemStack tooltipStack = ItemStack.field_190927_a;
        String itemKey = "";
        if (!stackMap.isEmpty()) {
            RenderHelper.func_74520_c();
            int i = 0;
            for (String key : stackMap.keySet()) {
                int x = startX + i % amountPerRow * iconSize;
                int y = startY + i / amountPerRow * iconSize;
                ++i;
                if (mouseX > x && mouseY > y && mouseX <= x + 16 && mouseY <= y + 16) {
                    tooltipStack = (ItemStack)stackMap.get(key);
                    itemKey = key;
                    y -= 2;
                }
                this.field_146296_j.func_180450_b((ItemStack)stackMap.get(key), x, y);
            }
            RenderHelper.func_74518_a();
        }
        if (!tooltipStack.func_190926_b()) {
            String name = WandHelper.getDisplayNameCache(tooltipStack);
            String mod = TextFormatting.GRAY + WandHelper.getModName(WandHelper.getModOrAlias(tooltipStack));
            GuiWand.renderTooltip(mouseX, mouseY, Arrays.asList(name, mod));
            if (Mouse.isButtonDown((int)0)) {
                Omniwand.network.sendToServer((IMessage)new MessageGuiTransform(itemKey));
                this.field_146297_k.func_147108_a(null);
            }
        }
    }
}

