/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.recipe.TransmutatorRecipes;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.Transmutator")
public class Transmutator {
    @ZenMethod
    public static void addTransmutation(IItemStack input, IItemStack output, float exp) {
        ACMTMisc.TASKS.add(new Add(ACMT.toStack(input), ACMT.toStack(output), exp));
    }

    @ZenMethod
    public static void removeTransmutation(IItemStack input) {
        Transmutator.removeTransmutationInput(input);
    }

    @ZenMethod
    public static void removeTransmutationInput(IItemStack input) {
        ACMTMisc.TASKS.add(new RemoveInput(ACMT.toStack(input)));
    }

    @ZenMethod
    public static void removeTransmutationOutput(IItemStack output) {
        ACMTMisc.TASKS.add(new RemoveOutput(ACMT.toStack(output)));
    }

    @ZenMethod
    public static void addFuel(IItemStack stack, int burnTime) {
        ACMTMisc.TASKS.add(new AddFuel(ACMT.toStack(stack), burnTime));
    }

    @ZenMethod
    public static void removeFuel(IItemStack stack) {
        ACMTMisc.TASKS.add(new RemoveFuel(ACMT.toStack(stack)));
    }

    @ZenMethod
    public static void removeAll() {
        ACMTMisc.TASKS.add(new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            TransmutatorRecipes.instance().getTransmutationList().clear();
        }

        public String describe() {
            return "Removing all Transmutator recipes";
        }
    }

    private static class RemoveFuel
    implements IAction {
        private ItemStack stack;

        public RemoveFuel(ItemStack stack) {
            this.stack = stack;
        }

        public void apply() {
            ACMT.TRANSMUTATOR_FUELS.put(this.stack, 0);
        }

        public String describe() {
            return String.format("Removing %s as Transmutator fuel", ACMT.getItemNameSafely(this.stack));
        }
    }

    private static class AddFuel
    implements IAction {
        private ItemStack stack;
        private int burnTime;

        public AddFuel(ItemStack stack, int burnTime) {
            this.stack = stack;
            this.burnTime = burnTime;
        }

        public void apply() {
            ACMT.TRANSMUTATOR_FUELS.put(this.stack, this.burnTime);
        }

        public String describe() {
            return String.format("Adding %s as Transmutator fuel with a burntime of %d ", ACMT.getItemNameSafely(this.stack), this.burnTime);
        }
    }

    private static class RemoveOutput
    implements IAction {
        private ItemStack output;

        public RemoveOutput(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            TransmutatorRecipes.instance().getTransmutationList().entrySet().removeIf(e -> APIUtils.areStacksEqual((ItemStack)this.output, (ItemStack)((ItemStack)e.getValue())));
        }

        public String describe() {
            return "Removing Transmutation recipe(s) for " + ACMT.getItemNameSafely(this.output);
        }
    }

    private static class RemoveInput
    implements IAction {
        private ItemStack input;

        public RemoveInput(ItemStack input) {
            this.input = input;
        }

        public void apply() {
            TransmutatorRecipes.instance().getTransmutationList().entrySet().removeIf(e -> APIUtils.areStacksEqual((ItemStack)this.input, (ItemStack)((ItemStack)e.getKey())));
        }

        public String describe() {
            return "Removing Transmutation recipe with input: " + ACMT.getItemNameSafely(this.input);
        }
    }

    private static class Add
    implements IAction {
        private ItemStack input;
        private ItemStack output;
        private float exp;

        public Add(ItemStack input, ItemStack output, float exp) {
            this.input = input;
            this.output = output;
            this.exp = exp;
        }

        public void apply() {
            AbyssalCraftAPI.addTransmutation((ItemStack)this.input, (ItemStack)this.output, (float)this.exp);
        }

        public String describe() {
            return "Adding Transmutation recipe for " + ACMT.getItemNameSafely(this.output);
        }
    }
}

