/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconSummonRitual;
import com.shinoow.abyssalcraft.api.ritual.RitualRegistry;
import com.shinoow.abyssalcraft.common.util.ACLogger;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.data.IData;
import crafttweaker.api.item.IIngredient;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.SummonRitual")
public class SummonRitual {
    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, String entity, IIngredient[] offerings) {
        SummonRitual.addRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, entity, offerings, false);
    }

    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, String entity, IIngredient[] offerings, IData customNBT) {
        SummonRitual.addRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, entity, offerings, false, customNBT);
    }

    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, String entity, IIngredient[] offerings, boolean nbt) {
        SummonRitual.addRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, entity, offerings, nbt, null);
    }

    @ZenMethod
    public static void addRitual(String unlocalizedName, int bookType, int dimension, float requiredEnergy, boolean requiresSacrifice, String entity, IIngredient[] offerings, boolean nbt, IData customNBT) {
        Class e;
        Object[] offers = ACMT.toObjects(offerings);
        if (entity.split(":").length == 2) {
            e = EntityList.getClass((ResourceLocation)new ResourceLocation(entity));
        } else {
            try {
                e = Class.forName(entity);
            }
            catch (ClassNotFoundException ex) {
                ACLogger.warning((String)"Could not find Entity class %s", (Object[])new Object[]{entity});
                return;
            }
        }
        if (e == null) {
            return;
        }
        NecronomiconSummonRitual ritual = new NecronomiconSummonRitual(unlocalizedName, bookType, dimension, requiredEnergy, requiresSacrifice, e, offers);
        if (nbt) {
            ritual.setNBTSensitive();
        }
        if (customNBT != null) {
            ritual.setCustomNBT((NBTTagCompound)NBTConverter.from((IData)customNBT));
        }
        ACMTMisc.TASKS.add(new Add(ritual));
    }

    @ZenMethod
    public static void removeRitual(String entity) {
        Class e;
        if (entity.split(":").length == 2) {
            e = EntityList.getClass((ResourceLocation)new ResourceLocation(entity));
        } else {
            try {
                e = Class.forName(entity);
            }
            catch (ClassNotFoundException ex) {
                ACLogger.warning((String)"Could not find Entity class %s", (Object[])new Object[]{entity});
                return;
            }
        }
        if (e == null) {
            return;
        }
        ACMTMisc.TASKS.add(new Remove(e));
    }

    @ZenMethod
    public static void removeAll() {
        ACMTMisc.TASKS.add(new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        private RemoveAll() {
        }

        public void apply() {
            RitualRegistry.instance().getRituals().removeIf(r -> r instanceof NecronomiconSummonRitual);
        }

        public String describe() {
            return "Removing all Summoning Ritual recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final Class<? extends Entity> entity;

        public Remove(Class<? extends Entity> entity) {
            this.entity = entity;
        }

        public void apply() {
            ArrayList<NecronomiconSummonRitual> temp = new ArrayList<NecronomiconSummonRitual>();
            for (NecronomiconRitual necronomiconRitual : RitualRegistry.instance().getRituals()) {
                if (!(necronomiconRitual instanceof NecronomiconSummonRitual)) continue;
                temp.add((NecronomiconSummonRitual)necronomiconRitual);
            }
            for (NecronomiconSummonRitual necronomiconSummonRitual : temp) {
                if (!this.entity.getName().equals(necronomiconSummonRitual.getEntity().getName()) || EntityList.func_191306_a(this.entity) != EntityList.func_191306_a((Class)necronomiconSummonRitual.getEntity())) continue;
                RitualRegistry.instance().getRituals().remove(necronomiconSummonRitual);
            }
        }

        public String describe() {
            return "Removing Necronomicon Summoning Ritual for " + (EntityList.func_191306_a(this.entity) != null ? EntityList.func_191306_a(this.entity).toString() : "");
        }
    }

    private static class Add
    implements IAction {
        private final NecronomiconSummonRitual ritual;

        public Add(NecronomiconSummonRitual ritual) {
            this.ritual = ritual;
        }

        public void apply() {
            RitualRegistry.instance().registerRitual((NecronomiconRitual)this.ritual);
        }

        public String describe() {
            return "Adding Necronomicon Summoning Ritual for " + (EntityList.func_191306_a((Class)this.ritual.getEntity()) != null ? EntityList.func_191306_a((Class)this.ritual.getEntity()).toString() : "");
        }
    }
}

