/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.acintegration.integrations.minetweaker;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.necronomicon.CraftingStack;
import com.shinoow.abyssalcraft.api.necronomicon.INecroData;
import com.shinoow.abyssalcraft.api.necronomicon.NecroData;
import com.shinoow.acintegration.integrations.minetweaker.ACMT;
import com.shinoow.acintegration.integrations.minetweaker.ACMTMisc;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import net.minecraft.util.ResourceLocation;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.abyssalcraft.necronomicon.internal")
public class InternalNecroData {
    @ZenMethod
    public static void addChapter(String chapteridentifier, String chaptertitle, String necrodataidentifier) {
        NecroData.Chapter chapter = new NecroData.Chapter(chapteridentifier, chaptertitle, 0);
        ACMTMisc.TASKS.add(new AddChapter(chapter, necrodataidentifier));
    }

    @ZenMethod
    public static void removeChapter(String chapteridentifier, String necrodataidentifier) {
        ACMTMisc.TASKS.add(new RemoveChapter(chapteridentifier, necrodataidentifier));
    }

    @ZenMethod
    public static void addNormalPage(int pageNum, String pagetext, String chapteridentifier, String necrodataidentifier) {
        NecroData.Page page = new NecroData.Page(pageNum, "title", 0, pagetext);
        ACMTMisc.TASKS.add(new AddPage(page, chapteridentifier, necrodataidentifier));
    }

    @ZenMethod
    public static void addItemPage(int pageNum, IItemStack stack, String pagetext, String chapteridentifier, String necrodataidentifier) {
        NecroData.Page page = new NecroData.Page(pageNum, "title", 0, (Object)ACMT.toStack(stack), pagetext);
        ACMTMisc.TASKS.add(new AddPage(page, chapteridentifier, necrodataidentifier));
    }

    @ZenMethod
    public static void addImagePage(int pageNum, String resourcepath, String pagetext, String chapteridentifier, String necrodataidentifier) {
        NecroData.Page page = new NecroData.Page(pageNum, "title", 0, (Object)new ResourceLocation(resourcepath), pagetext);
        ACMTMisc.TASKS.add(new AddPage(page, chapteridentifier, necrodataidentifier));
    }

    @ZenMethod
    public static void addCraftingPage(int pageNum, IIngredient thing, String pagetext, String chapteridentifier, String necrodataidentifier) {
        NecroData.Page page = new NecroData.Page(pageNum, "title", 0, (Object)new CraftingStack(ACMT.toObject(thing)), pagetext);
        ACMTMisc.TASKS.add(new AddPage(page, chapteridentifier, necrodataidentifier));
    }

    @ZenMethod
    public static void addCraftingPage(int pageNum, IIngredient thing, IIngredient[] stuff, String pagetext, String chapteridentifier, String necrodataidentifier) {
        NecroData.Page page = new NecroData.Page(pageNum, "title", 0, (Object)new CraftingStack(ACMT.toObject(thing), ACMT.toObjects(stuff)), pagetext);
        ACMTMisc.TASKS.add(new AddPage(page, chapteridentifier, necrodataidentifier));
    }

    @ZenMethod
    public static void addURLPage(int pageNum, String url, String pagetext, String chapteridentifier, String necrodataidentifier) {
        NecroData.Page page = new NecroData.Page(pageNum, "title", 0, (Object)url, pagetext);
        ACMTMisc.TASKS.add(new AddPage(page, chapteridentifier, necrodataidentifier));
    }

    @ZenMethod
    public static void removePage(int pageNum, String chapteridentifier, String necrodataidentifier) {
        ACMTMisc.TASKS.add(new RemovePage(pageNum, chapteridentifier, necrodataidentifier));
    }

    private static class RemovePage
    implements IAction {
        private final int pageNum;
        private final String chapteridentifier;
        private final String necrodataidentifier;

        public RemovePage(int pageNum, String chapteridentifier, String necrodataidentifier) {
            this.pageNum = pageNum;
            this.chapteridentifier = chapteridentifier;
            this.necrodataidentifier = necrodataidentifier;
        }

        public void apply() {
            for (INecroData d : AbyssalCraftAPI.getInternalNDHandler().getInternalNecroData(this.necrodataidentifier).getContainedData()) {
                if (!(d instanceof NecroData.Chapter) || !d.getIdentifier().equals(this.chapteridentifier)) continue;
                ((NecroData.Chapter)d).removePage(this.pageNum);
                return;
            }
        }

        public String describe() {
            return "Removing Page from Necronomicon Chapter " + this.chapteridentifier + " in the NecroData " + this.necrodataidentifier;
        }
    }

    private static class AddPage
    implements IAction {
        private final NecroData.Page page;
        private final String chapteridentifier;
        private final String necrodataidentifier;

        public AddPage(NecroData.Page page, String chapteridentifier, String necrodataidentifier) {
            this.page = page;
            this.chapteridentifier = chapteridentifier;
            this.necrodataidentifier = necrodataidentifier;
        }

        public void apply() {
            AbyssalCraftAPI.getInternalNDHandler().addPage(this.page, this.necrodataidentifier, this.chapteridentifier);
        }

        public String describe() {
            return "Adding Page to Necronomicon Chapter " + this.chapteridentifier + " in the NecroData " + this.necrodataidentifier;
        }
    }

    private static class RemoveChapter
    implements IAction {
        private final String chapteridentifier;
        private final String necrodataidentifier;

        public RemoveChapter(String chapter, String necrodata) {
            this.chapteridentifier = chapter;
            this.necrodataidentifier = necrodata;
        }

        public void apply() {
            AbyssalCraftAPI.getInternalNDHandler().removeChapter(this.necrodataidentifier, this.chapteridentifier);
        }

        public String describe() {
            return "Removing Necronomicon Chapter " + this.chapteridentifier + " from the NecroData " + this.necrodataidentifier;
        }
    }

    private static class AddChapter
    implements IAction {
        private final NecroData.Chapter chapter;
        private final String identifier;

        public AddChapter(NecroData.Chapter chapter, String identifier) {
            this.chapter = chapter;
            this.identifier = identifier;
        }

        public void apply() {
            AbyssalCraftAPI.getInternalNDHandler().addChapter(this.chapter, this.identifier);
        }

        public String describe() {
            return "Adding Necronomicon Chapter " + this.chapter.getIdentifier() + " to the NecroData " + this.identifier;
        }
    }
}

