/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.gadgetry;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import epicsquid.gadgetry.machines.recipe.DistillingRecipe;
import moretweaker.Inputs;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.gadgetry.Distillery")
@ZenRegister
@ModOnly(value="gadgetrymachines")
public class Distillery {
    @ZenMethod
    public static void add(IItemStack output, ILiquidStack fluidOutput, IIngredient input, ILiquidStack fluidInput) {
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final Object in = Inputs.getObject(input);
        final FluidStack fluidOut = InputHelper.toFluid((ILiquidStack)fluidOutput);
        final FluidStack fluidIn = InputHelper.toFluid((ILiquidStack)fluidInput);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                DistillingRecipe recipe = new DistillingRecipe(fluidIn, fluidOut, in, out);
                DistillingRecipe.recipes.add(recipe);
                DistillingRecipe.distillable_items.add(recipe.inputs.get(0));
                DistillingRecipe.distillable_fluids.add(recipe.fluid_in.getFluid());
            }

            public String describe() {
                return "Adds a Distillery-Recipe";
            }
        });
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        final Object obj = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                DistillingRecipe.recipes.removeIf(recipe -> Inputs.matchesForRemoval(obj, recipe.getOutput()));
            }

            public String describe() {
                return "Removes Distillery-Recipes by Item-Output";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                DistillingRecipe.recipes.clear();
            }

            public String describe() {
                return "Removes all recipes for the distillery";
            }
        });
    }
}

