/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.draconicevolution;

import com.blamejared.mtlib.helpers.InputHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.FusionRecipeAPI;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.fusioncrafting.SimpleFusionRecipe;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import moretweaker.Inputs;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import stanhebben.zenscript.annotations.ZenProperty;

@ZenClass(value="moretweaker.draconicevolution.FusionCrafting")
@ZenRegister
@ModOnly(value="draconicevolution")
public class FusionCrafting {
    @ZenProperty
    public static final int BASIC = 0;
    @ZenProperty
    public static final int WYVERN = 1;
    @ZenProperty
    public static final int DRACONIC = 2;
    @ZenProperty
    public static final int CHAOTIC = 3;

    @ZenMethod
    public static void add(IItemStack output, IItemStack catalyst, final int tier, long energyCost, IIngredient[] ingredients) {
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final ItemStack cl = InputHelper.toStack((IItemStack)catalyst);
        final Object[] in = Inputs.getObjects(ingredients);
        final long energyPerIngredient = energyCost / (long)in.length;
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                FusionRecipeAPI.addRecipe((IFusionRecipe)new SimpleFusionRecipe(out, cl, energyPerIngredient, tier, in));
            }

            public String describe() {
                return "Adds a FusionCrafting-Recipe";
            }
        });
    }

    @ZenMethod
    public static void remove(IIngredient catalyst) {
        final Object obj = Inputs.getObject(catalyst);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList<IFusionRecipe> removal = new ArrayList<IFusionRecipe>();
                for (IFusionRecipe recipe : FusionRecipeAPI.getRecipes()) {
                    if (!Inputs.matchesForRemoval(obj, recipe.getRecipeCatalyst())) continue;
                    removal.add(recipe);
                }
                for (IFusionRecipe recipe : removal) {
                    FusionRecipeAPI.removeRecipe((IFusionRecipe)recipe);
                }
            }

            public String describe() {
                return "Removes FusionCrafting-Recipes by catalyst";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList allRecipes = new ArrayList(FusionRecipeAPI.getRecipes());
                for (IFusionRecipe recipe : allRecipes) {
                    FusionRecipeAPI.removeRecipe((IFusionRecipe)recipe);
                }
            }

            public String describe() {
                return "Removes all FusionCrafting recipes";
            }
        });
    }
}

