/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.betweenlands;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import moretweaker.CraftingPart;
import moretweaker.Inputs;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thebetweenlands.api.IBetweenlandsAPI;
import thebetweenlands.api.recipes.IDruidAltarRecipe;
import thebetweenlands.common.BetweenlandsAPI;
import thebetweenlands.common.recipe.misc.DruidAltarRecipe;

@ZenClass(value="moretweaker.betweenlands.DruidAltar")
@ZenRegister
@ModOnly(value="thebetweenlands")
public class DruidAltar {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs) {
        if (inputs.length != 4) {
            CraftTweakerAPI.logError((String)"inputs.length not 4 in DruidAltar#addRecipe");
        }
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final CraftingPart[] in = Inputs.getParts(inputs);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                for (ItemStack in0 : in[0].toStackList()) {
                    for (ItemStack in1 : in[1].toStackList()) {
                        for (ItemStack in2 : in[2].toStackList()) {
                            for (ItemStack in3 : in[3].toStackList()) {
                                BetweenlandsAPI.getInstance().registerDruidAltarRecipe((IDruidAltarRecipe)new DruidAltarRecipe(in0, in1, in2, in3, out));
                            }
                        }
                    }
                }
            }

            public String describe() {
                return "Adds some DruidAltar recipes";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList recipes = new ArrayList();
                BetweenlandsAPI.getInstance().getDruidAltarRecipes().forEach(r -> {
                    if (r instanceof DruidAltarRecipe && Inputs.matchesForRemoval(out, ((DruidAltarRecipe)r).getDefaultOutput())) {
                        recipes.add(r);
                    }
                });
                recipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterDruidAltarRecipe(arg_0));
            }

            public String describe() {
                return "Removes some DruidAltar recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList allRecipes = new ArrayList(BetweenlandsAPI.getInstance().getDruidAltarRecipes());
                allRecipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterDruidAltarRecipe(arg_0));
            }

            public String describe() {
                return "Removes all recipes for the Druid Altar";
            }
        });
    }
}

