/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.aoa;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.lang.reflect.Field;
import moretweaker.Inputs;
import moretweaker.MoreTweaker;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.tslat.aoa3.crafting.recipes.InfusionTableRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.aoa.InfusionTable")
@ZenRegister
@ModOnly(value="aoa3")
public class InfusionTable {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack mainInput, IIngredient[] inputs, final @Optional(valueLong=1L) int infusionLevel, final @Optional(valueLong=0L) int xpMin, final @Optional(valueLong=0L) int xpMax) {
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final ItemStack in1 = InputHelper.toStack((IItemStack)mainInput);
        if (inputs.length <= 0 || inputs.length > 9) {
            CraftTweakerAPI.logError((String)"No or more than 9 inputs given for InfusionTable recipe");
        }
        final NonNullList in2 = NonNullList.func_191196_a();
        for (IIngredient ingredient : inputs) {
            in2.add((Object)Inputs.getPart((IIngredient)ingredient).ingredient);
        }
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                MoreTweaker.forgeAdd(IRecipe.class, new InfusionTableRecipe("", out, in1, in2, infusionLevel, xpMin, xpMax));
            }

            public String describe() {
                return "Adds an AOA InfusionTable recipe with item output.";
            }
        });
    }

    @ZenMethod
    public static void addRecipe(final String enchantmentId, final int enchantmentLevel, IIngredient[] inputs, final @Optional(valueLong=1L) int infusionLevel, final @Optional(valueLong=0L) int xpMin, final @Optional(valueLong=0L) int xpMax) {
        if (inputs.length <= 0 || inputs.length > 9) {
            CraftTweakerAPI.logError((String)"No or more than 9 inputs given for InfusionTable recipe");
        }
        final NonNullList in2 = NonNullList.func_191196_a();
        for (IIngredient ingredient : inputs) {
            in2.add((Object)Inputs.getPart((IIngredient)ingredient).ingredient);
        }
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                Enchantment ench = Enchantment.func_180305_b((String)enchantmentId);
                if (ench == null) {
                    CraftTweakerAPI.logError((String)"No enchantment found for given key to create an AOA InfusionTable recipe");
                    return;
                }
                MoreTweaker.forgeAdd(IRecipe.class, new InfusionTableRecipe("", ench, enchantmentLevel, in2, infusionLevel, xpMin, xpMax));
            }

            public String describe() {
                return "Adds an AOA InfusionTable recipe with enchantment output.";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                MoreTweaker.forgeRemove(IRecipe.class, r -> r instanceof InfusionTableRecipe && !((InfusionTableRecipe)r).isEnchanting() && Inputs.matchesForRemoval(out, r.func_77571_b()));
            }

            public String describe() {
                return "Removes AOA InfusionTable recipes by item output.";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(final String enchantmentId) {
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                Enchantment ench = Enchantment.func_180305_b((String)enchantmentId);
                if (ench == null) {
                    CraftTweakerAPI.logError((String)"No enchantment found for given key to remove AOA InfusionTables");
                    return;
                }
                try {
                    Field field = InfusionTableRecipe.class.getDeclaredField("enchantment");
                    field.setAccessible(true);
                    MoreTweaker.forgeRemove(IRecipe.class, r -> {
                        try {
                            return r instanceof InfusionTableRecipe && ((InfusionTableRecipe)r).isEnchanting() && field.get(r) == ench;
                        }
                        catch (IllegalAccessException e) {
                            CraftTweakerAPI.logError((String)("Could not get enchntment field of InfusionTableRecipe class  to remove recipes: " + e.getMessage()));
                            return false;
                        }
                    });
                }
                catch (ReflectiveOperationException e) {
                    CraftTweakerAPI.logError((String)("Could not get enchntment field of InfusionTableRecipe class  to remove recipes: " + e.getMessage()));
                }
            }

            public String describe() {
                return "Removes AOA InfusionTable recipes by enchantment output.";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        MoreTweaker.queuePostInitAction(new IAction(){

            public void apply() {
                MoreTweaker.forgeRemove(IRecipe.class, r -> r instanceof InfusionTableRecipe);
            }

            public String describe() {
                return "Removes all recipes for the AOA InfusionTable";
            }
        });
    }
}

