/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.exciter;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import java.util.UUID;
import javax.annotation.Nullable;
import jotato.quantumflux.ConfigMan;
import jotato.quantumflux.Logger;
import jotato.quantumflux.helpers.BlockHelpers;
import jotato.quantumflux.redflux.RedfluxField;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileRFExciter
extends TileEntity
implements IEnergyProvider,
IEnergyStorage,
ITickable {
    public UUID owner;
    public int lastEnergyUsed;
    public EnumFacing targetDirection = null;
    public int maxOut = ConfigMan.rfExciter_output;
    public int upgradeCount;
    public float wirelessEfficiency = 1.0f;

    public String getOwner() {
        return this.owner == null ? null : this.owner.toString();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return RedfluxField.requestEnergy(maxExtract, simulate, this.getOwner());
    }

    public int getEnergyStored(EnumFacing from) {
        return 0;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return 0;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_145829_t() {
        super.func_145829_t();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("upgradeCount", this.upgradeCount);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.toString());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        block2: {
            super.func_145839_a(tag);
            this.upgradeCount = tag.func_74762_e("upgradeCount");
            try {
                this.owner = UUID.fromString(tag.func_74779_i("owner"));
            }
            catch (IllegalArgumentException ex) {
                if (this.field_145850_b.field_72995_K) break block2;
                Logger.error("HEY YOU! An RF Exciter at %d, %d, %d has no owner, please replace it.", this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
            }
        }
    }

    public void func_73660_a() {
        IEnergyStorage receiver;
        BlockPos targetBlock;
        TileEntity tile;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.owner == null) {
            return;
        }
        if (this.targetDirection == null) {
            this.targetDirection = (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockHelpers.FACING);
        }
        if ((tile = this.field_145850_b.func_175625_s(targetBlock = this.func_174877_v().func_177971_a(this.targetDirection.func_176730_m()))) == null) {
            return;
        }
        if (tile instanceof IEnergyReceiver) {
            int netPower = this.getNetPower();
            int tosend = this.extractEnergy(null, netPower, true);
            int needed = ((IEnergyReceiver)tile).receiveEnergy(this.targetDirection.func_176734_d(), tosend, true);
            int willSend = Math.round((float)needed * this.wirelessEfficiency);
            ((IEnergyReceiver)tile).receiveEnergy(this.targetDirection.func_176734_d(), willSend, false);
            if (needed > 0) {
                this.func_70296_d();
            }
            this.lastEnergyUsed = needed;
            this.extractEnergy(null, needed, false);
        } else if (tile.hasCapability(CapabilityEnergy.ENERGY, this.targetDirection.func_176734_d()) && (receiver = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, this.targetDirection.func_176734_d())).canReceive()) {
            int netPower = this.getNetPower();
            int tosend = this.extractEnergy(null, netPower, true);
            int needed = receiver.receiveEnergy(tosend, true);
            int willSend = Math.round((float)needed * this.wirelessEfficiency);
            receiver.receiveEnergy(willSend, false);
            if (needed > 0) {
                this.func_70296_d();
            }
            this.lastEnergyUsed = needed;
            this.extractEnergy(null, needed, false);
        }
    }

    public int getNetPower() {
        int power = this.maxOut + this.upgradeCount * 100;
        return power;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canExtract() {
        return this.canConnectEnergy(null);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(null, maxExtract, simulate);
    }

    public boolean canReceive() {
        return false;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }
}

