/*
 * Decompiled with CFR 0.152.
 */
package jotato.quantumflux.machines.cluster;

import cofh.redstoneflux.api.IEnergyProvider;
import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import javax.annotation.Nullable;
import jotato.quantumflux.blocks.TileBase;
import jotato.quantumflux.machines.cluster.QuibitClusterSettings;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileQuibitCluster
extends TileBase
implements IEnergyProvider,
IEnergyReceiver,
IEnergyStorage,
ITickable {
    protected EnergyStorage localEnergyStorage;
    private int transferRate;
    private int capacity;
    public int level;
    public int lastUsed;

    public TileQuibitCluster(QuibitClusterSettings settings) {
        this.transferRate = settings.transferRate;
        this.capacity = settings.capacity;
        this.level = settings.level;
        this.localEnergyStorage = new EnergyStorage(this.capacity, this.transferRate);
    }

    public TileQuibitCluster() {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.localEnergyStorage.writeToNBT(energyTag);
        tag.func_74782_a("Energy", (NBTBase)energyTag);
        tag.func_74768_a("XferRate", this.transferRate);
        tag.func_74768_a("Capacity", this.capacity);
        tag.func_74768_a("Level", this.level);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.level = tag.func_74762_e("Level");
        this.capacity = tag.func_74762_e("Capacity");
        this.transferRate = tag.func_74762_e("XferRate");
        if (this.localEnergyStorage == null) {
            this.localEnergyStorage = new EnergyStorage(this.capacity, this.transferRate);
        }
        NBTTagCompound energyTag = tag.func_74775_l("Energy");
        this.localEnergyStorage.readFromNBT(energyTag);
    }

    @SideOnly(value=Side.CLIENT)
    public int getBufferScaled(int scale) {
        double stored = this.getEnergyStored(null);
        double max = this.getMaxEnergyStored(null);
        double v = stored / max * (double)scale;
        return (int)v;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (EnumFacing dir : EnumFacing.values()) {
            int used;
            int tosend;
            IEnergyReceiver receiver;
            BlockPos targetBlock = this.func_174877_v().func_177971_a(dir.func_176730_m());
            TileEntity tile = this.field_145850_b.func_175625_s(targetBlock);
            if (tile == null) continue;
            if (tile instanceof TileQuibitCluster) {
                return;
            }
            if (tile instanceof IEnergyReceiver) {
                receiver = (IEnergyReceiver)tile;
                if (!receiver.canConnectEnergy(dir.func_176734_d())) continue;
                tosend = this.localEnergyStorage.extractEnergy(this.transferRate, true);
                used = receiver.receiveEnergy(dir.func_176734_d(), tosend, false);
                if (used > 0) {
                    this.func_70296_d();
                }
                this.lastUsed = used;
                this.localEnergyStorage.extractEnergy(used, false);
                continue;
            }
            if (!tile.hasCapability(CapabilityEnergy.ENERGY, dir.func_176734_d()) || !(receiver = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d())).canReceive()) continue;
            tosend = this.localEnergyStorage.extractEnergy(this.transferRate, true);
            used = receiver.receiveEnergy(tosend, false);
            if (used > 0) {
                this.func_70296_d();
            }
            this.lastUsed = used;
            this.localEnergyStorage.extractEnergy(used, false);
        }
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        int used = this.localEnergyStorage.receiveEnergy(maxReceive, simulate);
        if (used > 0 && !simulate) {
            this.func_70296_d();
        }
        return used;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        int given = this.localEnergyStorage.extractEnergy(maxExtract, simulate);
        if (given > 0 && !simulate) {
            this.func_70296_d();
        }
        return given;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.localEnergyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.localEnergyStorage.getMaxEnergyStored();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canExtract() {
        return this.canConnectEnergy(null);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return this.extractEnergy(null, maxExtract, simulate);
    }

    public boolean canReceive() {
        return this.canConnectEnergy(null);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.receiveEnergy(null, maxReceive, simulate);
    }

    public int getEnergyStored() {
        return this.getEnergyStored(null);
    }

    public int getMaxEnergyStored() {
        return this.getMaxEnergyStored(null);
    }
}

