/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.worldserver;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleMobSpawning
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        String methodDesc;
        String methodName;
        ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
        MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.WORLD_SERVER_TICK.getName(), methodDesc = ObfNameHelper.Methods.WORLD_SERVER_TICK.getDescriptor());
        if (method != null) {
            ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
            if (this.findChunksForSpawningReplacement(method, transformedName)) {
                ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                return ASMHelper.writeClassToBytes(classNode, 3);
            }
        } else {
            ASMDebugHelper.logNotFound(methodName, transformedName);
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.WORLD_SERVER.getName()};
    }

    @Override
    public String getModuleName() {
        return "mobSpawningEvent";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean findChunksForSpawningReplacement(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.find(method.instructions, (AbstractInsnNode)ObfNameHelper.Methods.FIND_CHUNKS_FOR_SPAWNING.toInsnNode(182));
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        method.instructions.set(target, (AbstractInsnNode)ObfNameHelper.Methods.ON_MOB_SPAWNING_EVENT.toInsnNode(184));
        return true;
    }
}

