/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.minecraftserver;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMUtils;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleMinecraftServerTickEvent
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (ASMUtils.doesClassEqual(transformedName, ObfNameHelper.Classes.MINECRAFT_SERVER)) {
            String methodDesc;
            String methodName;
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.MINECRAFT_SERVER_UPDATE_TIME_LIGHT_ENTITIES.getName(), methodDesc = ObfNameHelper.Methods.MINECRAFT_SERVER_UPDATE_TIME_LIGHT_ENTITIES.getDescriptor());
            if (method != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.addMinecraftServerForgeEventWrapper(method, transformedName) && this.addMinecraftServerForgeEventWrapper2(method, transformedName)) {
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                    return ASMHelper.writeClassToBytes(classNode, 3);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.MINECRAFT_SERVER.getName()};
    }

    @Override
    public String getModuleName() {
        return "minecraftServerPostTickEvent";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean addMinecraftServerForgeEventWrapper(MethodNode method, String transformedName) {
        InsnList toFind = new InsnList();
        toFind.add((AbstractInsnNode)ObfNameHelper.Methods.FML_COMMON_HANDLER_INSTANCE.toInsnNode(184));
        toFind.add((AbstractInsnNode)new VarInsnNode(25, 6));
        toFind.add((AbstractInsnNode)ObfNameHelper.Methods.FML_COMMON_HANDLER_PRE_WORLD_TICK.toInsnNode(182));
        AbstractInsnNode start = ASMHelper.find(method.instructions, toFind);
        if (start == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " 1", transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ON_WORLD_SERVER_FORGE_POST_EVENT.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(154, label));
        method.instructions.insertBefore(start, toInject);
        AbstractInsnNode end = ASMHelper.move(start, 2);
        method.instructions.insert(end, (AbstractInsnNode)label);
        return true;
    }

    private boolean addMinecraftServerForgeEventWrapper2(MethodNode method, String transformedName) {
        InsnList toFind = new InsnList();
        toFind.add((AbstractInsnNode)ObfNameHelper.Methods.FML_COMMON_HANDLER_INSTANCE.toInsnNode(184));
        toFind.add((AbstractInsnNode)new VarInsnNode(25, 6));
        toFind.add((AbstractInsnNode)ObfNameHelper.Methods.FML_COMMON_HANDLER_POST_WORLD_TICK.toInsnNode(182));
        AbstractInsnNode start = ASMHelper.find(method.instructions, toFind);
        if (start == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " 2", transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ON_WORLD_SERVER_FORGE_POST_EVENT.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(154, label));
        method.instructions.insertBefore(start, toInject);
        AbstractInsnNode end = ASMHelper.move(start, 2);
        method.instructions.insert(end, (AbstractInsnNode)label);
        return true;
    }
}

