/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module;

import com.bloodnbonesgaming.bnbgamingcore.core.BNBGamingCorePlugin;
import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ObfHelper;

public class ModuleASMAdditionHelper
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        MethodNode mNode;
        Map<String, List<FieldNode>> fieldAdditions = ASMAdditionRegistry.getFieldAdditions();
        Map<String, List<MethodNode>> methodAdditions = ASMAdditionRegistry.getMethodAdditions();
        ClassNode cNode = ASMHelper.readClassFromBytes(bytes);
        if (fieldAdditions != null && !fieldAdditions.isEmpty()) {
            try {
                mNode = ASMHelper.findMethodNodeOfClass(cNode, "get", "(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                if (mNode != null) {
                    this.transformGet(cNode, mNode, fieldAdditions);
                    BNBGamingCorePlugin.log.info("Successfully populated ASMAdditionHelper.get");
                } else {
                    BNBGamingCorePlugin.log.error("Failed to find a 'get' method to populate! Things aren't going to work!");
                }
                mNode = ASMHelper.findMethodNodeOfClass(cNode, "set", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
                if (mNode != null) {
                    this.transformSet(cNode, mNode, fieldAdditions);
                    BNBGamingCorePlugin.log.info("Successfully populated ASMAdditionHelper.set");
                } else {
                    BNBGamingCorePlugin.log.error("Failed to find a 'set' method to populate! Things aren't going to work!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (methodAdditions != null && !methodAdditions.isEmpty()) {
            mNode = ASMHelper.findMethodNodeOfClass(cNode, "invoke", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Object;");
            if (mNode != null) {
                this.transformInvoke(cNode, mNode, methodAdditions);
                BNBGamingCorePlugin.log.info("Successfully populated ASMAdditionHelper.invoke");
            } else {
                BNBGamingCorePlugin.log.error("Failed to find an 'invoke' method to populate! Things aren't going to work!");
            }
        }
        return ASMHelper.writeClassToBytesNoDeobf(cNode);
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.ASMADDITIONHELPER.getName()};
    }

    @Override
    public String getModuleName() {
        return "transformASMAdditionHelperClass";
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    private void transformGet(ClassNode cNode, MethodNode node, Map<String, List<FieldNode>> fieldAdditions) {
        cNode.methods.remove(node);
        MethodVisitor mVis = cNode.visitMethod(node.access, node.name, node.desc, node.signature, node.exceptions.toArray(new String[0]));
        GeneratorAdapter genA = new GeneratorAdapter(node.access, new Method(node.name, node.desc), mVis);
        genA.visitCode();
        for (Map.Entry<String, List<FieldNode>> entry : fieldAdditions.entrySet()) {
            for (FieldNode fNode : entry.getValue()) {
                Label label = genA.newLabel();
                genA.loadArg(1);
                genA.visitLdcInsn((Object)fNode.name);
                genA.invokeVirtual(Type.getObjectType((String)"java/lang/Object"), new Method("equals", "(Ljava/lang/Object;)Z"));
                genA.ifZCmp(153, label);
                genA.loadArg(0);
                genA.checkCast(Type.getObjectType((String)entry.getKey()));
                genA.getField(Type.getObjectType((String)entry.getKey()), fNode.name, Type.getType((String)fNode.desc));
                genA.box(Type.getType((String)fNode.desc));
                genA.returnValue();
                genA.visitLabel(label);
                mVis.visitFrame(3, 0, null, 0, null);
            }
        }
        genA.push((String)null);
        genA.returnValue();
        genA.visitMaxs(2, 3);
        genA.endMethod();
    }

    private void transformSet(ClassNode cNode, MethodNode node, Map<String, List<FieldNode>> fieldAdditions) {
        cNode.methods.remove(node);
        MethodVisitor mVis = cNode.visitMethod(node.access, node.name, node.desc, node.signature, node.exceptions.toArray(new String[0]));
        GeneratorAdapter genA = new GeneratorAdapter(node.access, new Method(node.name, node.desc), mVis);
        genA.visitCode();
        for (Map.Entry<String, List<FieldNode>> entry : fieldAdditions.entrySet()) {
            for (FieldNode fNode : entry.getValue()) {
                Label label = genA.newLabel();
                genA.loadArg(1);
                genA.visitLdcInsn((Object)fNode.name);
                genA.invokeVirtual(Type.getObjectType((String)"java/lang/Object"), new Method("equals", "(Ljava/lang/Object;)Z"));
                genA.ifZCmp(153, label);
                genA.loadArg(0);
                genA.checkCast(Type.getObjectType((String)entry.getKey()));
                genA.loadArg(2);
                Type fieldT = Type.getType((String)fNode.desc);
                genA.unbox(fieldT);
                genA.putField(Type.getObjectType((String)entry.getKey()), fNode.name, Type.getType((String)fNode.desc));
                genA.visitLabel(label);
                mVis.visitFrame(3, 0, null, 0, null);
            }
        }
        genA.returnValue();
        genA.visitMaxs(2, 4);
        genA.endMethod();
    }

    private void transformInvoke(ClassNode cNode, MethodNode node, Map<String, List<MethodNode>> methodAdditions) {
        cNode.methods.remove(node);
        MethodVisitor mVis = cNode.visitMethod(node.access, node.name, node.desc, node.signature, node.exceptions.toArray(new String[0]));
        GeneratorAdapter genA = new GeneratorAdapter(node.access, new Method(node.name, node.desc), mVis);
        genA.visitCode();
        for (Map.Entry<String, List<MethodNode>> entry : methodAdditions.entrySet()) {
            for (MethodNode mNode : entry.getValue()) {
                Label label = genA.newLabel();
                genA.loadArg(1);
                genA.visitLdcInsn((Object)mNode.name);
                genA.invokeVirtual(Type.getObjectType((String)"java/lang/Object"), new Method("equals", "(Ljava/lang/Object;)Z"));
                genA.ifZCmp(153, label);
                genA.loadArg(0);
                genA.checkCast(Type.getObjectType((String)entry.getKey()));
                Type[] types = Type.getArgumentTypes((String)mNode.desc);
                if (types.length != 0) {
                    for (int i = 0; i < types.length; ++i) {
                        genA.loadArg(2);
                        genA.push(i);
                        String wrapped = this.wrap(types[i].getDescriptor());
                        genA.arrayLoad(wrapped == null ? types[i] : Type.getObjectType((String)wrapped));
                        genA.unbox(types[i]);
                    }
                }
                genA.invokeVirtual(Type.getObjectType((String)entry.getKey()), new Method(mNode.name, mNode.desc));
                Type methodType = Type.getMethodType((String)mNode.desc);
                genA.box(methodType.getReturnType());
                genA.returnValue();
                genA.visitLabel(label);
                mVis.visitFrame(3, 0, null, 0, null);
            }
        }
        genA.push((String)null);
        genA.returnValue();
        genA.visitMaxs(2, 4);
        genA.endMethod();
    }

    private MethodInsnNode wrapNode(String desc) {
        String className = this.wrap(desc);
        if (className == null) {
            return null;
        }
        return new MethodInsnNode(184, className, "valueOf", "(" + desc + ")" + ObfHelper.getDescriptor(className), false);
    }

    private String wrap(String className) {
        if (className.equals("Z")) {
            return "java/lang/Boolean";
        }
        if (className.equals("B")) {
            return "java/lang/Byte";
        }
        if (className.equals("C")) {
            return "java/lang/Character";
        }
        if (className.equals("S")) {
            return "java/lang/Short";
        }
        if (className.equals("I")) {
            return "java/lang/Integer";
        }
        if (className.equals("J")) {
            return "java/lang/Long";
        }
        if (className.equals("F")) {
            return "java/lang/Float";
        }
        if (className.equals("D")) {
            return "java/lang/Double";
        }
        return null;
    }

    private MethodInsnNode unwrap(String desc) {
        if (desc.equals("Z")) {
            return new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false);
        }
        if (desc.equals("B")) {
            return new MethodInsnNode(182, "java/lang/Byte", "byteValue", "()B", false);
        }
        if (desc.equals("C")) {
            return new MethodInsnNode(182, "java/lang/Character", "charValue", "()C", false);
        }
        if (desc.equals("S")) {
            return new MethodInsnNode(182, "java/lang/Short", "shortValue", "()S", false);
        }
        if (desc.equals("I")) {
            return new MethodInsnNode(182, "java/lang/Integer", "intValue", "()I", false);
        }
        if (desc.equals("J")) {
            return new MethodInsnNode(182, "java/lang/Long", "longValue", "()J", false);
        }
        if (desc.equals("F")) {
            return new MethodInsnNode(182, "java/lang/Float", "floatValue", "()F", false);
        }
        if (desc.equals("D")) {
            return new MethodInsnNode(182, "java/lang/Double", "doubleValue", "()D", false);
        }
        return null;
    }

    private String getReturnType(String desc) {
        return desc.substring(desc.indexOf(")") + 1);
    }

    private String stripDescToClass(String desc) {
        return desc.replaceFirst("L", "").replace(";", "");
    }

    private AbstractInsnNode getIntInsnNode(int i) {
        switch (i) {
            case -1: {
                return new InsnNode(2);
            }
            case 0: {
                return new InsnNode(3);
            }
            case 1: {
                return new InsnNode(4);
            }
            case 2: {
                return new InsnNode(5);
            }
            case 3: {
                return new InsnNode(6);
            }
            case 4: {
                return new InsnNode(7);
            }
            case 5: {
                return new InsnNode(8);
            }
        }
        return new IntInsnNode(16, i);
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry registry) {
    }
}

