/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.Route;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class RouteCache<T extends IGridTileRoute<T, G>, G extends MultiBlockGrid<T>> {
    public T origin;
    public LinkedList<Route<T, G>> outputRoutes;
    public LinkedList<Route<T, G>> stuffableRoutes;
    public HashSet<T> visited;
    public HashSet<T> outputvisited;
    public int maxPathLength;
    public boolean invalid = false;
    private LinkedList<Route<T, G>> validRoutes;
    private boolean isFinishedGenerating;

    public RouteCache(T origin) {
        this(origin, origin.getMaxRange());
    }

    public RouteCache(T origin, int maxPathLength) {
        this.origin = origin;
        this.maxPathLength = maxPathLength;
        this.init();
    }

    public void init() {
        this.outputRoutes = new LinkedList();
        if (this.origin.isOutput()) {
            Route singleOutput = new Route(this.origin);
            singleOutput.routeFinished = true;
            this.outputRoutes.add(singleOutput);
        }
        this.stuffableRoutes = new LinkedList();
        this.validRoutes = new LinkedList();
        this.validRoutes.add(new Route(this.origin));
        this.visited = new HashSet();
        this.visited.add(this.origin);
        this.outputvisited = new HashSet();
        if (this.origin.isOutput()) {
            this.outputvisited.add(this.origin);
        }
    }

    public synchronized void generateCache() {
        while (this.processStep()) {
        }
    }

    public boolean processStep() {
        if (this.isFinishedGenerating || this.invalid) {
            return false;
        }
        boolean continueLoop = false;
        LinkedList<Route<T, G>> newRoutes = new LinkedList<Route<T, G>>();
        for (Route route : this.validRoutes) {
            this.moveForwards(route, newRoutes);
            if (route.routeFinished) continue;
            continueLoop = true;
        }
        this.validRoutes.addAll(newRoutes);
        if (!continueLoop) {
            this.finished();
        }
        return continueLoop;
    }

    private void finished() {
        this.visited.clear();
        this.outputvisited.clear();
        this.validRoutes.clear();
        this.isFinishedGenerating = true;
        Collections.sort(this.outputRoutes);
    }

    public void moveForwards(Route<T, G> route, LinkedList<Route<T, G>> newRoutes) {
        boolean foundRoute = false;
        IGridTileRoute foundPath = null;
        if (route.routeFinished) {
            return;
        }
        if (route.pathDirections.size() > this.maxPathLength) {
            route.routeFinished = true;
            return;
        }
        byte foundDir = -1;
        for (byte i = 0; i < 6; i = (byte)(i + 1)) {
            Object validTile = route.endPoint.getCachedTile(i);
            if (validTile == null) continue;
            if (!this.visited.contains(validTile)) {
                this.visited.add(validTile);
                validTile.onNeighborBlockChange();
                if (validTile.canStuffItem()) {
                    this.stuffableRoutes.add(new Route<T, G>(route, validTile, i, true));
                }
                if (!foundRoute) {
                    foundPath = validTile;
                    foundDir = i;
                    foundRoute = true;
                } else {
                    newRoutes.add(new Route<T, G>(route, validTile, i, false));
                }
            }
            if (!validTile.isOutput() || this.outputvisited.contains(validTile)) continue;
            this.outputRoutes.add(new Route<T, G>(route, validTile, i, true));
            this.outputvisited.add(validTile);
        }
        if (!foundRoute) {
            route.routeFinished = true;
        } else {
            route.pathDirections.add(foundDir);
            route.pathWeight += foundPath.getWeight();
            route.endPoint = foundPath;
        }
    }

    public boolean isFinishedGenerating() {
        return this.isFinishedGenerating;
    }

    public void reset() {
        this.isFinishedGenerating = false;
        this.init();
    }

    public void invalidate() {
        this.invalid = true;
        this.outputRoutes.clear();
        this.stuffableRoutes.clear();
        this.origin = null;
    }
}

