/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.network;

import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketChangeRange
implements IMessage {
    private int range;

    public PacketChangeRange() {
        this.range = -1;
    }

    public PacketChangeRange(int range) {
        this.range = range;
    }

    public void fromBytes(ByteBuf buf) {
        this.range = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.range);
    }

    public static class Handler
    implements IMessageHandler<PacketChangeRange, IMessage> {
        public IMessage onMessage(PacketChangeRange message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketChangeRange message, MessageContext ctx) {
            EntityPlayerMP playerEntity = ctx.getServerHandler().field_147369_b;
            ItemStack heldItem = GadgetGeneric.getGadget((EntityPlayer)playerEntity);
            if (heldItem.func_190926_b()) {
                return;
            }
            if (message.range >= 0) {
                GadgetUtils.setToolRange(heldItem, message.range);
            } else if (heldItem.func_77973_b() instanceof GadgetBuilding) {
                GadgetBuilding gadgetBuilding = (GadgetBuilding)heldItem.func_77973_b();
                gadgetBuilding.rangeChange((EntityPlayer)playerEntity, heldItem);
            } else if (heldItem.func_77973_b() instanceof GadgetExchanger) {
                GadgetExchanger gadgetExchanger = (GadgetExchanger)heldItem.func_77973_b();
                gadgetExchanger.rangeChange((EntityPlayer)playerEntity, heldItem);
            } else if (heldItem.func_77973_b() instanceof GadgetDestruction) {
                GadgetDestruction gadgetDestruction = (GadgetDestruction)heldItem.func_77973_b();
                gadgetDestruction.switchOverlay((EntityPlayer)playerEntity, heldItem);
            }
        }
    }
}

