/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.common.blocks.ModBlocks;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.common.items.FakeBuilderWorld;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.tools.BuildingModes;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import com.direwolf20.buildinggadgets.common.tools.Sorter;
import com.direwolf20.buildinggadgets.common.tools.ToolRenders;
import com.direwolf20.buildinggadgets.common.tools.UndoState;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class GadgetBuilding
extends GadgetGeneric {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public GadgetBuilding() {
        super("buildingtool");
        this.func_77656_e(SyncedConfig.durabilityBuilder);
    }

    public int getMaxDamage(ItemStack stack) {
        return SyncedConfig.poweredByFE ? 0 : SyncedConfig.durabilityBuilder;
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return SyncedConfig.energyCostBuilder;
    }

    @Override
    public int getDamageCost(ItemStack tool) {
        return SyncedConfig.damageCostBuilder;
    }

    private static void setToolMode(ItemStack tool, BuildingModes mode) {
        NBTTagCompound tagCompound = NBTTool.getOrNewTag(tool);
        tagCompound.func_74778_a("mode", mode.getRegistryName());
    }

    public static BuildingModes getToolMode(ItemStack tool) {
        NBTTagCompound tagCompound = NBTTool.getOrNewTag(tool);
        return BuildingModes.byName(tagCompound.func_74779_i("mode"));
    }

    public static boolean shouldPlaceAtop(ItemStack stack) {
        return !NBTTool.getOrNewTag(stack).func_74767_n("start_inside");
    }

    public static void togglePlaceAtop(EntityPlayer player, ItemStack stack) {
        NBTTool.getOrNewTag(stack).func_74757_a("start_inside", GadgetBuilding.shouldPlaceAtop(stack));
        String prefix = "message.gadget.building.placement";
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation(prefix, new Object[]{new TextComponentTranslation(prefix + (GadgetBuilding.shouldPlaceAtop(stack) ? ".atop" : ".inside"), new Object[0])}).func_150261_e()), true);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, world, list, b);
        list.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.gadget.block", (Object[])new Object[0]) + ": " + GadgetUtils.getToolBlock(stack).func_177230_c().func_149732_F());
        BuildingModes mode = GadgetBuilding.getToolMode(stack);
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.mode", (Object[])new Object[0]) + ": " + (mode == BuildingModes.Surface && GadgetBuilding.getConnectedArea(stack) ? I18n.func_135052_a((String)"tooltip.gadget.connected", (Object[])new Object[0]) + " " : "") + (Object)((Object)mode));
        if (GadgetBuilding.getToolMode(stack) != BuildingModes.BuildToMe) {
            list.add(TextFormatting.LIGHT_PURPLE + I18n.func_135052_a((String)"tooltip.gadget.range", (Object[])new Object[0]) + ": " + GadgetUtils.getToolRange(stack));
        }
        if (GadgetBuilding.getToolMode(stack) == BuildingModes.Surface) {
            list.add(TextFormatting.GOLD + I18n.func_135052_a((String)"tooltip.gadget.fuzzy", (Object[])new Object[0]) + ": " + GadgetBuilding.getFuzzy(stack));
        }
        GadgetBuilding.addInformationRayTraceFluid(list, stack);
        list.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"tooltip.gadget.building.place_atop", (Object[])new Object[0]) + ": " + GadgetBuilding.shouldPlaceAtop(stack));
        this.addEnergyInformation(list, stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else {
                this.build(player, itemstack);
            }
        } else if (!player.func_70093_af()) {
            ToolRenders.updateInventoryCache();
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        BuildingModes mode = BuildingModes.values()[modeInt];
        GadgetBuilding.setToolMode(heldItem, mode);
    }

    public void rangeChange(EntityPlayer player, ItemStack heldItem) {
        int changeAmount;
        int range = GadgetUtils.getToolRange(heldItem);
        int n = changeAmount = GadgetBuilding.getToolMode(heldItem) != BuildingModes.Surface || range % 2 == 0 ? 1 : 2;
        range = player.func_70093_af() ? (range == 1 ? SyncedConfig.maxRange : range - changeAmount) : (range >= SyncedConfig.maxRange ? 1 : range + changeAmount);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_AQUA + new TextComponentTranslation("message.gadget.toolrange", new Object[0]).func_150261_e() + ": " + range), true);
    }

    private boolean build(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        List<BlockPos> coords = GadgetUtils.getAnchor(stack);
        if (coords.size() == 0) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
            if (lookingAt == null) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_178782_a();
            EnumFacing sideHit = lookingAt.field_178784_b;
            coords = BuildingModes.collectPlacementPos(world, player, startBlock, sideHit, stack, startBlock);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        ArrayList<BlockPos> undoCoords = new ArrayList<BlockPos>();
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>(coords);
        ItemStack heldItem = GadgetBuilding.getGadget(player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        IBlockState blockState = GadgetUtils.getToolBlock(heldItem);
        if (blockState != Blocks.field_150350_a.func_176223_P()) {
            IBlockState state = Blocks.field_150350_a.func_176223_P();
            fakeWorld.setWorldAndState(player.field_70170_p, blockState, coordinates);
            for (BlockPos coordinate : coords) {
                if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                    try {
                        state = blockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!this.placeBlock(world, player, coordinate, state)) continue;
                undoCoords.add(coordinate);
            }
            GadgetUtils.clearCachedRemoteInventory();
            if (undoCoords.size() > 0) {
                UndoState undoState = new UndoState(player.field_71093_bK, undoCoords);
                GadgetUtils.pushUndoList(heldItem, undoState);
            }
        }
        Sorter.Blocks.byDistance(coords, player);
        return true;
    }

    public boolean undoBuild(EntityPlayer player) {
        ItemStack heldItem = GadgetBuilding.getGadget(player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        UndoState undoState = GadgetUtils.popUndoList(heldItem);
        if (undoState == null) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.nothingtoundo", new Object[0]).func_150261_e()), true);
            return false;
        }
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            IBlockState currentBlock = Blocks.field_150350_a.func_176223_P();
            List<BlockPos> undoCoords = undoState.coordinates;
            int dimension = undoState.dimension;
            ArrayList<BlockPos> failedRemovals = new ArrayList<BlockPos>();
            ItemStack silkTool = heldItem.func_77946_l();
            silkTool.func_77966_a(Enchantments.field_185306_r, 1);
            for (BlockPos coord : undoCoords) {
                boolean cancelled;
                currentBlock = world.func_180495_p(coord);
                double distance = coord.func_185332_f(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
                boolean sameDim = player.field_71093_bK == dimension;
                boolean bl = cancelled = !GadgetGeneric.EmitEvent.breakBlock(world, coord, currentBlock, player);
                if (distance < 64.0 && sameDim && currentBlock != ModBlocks.effectBlock.func_176223_P() && !cancelled) {
                    if (currentBlock == Blocks.field_150350_a.func_176223_P()) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        currentBlock.func_177230_c().func_180657_a(world, player, coord, currentBlock, world.func_175625_s(coord), silkTool);
                    }
                    world.func_72838_d((Entity)new BlockBuildEntity(world, coord, (EntityLivingBase)player, currentBlock, 2, GadgetUtils.getToolActualBlock(heldItem), false));
                    continue;
                }
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.undofailed", new Object[0]).func_150261_e()), true);
                failedRemovals.add(coord);
            }
            GadgetUtils.clearCachedRemoteInventory();
            if (failedRemovals.size() != 0) {
                UndoState failedState = new UndoState(player.field_71093_bK, failedRemovals);
                GadgetUtils.pushUndoList(heldItem, failedState);
            }
        }
        return true;
    }

    private boolean placeBlock(World world, EntityPlayer player, BlockPos pos, IBlockState setBlock) {
        if (!player.func_175142_cm()) {
            return false;
        }
        if (world.func_189509_E(pos)) {
            return false;
        }
        ItemStack heldItem = GadgetBuilding.getGadget(player);
        if (heldItem.func_190926_b()) {
            return false;
        }
        boolean useConstructionPaste = false;
        ItemStack itemStack = setBlock.func_177230_c().canSilkHarvest(world, pos, setBlock, player) ? InventoryManipulation.getSilkTouchDrop(setBlock) : setBlock.func_177230_c().getPickBlock(setBlock, null, world, pos, player);
        if (itemStack.func_77973_b().equals(Items.field_190931_a)) {
            itemStack = setBlock.func_177230_c().getPickBlock(setBlock, null, world, pos, player);
        }
        NonNullList drops = NonNullList.func_191196_a();
        setBlock.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, setBlock, 0);
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled()) {
            return false;
        }
        ItemStack constructionPaste = new ItemStack((Item)ModItems.constructionPaste);
        if (InventoryManipulation.countItem(itemStack, player, world) < neededItems) {
            if (InventoryManipulation.countPaste(player) < neededItems) {
                return false;
            }
            itemStack = constructionPaste.func_77946_l();
            useConstructionPaste = true;
        }
        if (!this.canUse(heldItem, player)) {
            return false;
        }
        boolean useItemSuccess = useConstructionPaste ? InventoryManipulation.usePaste(player, 1) : InventoryManipulation.useItem(itemStack, player, neededItems, world);
        if (useItemSuccess) {
            this.applyDamage(heldItem, player);
            world.func_72838_d((Entity)new BlockBuildEntity(world, pos, (EntityLivingBase)player, setBlock, 1, GadgetUtils.getToolActualBlock(heldItem), useConstructionPaste));
            return true;
        }
        return false;
    }

    public static ItemStack getGadget(EntityPlayer player) {
        ItemStack stack = GadgetGeneric.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetBuilding)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }
}

