/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.config.fieldmap;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.config.fieldmap.FieldMapper;
import com.direwolf20.buildinggadgets.common.config.fieldmap.FieldWrapper;
import com.direwolf20.buildinggadgets.common.config.fieldmap.ITypeSerializer;
import com.direwolf20.buildinggadgets.common.tools.ArrayUtils;
import com.direwolf20.buildinggadgets.common.tools.NBTTool;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class FieldSerializer {
    private static Set<ITypeSerializer> serializers = new HashSet<ITypeSerializer>();
    private static Map<String, FieldMapper<?, ?>> mappingAdapters = new HashMap();

    private static void addSerializer(ITypeSerializer serializer) {
        serializers.add(serializer);
    }

    private static void addMapper(String id, FieldMapper<?, ?> mapper) {
        Preconditions.checkArgument((!mappingAdapters.containsKey(id) ? 1 : 0) != 0, (Object)"Cannot overwrite already registered adapter!");
        mappingAdapters.put(id, mapper);
    }

    private static FieldWrapper wrapperFor(@Nonnull Field field, @Nullable Object instance, @Nonnull String mapper) {
        return new FieldWrapper(field, mappingAdapters.getOrDefault(mapper, FieldMapper.id(field.getType())), instance);
    }

    private static FieldWrapper wrapperFor(Field field, String mapper) {
        return FieldSerializer.wrapperFor(field, null, mapper);
    }

    @Nullable
    public static NBTBase parseFieldValue(Field field, String mapperId) {
        return FieldSerializer.parseFieldValue(field, null, mapperId);
    }

    @Nullable
    public static NBTBase parseFieldValue(@Nonnull Field field, @Nullable Object instance, @Nonnull String mapperId) {
        field.setAccessible(true);
        FieldWrapper wrapper = FieldSerializer.wrapperFor(field, instance, mapperId);
        NBTBase tag = null;
        for (ITypeSerializer serializer : serializers) {
            try {
                tag = serializer.serializeValue(wrapper);
                if (tag == null) continue;
                return tag;
            }
            catch (IllegalAccessException e) {
                BuildingGadgets.logger.error("Failed to serialize Field " + field.getName() + "! Retrying with different serializer, if possible.", (Throwable)e);
            }
        }
        return tag;
    }

    public static void applyValue(NBTBase nbt, Field field, String mapperId) {
        FieldSerializer.applyValue(nbt, field, null, mapperId);
    }

    public static void applyValue(@Nonnull NBTBase nbt, @Nonnull Field field, @Nullable Object instance, @Nonnull String mapperId) {
        field.setAccessible(true);
        FieldWrapper wrapper = FieldSerializer.wrapperFor(field, instance, mapperId);
        for (ITypeSerializer serializer : serializers) {
            try {
                if (!serializer.applyValue(nbt, wrapper)) continue;
                return;
            }
            catch (IllegalAccessException e) {
                BuildingGadgets.logger.error("Failed to apply Field value to " + field.getName() + "! Retrying with different serializer, if possible.", (Throwable)e);
            }
        }
    }

    public static void init() {
        FieldSerializer.clear();
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)Boolean.TYPE, (Class)Boolean.class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagByte((byte)(field.get(Boolean.TYPE) == false ? 1 : 0));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagByte((byte)(field.get(Boolean.class) == false ? 1 : 0));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByte)) {
                    return false;
                }
                field.set(((NBTTagByte)tag).func_150290_f() == 0, Boolean.TYPE);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByte)) {
                    return false;
                }
                field.set(((NBTTagByte)tag).func_150290_f() == 0, Boolean.class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)Byte.TYPE, (Class)Byte.class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagByte(field.get(Byte.TYPE).byteValue());
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagByte(field.get(Byte.class).byteValue());
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByte)) {
                    return false;
                }
                field.set(((NBTTagByte)tag).func_150290_f(), Byte.TYPE);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByte)) {
                    return false;
                }
                field.set(((NBTTagByte)tag).func_150290_f(), Byte.class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)Short.TYPE, (Class)Short.class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagShort(field.get(Short.TYPE).shortValue());
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagShort(field.get(Short.class).shortValue());
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagShort)) {
                    return false;
                }
                field.set(((NBTTagShort)tag).func_150289_e(), Short.TYPE);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagShort)) {
                    return false;
                }
                field.set(((NBTTagShort)tag).func_150289_e(), Short.class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)Character.TYPE, (Class)Character.class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagShort((short)field.get(Character.TYPE).charValue());
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagShort((short)field.get(Character.class).charValue());
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagShort)) {
                    return false;
                }
                field.set(Character.valueOf((char)((NBTTagShort)tag).func_150289_e()), Character.TYPE);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagShort)) {
                    return false;
                }
                field.set(Character.valueOf((char)((NBTTagShort)tag).func_150289_e()), Character.class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)Integer.TYPE, (Class)Integer.class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagInt(field.get(Integer.TYPE).intValue());
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagInt(field.get(Integer.class).intValue());
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagInt)) {
                    return false;
                }
                field.set(((NBTTagInt)tag).func_150287_d(), Integer.TYPE);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagInt)) {
                    return false;
                }
                field.set(((NBTTagInt)tag).func_150287_d(), Integer.class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)Float.TYPE, (Class)Float.class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagFloat(field.get(Float.TYPE).floatValue());
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagFloat(field.get(Float.class).floatValue());
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagFloat)) {
                    return false;
                }
                field.set(Float.valueOf(((NBTTagFloat)tag).func_150288_h()), Float.TYPE);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagFloat)) {
                    return false;
                }
                field.set(Float.valueOf(((NBTTagFloat)tag).func_150288_h()), Float.class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)Double.TYPE, (Class)Double.class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagDouble(field.get(Double.TYPE).doubleValue());
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagDouble(field.get(Double.class).doubleValue());
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagDouble)) {
                    return false;
                }
                field.set(((NBTTagDouble)tag).func_150286_g(), Double.TYPE);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagDouble)) {
                    return false;
                }
                field.set(((NBTTagDouble)tag).func_150286_g(), Double.class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new StringSerializer());
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)boolean[].class, (Class)Boolean[].class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createBooleanList(field.get(boolean[].class));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createBooleanList(field.get(Boolean[].class));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByteArray)) {
                    return false;
                }
                field.set(NBTTool.readBooleanList((NBTTagByteArray)tag), boolean[].class);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByteArray)) {
                    return false;
                }
                field.set(NBTTool.readBBooleanList((NBTTagByteArray)tag), Boolean[].class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)byte[].class, (Class)Byte[].class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagByteArray(field.get(byte[].class));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagByteArray(ArrayUtils.asPrimitive(field.get(Byte[].class)));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByteArray)) {
                    return false;
                }
                field.set(((NBTTagByteArray)tag).func_150292_c(), byte[].class);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagByteArray)) {
                    return false;
                }
                field.set(ArrayUtils.asBoxed(((NBTTagByteArray)tag).func_150292_c()), Byte[].class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)short[].class, (Class)Short[].class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createShortList(field.get(short[].class));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createShortList(field.get(Short[].class));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagList)) {
                    return false;
                }
                field.set(NBTTool.readShortList((NBTTagList)tag), short[].class);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagList)) {
                    return false;
                }
                field.set(NBTTool.readBShortList((NBTTagList)tag), Short[].class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)char[].class, (Class)Character[].class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagString(String.valueOf(field.get(char[].class)));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagString(String.valueOf(ArrayUtils.asPrimitive(field.get(Character[].class))));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagString)) {
                    return false;
                }
                field.set(((NBTTagString)tag).func_150285_a_().toCharArray(), char[].class);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagString)) {
                    return false;
                }
                field.set(ArrayUtils.asBoxed(((NBTTagString)tag).func_150285_a_().toCharArray()), Character[].class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)int[].class, (Class)Integer[].class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagIntArray(field.get(int[].class));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return new NBTTagIntArray(ArrayUtils.asPrimitive(field.get(Integer[].class)));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagIntArray)) {
                    return false;
                }
                field.set(((NBTTagIntArray)tag).func_150302_c(), int[].class);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagIntArray)) {
                    return false;
                }
                field.set(ArrayUtils.asBoxed(((NBTTagIntArray)tag).func_150302_c()), Integer[].class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)float[].class, (Class)Float[].class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createFloatList(field.get(float[].class));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createFloatList(field.get(Float[].class));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagList)) {
                    return false;
                }
                field.set(NBTTool.readFloatList((NBTTagList)tag), float[].class);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagList)) {
                    return false;
                }
                field.set(NBTTool.readBFloatList((NBTTagList)tag), Float[].class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new PrimitiveSerializer((Class)double[].class, (Class)Double[].class){

            @Override
            protected NBTBase serializePrimitiveVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createDoubleList(field.get(double[].class));
            }

            @Override
            protected NBTBase serializeBoxedVal(FieldWrapper field) throws IllegalAccessException {
                return NBTTool.createDoubleList(field.get(Double[].class));
            }

            @Override
            protected boolean applyPrimitiveVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagList)) {
                    return false;
                }
                field.set(NBTTool.readDoubleList((NBTTagList)tag), double[].class);
                return true;
            }

            @Override
            protected boolean applyBoxedVal(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
                if (!(tag instanceof NBTTagList)) {
                    return false;
                }
                field.set(NBTTool.readBDoubleList((NBTTagList)tag), Double[].class);
                return true;
            }
        });
        FieldSerializer.addSerializer(new StringArraySerializer());
        FieldSerializer.addMapper("Pattern List Mapper", FieldMapper.PATTERN_LIST_MAPPER);
    }

    private static void clear() {
        serializers.clear();
        mappingAdapters.clear();
    }

    static {
        FieldSerializer.init();
    }

    private static class StringArraySerializer
    implements ITypeSerializer {
        private StringArraySerializer() {
        }

        @Override
        @Nullable
        public NBTBase serializeValue(FieldWrapper field) throws IllegalAccessException {
            if (!field.getMappedType().equals(String[].class)) {
                return null;
            }
            String[] val = field.get(String[].class);
            return NBTTool.createStringList(val);
        }

        @Override
        public boolean applyValue(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
            if (!field.getMappedType().equals(String[].class) || !(tag instanceof NBTTagList)) {
                return false;
            }
            field.set(NBTTool.readStringList((NBTTagList)tag), String[].class);
            return true;
        }

        public String toString() {
            return "StringArraySerializer{}";
        }
    }

    private static class StringSerializer
    implements ITypeSerializer {
        private StringSerializer() {
        }

        @Override
        @Nullable
        public NBTBase serializeValue(FieldWrapper field) throws IllegalAccessException {
            if (!field.getMappedType().equals(String.class)) {
                return null;
            }
            String val = field.get(String.class);
            return new NBTTagString(val);
        }

        @Override
        public boolean applyValue(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
            if (!field.getMappedType().equals(String.class) || !(tag instanceof NBTTagString)) {
                return false;
            }
            field.set(((NBTTagString)tag).func_150285_a_(), String.class);
            return true;
        }

        public String toString() {
            return "StringSerializer{}";
        }
    }

    private static abstract class PrimitiveSerializer
    implements ITypeSerializer {
        private final Class<?> primitiveClass;
        private final Class<?> boxedClass;

        public PrimitiveSerializer(Class<?> primitiveClass, Class<?> boxedClass) {
            this.primitiveClass = primitiveClass;
            this.boxedClass = boxedClass;
        }

        public Class<?> getPrimitiveClass() {
            return this.primitiveClass;
        }

        public Class<?> getBoxedClass() {
            return this.boxedClass;
        }

        protected boolean isAcceptableClass(Class<?> clazz) {
            return this.getPrimitiveClass().equals(clazz) || this.getBoxedClass().equals(clazz);
        }

        @Override
        @Nullable
        public NBTBase serializeValue(FieldWrapper field) throws IllegalAccessException {
            if (field.getMappedType().equals(this.getPrimitiveClass())) {
                return this.serializePrimitiveVal(field);
            }
            if (field.getMappedType().equals(this.getBoxedClass())) {
                return this.serializeBoxedVal(field);
            }
            return null;
        }

        @Override
        public boolean applyValue(NBTBase tag, FieldWrapper field) throws IllegalAccessException {
            return this.getPrimitiveClass().equals(field.getMappedType()) && this.applyPrimitiveVal(tag, field) || this.getBoxedClass().equals(field.getMappedType()) && this.applyBoxedVal(tag, field);
        }

        protected abstract NBTBase serializePrimitiveVal(FieldWrapper var1) throws IllegalAccessException;

        protected abstract NBTBase serializeBoxedVal(FieldWrapper var1) throws IllegalAccessException;

        protected abstract boolean applyPrimitiveVal(NBTBase var1, FieldWrapper var2) throws IllegalAccessException;

        protected abstract boolean applyBoxedVal(NBTBase var1, FieldWrapper var2) throws IllegalAccessException;

        public String toString() {
            return "PrimitiveSerializer{primitiveClass=" + this.primitiveClass.getSimpleName() + ", boxedClass=" + this.boxedClass.getSimpleName() + '}';
        }
    }
}

