/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.building.placement;

import com.direwolf20.buildinggadgets.common.building.IPlacementSequence;
import com.direwolf20.buildinggadgets.common.building.Region;
import com.direwolf20.buildinggadgets.common.building.placement.Wall;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public final class Surface
implements IPlacementSequence {
    private final IBlockAccess world;
    private final IBlockState selectedBase;
    private final Function<BlockPos, BlockPos> searching2referenceMapper;
    private final Region searchingRegion;
    private final boolean fuzzy;

    public static Surface create(IBlockAccess world, BlockPos searchingCenter, EnumFacing side, int range, boolean fuzzy) {
        Region searchingRegion = Wall.clickedSide(searchingCenter, side, range).getBoundingBox();
        return Surface.create(world, searchingCenter, searchingRegion, pos -> pos.func_177972_a(side), fuzzy);
    }

    public static Surface create(IBlockAccess world, BlockPos center, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, boolean fuzzy) {
        return new Surface(world, center, searchingRegion, searching2referenceMapper, fuzzy);
    }

    @VisibleForTesting
    private Surface(IBlockAccess world, BlockPos center, Region searchingRegion, Function<BlockPos, BlockPos> searching2referenceMapper, boolean fuzzy) {
        this.world = world;
        this.selectedBase = world.func_180495_p(searching2referenceMapper.apply(center));
        this.searchingRegion = searchingRegion;
        this.searching2referenceMapper = searching2referenceMapper;
        this.fuzzy = fuzzy;
    }

    private Surface(IBlockAccess world, IBlockState selectedBase, Function<BlockPos, BlockPos> searching2referenceMapper, Region searchingRegion, boolean fuzzy) {
        this.world = world;
        this.selectedBase = selectedBase;
        this.searching2referenceMapper = searching2referenceMapper;
        this.searchingRegion = searchingRegion;
        this.fuzzy = fuzzy;
    }

    @Override
    public Region getBoundingBox() {
        return this.searchingRegion;
    }

    @Override
    public boolean mayContain(int x, int y, int z) {
        return this.searchingRegion.contains(x, y, z);
    }

    @Override
    public IPlacementSequence copy() {
        return new Surface(this.world, this.selectedBase, this.searching2referenceMapper, this.searchingRegion, this.fuzzy);
    }

    @Override
    @Nonnull
    public Iterator<BlockPos> iterator() {
        return new AbstractIterator<BlockPos>(){
            private final Iterator<BlockPos> it;
            {
                this.it = Surface.this.searchingRegion.iterator();
            }

            protected BlockPos computeNext() {
                while (this.it.hasNext()) {
                    BlockPos pos = this.it.next();
                    BlockPos referencePos = (BlockPos)Surface.this.searching2referenceMapper.apply(pos);
                    IBlockState baseBlock = Surface.this.world.func_180495_p(referencePos);
                    if (!Surface.this.fuzzy && baseBlock != Surface.this.selectedBase || baseBlock.func_177230_c().isAir(baseBlock, Surface.this.world, referencePos)) continue;
                    return pos;
                }
                return (BlockPos)this.endOfData();
            }
        };
    }
}

