/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block;

import com.buuz135.industrial.proxy.block.Cuboid;
import com.buuz135.industrial.proxy.block.DistanceRayTraceResult;
import com.buuz135.industrial.utils.RayTraceUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockBase
extends Block {
    public static final List<BlockBase> BLOCKS = new ArrayList<BlockBase>();

    public BlockBase(String name) {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("industrialforegoing", name));
        this.func_149663_c("industrialforegoing." + name);
        BLOCKS.add(this);
    }

    public void registerBlock(IForgeRegistry<Block> blocks) {
        blocks.register((IForgeRegistryEntry)this);
    }

    public void registerItem(IForgeRegistry<Item> items) {
        items.register(new ItemBlock((Block)this).setRegistryName(this.getRegistryName()));
    }

    public void registerRender() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void createRecipe() {
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        if (this.hasCustomBoxes()) {
            return RayTraceUtils.rayTraceBoxesClosest(start, end, pos, this.getBoundingBoxes(blockState, (IBlockAccess)worldIn, pos));
        }
        return super.func_180636_a(blockState, worldIn, pos, start, end);
    }

    public boolean hasCustomBoxes() {
        return false;
    }

    @Nullable
    public Cuboid getCuboidHit(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        RayTraceResult result = RayTraceUtils.rayTrace(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos, playerIn, 10.0, this.getBoundingBoxes(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos));
        if (result instanceof DistanceRayTraceResult) {
            return (Cuboid)result.hitInfo;
        }
        return null;
    }

    public List<Cuboid> getBoundingBoxes(IBlockState state, IBlockAccess source, BlockPos pos) {
        return Collections.emptyList();
    }
}

