/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration;

import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalRelay;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.gui.GuiDislocator;
import com.brandon3055.draconicevolution.client.gui.GuiDissEnchanter;
import com.brandon3055.draconicevolution.client.gui.GuiDraconiumChest;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyCore;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyCrystal;
import com.brandon3055.draconicevolution.client.gui.GuiEnergyinfuser;
import com.brandon3055.draconicevolution.client.gui.GuiEntityDetector;
import com.brandon3055.draconicevolution.client.gui.GuiFlowGate;
import com.brandon3055.draconicevolution.client.gui.GuiFusionCraftingCore;
import com.brandon3055.draconicevolution.client.gui.GuiGenerator;
import com.brandon3055.draconicevolution.client.gui.GuiGrinder;
import com.brandon3055.draconicevolution.client.gui.GuiReactor;
import com.brandon3055.draconicevolution.utils.LogHelper;
import com.brandon3055.projectintelligence.api.IGuiDocHandler;
import com.brandon3055.projectintelligence.api.IGuiDocRegistry;
import com.brandon3055.projectintelligence.api.IModPlugin;
import com.brandon3055.projectintelligence.api.ModPlugin;
import java.awt.Rectangle;
import java.util.ArrayList;

@ModPlugin
public class PIPlugin
implements IModPlugin {
    public void registerModGUIs(IGuiDocRegistry registry) {
        LogHelper.dev("Loading PI Integration...");
        registry.registerGuiDocPages(GuiReactor.class, new String[]{"draconicevolution:draconic_reactor", "draconicevolution:draconic_reactor/basic_operation", "draconicevolution:draconic_reactor/regulation_and_safety", "draconicevolution:draconic_reactor/reactor_explosion"});
        registry.registerGuiHandler(GuiReactor.class, (IGuiDocHandler)new IGuiDocHandler<GuiReactor>(){

            public Rectangle getCollapsedArea(GuiReactor gui) {
                return new Rectangle(gui.guiLeft() - 25, gui.guiTop() + 3, 25, 25);
            }

            public Rectangle getExpandedArea(GuiReactor gui) {
                return new Rectangle(gui.field_147003_i + 4, gui.field_147009_r + 4, gui.field_146999_f - 8, gui.field_147000_g - 8);
            }
        });
        registry.registerGuiDocPages(GuiFusionCraftingCore.class, new String[]{"draconicevolution:fusion_crafting", "draconicevolution:fusion_crafting/fusion_crafting_injectors", "draconicevolution:fusion_crafting/fusion_crafting_setup"});
        registry.registerGuiDocPages(GuiDraconiumChest.class, new String[]{"draconicevolution:draconium_chest"});
        registry.registerGuiHandler(GuiDraconiumChest.class, (IGuiDocHandler)new IGuiDocHandler<GuiDraconiumChest>(){

            public Rectangle getCollapsedArea(GuiDraconiumChest gui) {
                return new Rectangle(gui.field_147003_i + gui.field_146999_f - 30, gui.field_147009_r + gui.field_147000_g - 55, 25, 25);
            }

            public Rectangle getExpandedArea(GuiDraconiumChest gui) {
                return new Rectangle(gui.field_147003_i + 5, gui.field_147009_r + 5, gui.field_146999_f - 10, 181);
            }
        });
        registry.registerGuiDocPages(GuiEnergyCore.class, new String[]{"draconicevolution:energy_storage_core", "draconicevolution:energy_storage_core/energy_core_setup", "draconicevolution:energy_storage_core/energy_core_stabilizer", "draconicevolution:energy_storage_core/energy_pylon"});
        registry.registerGuiDocPages(GuiEnergyCrystal.class, gui -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add("draconicevolution:energy_network");
            list.add("draconicevolution:energy_network/the_basics");
            if (gui.tile instanceof TileCrystalDirectIO) {
                list.add("draconicevolution:energy_network/energy_io_crystals");
            } else if (gui.tile instanceof TileCrystalRelay) {
                list.add("draconicevolution:energy_network/relay_crystals");
            } else if (gui.tile instanceof TileCrystalWirelessIO) {
                list.add("draconicevolution:energy_network/wireless_crystals");
            }
            return list;
        });
        registry.registerGuiDocPages(GuiFlowGate.class, new String[]{"draconicevolution:flow_gates"});
        registry.registerGuiDocPages(GuiDissEnchanter.class, new String[]{"draconicevolution:disenchanter"});
        registry.registerGuiDocPages(GuiDislocator.class, new String[]{"draconicevolution:dislocation/advanced_dislocator"});
        registry.registerGuiHandler(GuiDislocator.class, (IGuiDocHandler)new IGuiDocHandler<GuiDislocator>(){

            public Rectangle getCollapsedArea(GuiDislocator gui) {
                return new Rectangle(gui.guiLeft() - 25, gui.guiTop() + 3, 25, 25);
            }

            public Rectangle getExpandedArea(GuiDislocator gui) {
                int availWidth = gui.guiLeft();
                if (availWidth < 160) {
                    int width = Math.max(200, gui.xSize);
                    int height = Math.max(200, gui.ySize);
                    return new Rectangle(gui.field_146294_l / 2 - width / 2, gui.field_146295_m / 2 - height / 2, width, height);
                }
                int width = Math.max(availWidth - 25, Math.min(200, availWidth));
                int height = Math.max(gui.ySize, 200);
                return new Rectangle(availWidth - width, gui.field_146295_m / 2 - height / 2, width, height);
            }
        });
        registry.registerGuiDocPages(GuiGenerator.class, new String[]{"draconicevolution:generator"});
        registry.registerGuiDocPages(GuiEnergyinfuser.class, new String[]{"draconicevolution:energy_infuser"});
        registry.registerGuiDocPages(GuiGrinder.class, new String[]{"draconicevolution:mob_grinder"});
        registry.registerGuiDocPages(GuiEntityDetector.class, new String[]{"draconicevolution:entity_detector"});
        LogHelper.dev("Loaded PI Integration");
    }
}

