/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.ModularGuiContainer;
import com.brandon3055.brandonscore.client.gui.modulargui_old.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiBackground;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiButtonToggle;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiColourPicker;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiHoverPopup;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiPopUpDialog;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiSelectDialog;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiSlider;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiSlotRender;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiStackIcon;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiTextField;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.lib.StackReference;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDraconiumChest;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDraconiumChest;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.inventory.ContainerDraconiumChest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;

public class GuiDraconiumChest
extends ModularGuiContainer<ContainerDraconiumChest>
implements IMGuiListener {
    public final TileDraconiumChest tile;
    public MGuiButtonToggle regionEditButton;
    public RegionEditor regionEditor;

    public GuiDraconiumChest(TileDraconiumChest tile, ContainerDraconiumChest container) {
        super((Container)container);
        this.tile = tile;
        this.field_146999_f = 480;
        this.field_147000_g = 266;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.manager.clear();
        this.manager.add((MGuiElementBase)new MGuiBackground((IModularGui)this, this.guiLeft(), this.guiTop(), 0, 0, this.xSize(), this.ySize(), "draconicevolution:textures/gui/draconium_chest.png").setTextureSize(512, 512));
        this.manager.add((MGuiElementBase)new MGuiBackground((IModularGui)this, this.guiLeft() + 45, this.guiTop() + 227, 0, 282, 88, 0, "draconicevolution:textures/gui/draconium_chest.png"){

            public boolean onUpdate() {
                double progress = GuiDraconiumChest.this.tile.burnRate.value;
                this.ySize = (int)(14.0 * progress);
                this.yPos = GuiDraconiumChest.this.guiTop() + 227 + (int)(14.0 * (1.0 - progress));
                this.textureY = 282 + (14 - this.ySize);
                return super.onUpdate();
            }
        }.setTextureSize(512, 512));
        this.manager.add((MGuiElementBase)new MGuiBackground((IModularGui)this, this.guiLeft() + 44, this.guiTop() + 245, 0, 266, 0, 16, "draconicevolution:textures/gui/draconium_chest.png"){

            public boolean onUpdate() {
                double progress = (double)GuiDraconiumChest.this.tile.energySync.value / (double)GuiDraconiumChest.this.tile.energyStorage.getMaxEnergyStored();
                this.xSize = (int)(90.0 * progress);
                return super.onUpdate();
            }
        }.setTextureSize(512, 512));
        this.manager.add(new MGuiElementBase((IModularGui)this, this.guiLeft() + 44, this.guiTop() + 245, 90, 16).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this){

            public List<String> getToolTip() {
                ArrayList<String> list = new ArrayList<String>();
                list.add(InfoHelper.ITC() + I18n.func_135052_a((String)"gui.de.energyStorage.txt", (Object[])new Object[0]));
                list.add(InfoHelper.HITC() + Utils.formatNumber((long)GuiDraconiumChest.this.tile.energySync.value) + " / " + Utils.formatNumber((long)GuiDraconiumChest.this.tile.energyStorage.getMaxEnergyStored()));
                list.add(I18n.func_135052_a((String)"gui.draconiumChest.energyConsumption.info", (Object[])new Object[0]) + ": " + Utils.addCommas((int)GuiDraconiumChest.this.tile.smeltEnergyPerTick.value) + " RF/t");
                return list;
            }
        }.setHoverDelay(0)));
        this.manager.add((MGuiElementBase)new MGuiBackground((IModularGui)this, this.guiLeft() + 139, this.guiTop() + 202, 0, 297, 16, 0, "draconicevolution:textures/gui/draconium_chest.png"){

            public boolean onUpdate() {
                double progress = Math.min(GuiDraconiumChest.this.tile.smeltProgress.value / (double)GuiDraconiumChest.this.tile.smeltTime.value, 1.0);
                this.ySize = (int)(22.0 * progress);
                this.yPos = GuiDraconiumChest.this.guiTop() + 202 + (int)(22.0 * (1.0 - progress));
                this.textureY = 297 + (22 - this.ySize);
                return super.onUpdate();
            }
        }.setTextureSize(512, 512));
        this.manager.add(new MGuiElementBase((IModularGui)this, this.guiLeft() + 45, this.guiTop() + 227, 88, 13).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this){

            public List<String> getToolTip() {
                ArrayList<String> list = new ArrayList<String>();
                list.add(I18n.func_135052_a((String)"gui.draconiumChest.processTime.info", (Object[])new Object[0]) + ": " + Utils.round((double)((double)GuiDraconiumChest.this.tile.smeltTime.value / 20.0), (double)100.0) + "s");
                return list;
            }
        }.setHoverDelay(0)));
        this.manager.add((MGuiElementBase)new MGuiStackIcon((IModularGui)this, this.guiLeft() + 7, this.guiTop() + 197, 36, 36, new StackReference("draconicevolution:draconic_core")).setToolTip(false)).addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.draconiumChest.speedBoost.info", (Object[])new Object[0])}));
        this.manager.add((MGuiElementBase)new MGuiSlotRender((IModularGui)this, this.guiLeft() + 16, this.guiTop() + 206, 18, 18){

            public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                this.zOffset += 100.0;
                super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
                this.zOffset -= 100.0;
            }
        });
        this.manager.add(new MGuiButtonSolid((IModularGui)this, "SELECT_MODE", this.guiLeft() + 44, this.guiTop() + 190, 90, 12, ""){

            public String getDisplayString() {
                return I18n.func_135052_a((String)"gui.draconiumChest.fMode.btn", (Object[])new Object[0]) + ": " + TextFormatting.GOLD + I18n.func_135052_a((String)("gui.draconiumChest.fMode." + GuiDraconiumChest.this.tile.autoSmeltMode.toString().toLowerCase(Locale.ENGLISH) + ".btn"), (Object[])new Object[0]);
            }
        }.addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)"gui.draconiumChest.fMode.info", (Object[])new Object[0])}).setHoverDelay(10)), 1);
        this.regionEditButton = (MGuiButtonToggle)new MGuiButtonToggle((IModularGui)this, "EDIT_REGIONS", this.guiLeft() + 390, this.guiTop() + 188, 84, 12, I18n.func_135052_a((String)"gui.draconiumChest.ioRegions.btn", (Object[])new Object[0])).setToolTip(new String[]{I18n.func_135052_a((String)"gui.draconiumChest.ioRegions.info", (Object[])new Object[0])});
        this.manager.add((MGuiElementBase)this.regionEditButton);
        this.manager.add((MGuiElementBase)new MGuiButtonSolid((IModularGui)this, "PICK_COLOUR", this.guiLeft() + 390, this.guiTop() + 248, 84, 12, I18n.func_135052_a((String)"gui.draconiumChest.pickColour.btn", (Object[])new Object[0])){

            public int getFillColour(boolean hovering, boolean disabled) {
                return 0xFF000000 | GuiDraconiumChest.this.tile.colour.value;
            }
        }.setToolTip(new String[]{I18n.func_135052_a((String)"gui.draconiumChest.pickColour.info", (Object[])new Object[0])}));
        this.manager.initElements();
    }

    public void onMGuiEvent(String eventString, MGuiElementBase element) {
        if (element instanceof MGuiButton && ((MGuiButton)element).buttonName.equals("SELECT_MODE")) {
            MGuiPopUpDialog dialog = new MGuiPopUpDialog((IModularGui)this, element.xPos, element.yPos + element.ySize, element.xSize, 51, element);
            dialog.setCloseOnCapturedClick(true);
            MGuiSelectDialog selector = new MGuiSelectDialog((IModularGui)this, dialog.xPos, dialog.yPos, dialog.xSize, dialog.ySize);
            ArrayList<MGuiButtonSolid> modeButtons = new ArrayList<MGuiButtonSolid>();
            for (TileDraconiumChest.AutoSmeltMode mode : TileDraconiumChest.AutoSmeltMode.values()) {
                MGuiButtonSolid modeButton = new MGuiButtonSolid((IModularGui)this, mode.name(), 0, 0, dialog.xSize - 2, 12, mode.name().toLowerCase());
                modeButton.addChild((MGuiElementBase)new MGuiHoverPopup((IModularGui)this, new String[]{I18n.func_135052_a((String)("gui.draconiumChest.fMode." + mode.name().toLowerCase(Locale.ENGLISH) + ".info"), (Object[])new Object[0])}));
                modeButtons.add(modeButton);
            }
            selector.setOptions(modeButtons, false);
            selector.setListener((IMGuiListener)this);
            selector.xSize -= 10;
            dialog.addChild((MGuiElementBase)selector);
            dialog.show();
        } else if (eventString.equals("SELECTOR_PICK") && element instanceof MGuiButton) {
            TileDraconiumChest.AutoSmeltMode newMode = TileDraconiumChest.AutoSmeltMode.valueOf(((MGuiButton)element).buttonName);
            this.tile.setAutoSmeltMode(newMode);
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        } else if (element instanceof MGuiButtonToggle && ((MGuiButtonToggle)element).buttonName.equals("EDIT_REGIONS")) {
            if (((MGuiButtonToggle)element).isPressed()) {
                this.regionEditor = new RegionEditor((IModularGui)this, this.guiLeft() + 160, this.guiTop() + 188, this.tile);
                this.manager.add((MGuiElementBase)this.regionEditor, 2);
                this.regionEditor.initElement();
            } else if (this.regionEditor != null) {
                this.manager.remove((MGuiElementBase)this.regionEditor);
                this.regionEditor = null;
            }
        } else if (element instanceof MGuiButton && ((MGuiButton)element).buttonName.equals("PICK_COLOUR")) {
            MGuiColourPicker picker = new MGuiColourPicker((IModularGui)this, this.guiLeft() + this.xSize() / 2 - 40, this.guiTop() + this.ySize() / 2 - 40, element){

                public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
                    super.onMGuiEvent(eventString, eventElement);
                    if (eventElement instanceof MGuiSlider || eventElement instanceof MGuiTextField) {
                        this.listener.onMGuiEvent("COLOUR_PICKED", (MGuiElementBase)this);
                    }
                }
            };
            picker.setColour(this.tile.colour.value);
            picker.setListener((IMGuiListener)this);
            picker.setIncludeAlpha(false);
            picker.initElement();
            picker.cancelButton.setEnabled(false);
            picker.selectButton.xSize = 72;
            picker.show();
        } else if (element instanceof MGuiColourPicker && eventString.equals("COLOUR_PICKED")) {
            this.tile.setColour(((MGuiColourPicker)element).getColourARGB());
        }
    }

    public void renderBackgroundLayer(int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(mouseX, mouseY, partialTicks);
        for (TileDraconiumChest.SlotRegion region : this.tile.slotRegions) {
            if (!region.enabled || region.isDefault || region.invalid && this.regionEditor == null) continue;
            int fill = 0;
            if (this.regionEditor != null && this.regionEditor.editingRegion == region.regionID) {
                fill = region.colour | 0x33000000;
                if (region.invalid) {
                    fill = ClientEventHandler.elapsedTicks % 20 > 10 ? 0 : -65536;
                }
            }
            GuiHelper.drawBorderedRect((int)(this.guiLeft() + 6 + region.xPos * 18), (int)(this.guiTop() + 6 + region.yPos * 18), (int)(region.xSize * 18), (int)(region.ySize * 18), (int)1, (int)fill, (int)(region.colour | 0xFF000000));
        }
    }

    public class RegionEditor
    extends MGuiElementBase
    implements IMGuiListener {
        private final TileDraconiumChest tile;
        private int editingRegion;
        private boolean selectingRegion;
        private int selectStartX;
        private int selectStartY;
        private int selectEndX;
        private int selectEndY;

        public RegionEditor(IModularGui modularGui, int xPos, int yPos, TileDraconiumChest tile) {
            super(modularGui, xPos, yPos, 162, 74);
            this.editingRegion = -1;
            this.selectingRegion = false;
            this.selectStartX = 0;
            this.selectStartY = 0;
            this.selectEndX = 0;
            this.selectEndY = 0;
            this.tile = tile;
        }

        public void initElement() {
            for (int i = 0; i < 6; ++i) {
                int colour = this.tile.slotRegions[i].colour | 0xA0000000;
                int hColour = this.tile.slotRegions[i].colour | 0xFF000000;
                int x = this.xPos + 1 + i % 2 * (this.xSize / 2);
                int y = this.yPos + 1 + i / 2 * 19;
                this.addChild(new MGuiButtonSolid(this.modularGui, i, x, y, (this.xSize - 4) / 2, 18, I18n.func_135052_a((String)"gui.draconiumChest.editRegion.btn", (Object[])new Object[0]) + " " + (i + 1)).setColours(-16777216, colour, hColour).setListener((IMGuiListener)this).setButtonName("SELECT_REGION").addToGroup("R_SELECTORS"));
            }
            this.addChild(new MGuiButtonSolid(this.modularGui, 6, this.xPos + 1, this.yPos + this.ySize - 16, this.xSize - 2, 15, I18n.func_135052_a((String)"gui.draconiumChest.editDefaultRegion.btn", (Object[])new Object[0])).setColours(-16777216, -6250336, -1).setListener((IMGuiListener)this).setButtonName("SELECT_REGION").addToGroup("R_SELECTORS"));
            this.addChild(new MGuiLabel(this.modularGui, this.xPos + this.xSize, this.yPos + 14, this.xSize - 5, 60, I18n.func_135052_a((String)"gui.draconiumChest.regionSelect.info", (Object[])new Object[0])).setWrap(true).setEnabled(false).addToGroup("REGION_EDITOR").addToGroup("EXCLUDE_DEFAULT"));
            this.addChild(new MGuiBorderedRect(this.modularGui, this.xPos + this.xSize + 5, this.yPos + 14, this.xSize - 15, 60).setEnabled(false).addToGroup("REGION_EDITOR").addToGroup("EXCLUDE_DEFAULT"));
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_REGION", this.xPos + 45, this.yPos + 1, this.xSize - 46, 12, ""){

                public String getDisplayString() {
                    if (RegionEditor.this.editingRegion < 0 || RegionEditor.this.editingRegion >= 6) {
                        return "Error-InvalidGroup";
                    }
                    return ((RegionEditor)RegionEditor.this).tile.slotRegions[((RegionEditor)RegionEditor.this).editingRegion].enabled ? TextFormatting.RED + I18n.func_135052_a((String)"gui.draconiumChest.disableRegion.btn", (Object[])new Object[0]) : TextFormatting.GREEN + I18n.func_135052_a((String)"gui.draconiumChest.enableRegion.btn", (Object[])new Object[0]);
                }
            }.setColours(-16777216, -5197648, -1).setListener((IMGuiListener)this).setEnabled(false).addToGroup("REGION_EDITOR").addToGroup("EXCLUDE_DEFAULT"));
            this.addChild(new MGuiButtonSolid(this.modularGui, "BACK", this.xPos + 1, this.yPos + 1, 43, 12, "Back").setColours(-16777216, -5197648, -1).setListener((IMGuiListener)this).setEnabled(false).addToGroup("REGION_EDITOR"));
            int yAlign = this.yPos + this.ySize / 2 - 3;
            this.addChild(new MGuiElementBase(this.modularGui, this.xPos + this.xSize / 4 - 18, yAlign, 18, 18){

                public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                    if (RegionEditor.this.editingRegion >= 0 && RegionEditor.this.editingRegion < ((RegionEditor)RegionEditor.this).tile.slotRegions.length) {
                        this.drawBorderedRect(this.parent.xPos, this.parent.yPos, this.parent.xSize, this.parent.ySize, 1.0, 0, 0xFF000000 | ((RegionEditor)RegionEditor.this).tile.slotRegions[((RegionEditor)RegionEditor.this).editingRegion].colour);
                    }
                    this.drawBorderedRect(this.xPos - 20, this.yPos - 1, 58.0, 20.0, 1.0, 0, -1);
                    this.drawBorderedRect(this.xPos - 1, this.yPos - 20, 20.0, 58.0, 1.0, 0, -1);
                    this.drawBorderedRect(this.xPos + 58, this.yPos - 20, 20.0, 58.0, 1.0, 0, -1);
                    this.drawBorderedRect(this.xPos + 58, this.yPos - 1, 20.0, 20.0, 1.0, 0, -1);
                    this.drawBorderedRect(this.xPos + 99, this.yPos - 20, 20.0, 39.0, 1.0, 0, -1);
                    this.drawBorderedRect(this.xPos + 99, this.yPos - 1, 20.0, 20.0, 1.0, 0, -1);
                }

                public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                    ResourceHelperDE.bindTexture("textures/gui/draconium_chest.png");
                    if (RegionEditor.this.editingRegion >= 0 && RegionEditor.this.editingRegion < ((RegionEditor)RegionEditor.this).tile.slotRegions.length) {
                        TileDraconiumChest.SlotRegion region = ((RegionEditor)RegionEditor.this).tile.slotRegions[RegionEditor.this.editingRegion];
                        this.drawModalRectWithCustomSizedTexture(this.xPos + 61, this.yPos + 21, 0.0, 319 + region.getFaceIO(EnumFacing.DOWN) * 14, 14.0, 14.0, 512.0, 512.0);
                        this.drawModalRectWithCustomSizedTexture(this.xPos + 61, this.yPos - 17, 14.0, 319 + region.getFaceIO(EnumFacing.UP) * 14, 14.0, 14.0, 512.0, 512.0);
                        this.drawModalRectWithCustomSizedTexture(this.xPos + 2, this.yPos - 17, 14.0, 319 + region.getFaceIO(EnumFacing.SOUTH) * 14, 14.0, 14.0, 512.0, 512.0);
                        this.drawModalRectWithCustomSizedTexture(this.xPos + 2, this.yPos + 21, 0.0, 319 + region.getFaceIO(EnumFacing.NORTH) * 14, 14.0, 14.0, 512.0, 512.0);
                        this.drawModalRectWithCustomSizedTexture(this.xPos + 21, this.yPos + 2, 28.0, 319 + region.getFaceIO(EnumFacing.WEST) * 14, 14.0, 14.0, 512.0, 512.0);
                        this.drawModalRectWithCustomSizedTexture(this.xPos - 17, this.yPos + 2, 42.0, 319 + region.getFaceIO(EnumFacing.EAST) * 14, 14.0, 14.0, 512.0, 512.0);
                        this.drawModalRectWithCustomSizedTexture(this.xPos + 102, this.yPos - 17, 14.0, 319 + region.getFurnaceIO() * 14, 14.0, 14.0, 512.0, 512.0);
                    }
                }
            }.addToGroup("REGION_EDITOR").setEnabled(false));
            this.addChild(new MGuiElementBase(this.modularGui, this.xPos + this.xSize / 4 - 18, yAlign, 18, 18){

                public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                    super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
                    ResourceHelperDE.bindTexture("textures/models/draconium_chest.png");
                    float red = (float)(50 + (((RegionEditor)RegionEditor.this).tile.colour.value >> 16 & 0xFF)) / 255.0f;
                    float green = (float)(50 + (((RegionEditor)RegionEditor.this).tile.colour.value >> 8 & 0xFF)) / 255.0f;
                    float blue = (float)(50 + (((RegionEditor)RegionEditor.this).tile.colour.value & 0xFF)) / 255.0f;
                    GlStateManager.func_179124_c((float)red, (float)green, (float)blue);
                    float scale = 16.0f;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(this.xPos + 1), (float)(this.yPos + 16), (float)500.0f);
                    GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)(-scale));
                    RenderTileDraconiumChest.modelChest.func_78231_a();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(this.xPos + 60), (float)this.yPos, (float)500.0f);
                    GlStateManager.func_179152_a((float)scale, (float)scale, (float)(-scale));
                    RenderTileDraconiumChest.modelChest.field_78234_a.field_78795_f = 0.0f;
                    RenderTileDraconiumChest.modelChest.func_78231_a();
                    GlStateManager.func_179121_F();
                }
            }.addToGroup("REGION_EDITOR").setEnabled(false));
            this.addChild(new MGuiStackIcon(this.modularGui, this.xPos + this.xSize / 4 + 82, yAlign, 18, 18, new StackReference(new ItemStack(Blocks.field_150460_al))).setToolTip(false).addToGroup("REGION_EDITOR").setEnabled(false));
            final Function<EnumFacing, List> ioTooltipGetter = facing -> {
                ArrayList<String> list = new ArrayList<String>();
                int io = 0;
                if (this.editingRegion >= 0) {
                    io = this.tile.slotRegions[this.editingRegion].getFaceIO((EnumFacing)facing);
                }
                list.add(InfoHelper.ITC() + I18n.func_135052_a((String)("gui.draconiumChest.toggleIOMode." + (facing == null ? "furnace" : facing.func_176610_l()) + ".btn"), (Object[])new Object[0]));
                list.add(InfoHelper.HITC() + I18n.func_135052_a((String)("gui.draconiumChest.ioState" + io + ".btn"), (Object[])new Object[0]));
                return list;
            };
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_FACE_D", this.xPos + 81, yAlign + 19, 18, 18, "").setButtonId(0).setListener((IMGuiListener)this).addToGroup("REGION_EDITOR").setEnabled(false).addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui){

                public List<String> getToolTip() {
                    return (List)ioTooltipGetter.apply(EnumFacing.DOWN);
                }
            }));
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_FACE_U", this.xPos + 81, yAlign - 19, 18, 18, "").setButtonId(1).setListener((IMGuiListener)this).addToGroup("REGION_EDITOR").setEnabled(false).addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui){

                public List<String> getToolTip() {
                    return (List)ioTooltipGetter.apply(EnumFacing.UP);
                }
            }));
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_FACE_N", this.xPos + this.xSize / 4 - 18, yAlign + 19, 18, 18, "").setButtonId(2).setListener((IMGuiListener)this).addToGroup("REGION_EDITOR").setEnabled(false).addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui){

                public List<String> getToolTip() {
                    return (List)ioTooltipGetter.apply(EnumFacing.NORTH);
                }
            }));
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_FACE_S", this.xPos + this.xSize / 4 - 18, yAlign - 19, 18, 18, "").setButtonId(3).setListener((IMGuiListener)this).addToGroup("REGION_EDITOR").setEnabled(false).addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui){

                public List<String> getToolTip() {
                    return (List)ioTooltipGetter.apply(EnumFacing.SOUTH);
                }
            }));
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_FACE_W", this.xPos + this.xSize / 4 + 1, yAlign, 18, 18, "").setButtonId(4).setListener((IMGuiListener)this).addToGroup("REGION_EDITOR").setEnabled(false).addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui){

                public List<String> getToolTip() {
                    return (List)ioTooltipGetter.apply(EnumFacing.WEST);
                }
            }));
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_FACE_E", this.xPos + this.xSize / 4 - 37, yAlign, 18, 18, "").setButtonId(5).setListener((IMGuiListener)this).addToGroup("REGION_EDITOR").setEnabled(false).addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui){

                public List<String> getToolTip() {
                    return (List)ioTooltipGetter.apply(EnumFacing.EAST);
                }
            }));
            this.addChild(new MGuiButtonSolid(this.modularGui, "TOGGLE_FACE_E", this.xPos + 122, yAlign - 19, 18, 18, "").setButtonId(6).setListener((IMGuiListener)this).addToGroup("REGION_EDITOR").setEnabled(false).addChild((MGuiElementBase)new MGuiHoverPopup(this.modularGui){

                public List<String> getToolTip() {
                    return (List)ioTooltipGetter.apply(null);
                }
            }));
            super.initElement();
        }

        public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
            this.drawBorderedRect(this.xPos, this.yPos, this.xSize, this.ySize, 1.0, -16777216, -16777216);
            int yAlign = this.yPos + this.ySize / 2 - 3;
            super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        }

        public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            this.selectingRegion = false;
            int changeRegion = -1;
            int x = (mouseX - 6 - GuiDraconiumChest.this.guiLeft()) / 18;
            int y = (mouseY - 6 - GuiDraconiumChest.this.guiTop()) / 18;
            for (TileDraconiumChest.SlotRegion region : this.tile.slotRegions) {
                if (!region.enabled || !region.getRectangle().contains(x, y) || region.regionID == this.editingRegion || region.isDefault) continue;
                changeRegion = region.regionID;
                break;
            }
            if (changeRegion != -1) {
                this.setChildGroupEnabled("R_SELECTORS", false);
                this.setChildGroupEnabled("REGION_EDITOR", true);
                this.editingRegion = changeRegion;
                this.setChildGroupEnabled("EXCLUDE_DEFAULT", this.editingRegion != 6);
                return true;
            }
            if (this.editingRegion >= 0 && this.editingRegion < this.tile.slotRegions.length && GuiHelper.isInRect((int)(GuiDraconiumChest.this.guiLeft() + 6), (int)(GuiDraconiumChest.this.guiTop() + 6), (int)468, (int)180, (int)mouseX, (int)mouseY)) {
                if (!this.tile.slotRegions[this.editingRegion].enabled) {
                    this.tile.slotRegions[this.editingRegion].enabled = true;
                    return true;
                }
                this.selectStartX = this.selectEndX = (mouseX - 6 - GuiDraconiumChest.this.guiLeft()) / 18;
                this.selectStartY = this.selectEndY = (mouseY - 6 - GuiDraconiumChest.this.guiTop()) / 18;
                for (TileDraconiumChest.SlotRegion region : this.tile.slotRegions) {
                    if (!region.enabled || !region.getRectangle().contains(this.selectStartX, this.selectStartY) || region.regionID == this.editingRegion) continue;
                    return true;
                }
                this.tile.slotRegions[this.editingRegion].xPos = this.selectStartX;
                this.tile.slotRegions[this.editingRegion].yPos = this.selectStartY;
                this.tile.slotRegions[this.editingRegion].xSize = 1;
                this.tile.slotRegions[this.editingRegion].ySize = 1;
                for (TileDraconiumChest.SlotRegion r : this.tile.slotRegions) {
                    r.validate();
                }
                this.selectingRegion = true;
                return true;
            }
            return super.mouseClicked(mouseX, mouseY, mouseButton) || GuiDraconiumChest.this.regionEditButton != null && !GuiDraconiumChest.this.regionEditButton.isMouseOver(mouseX, mouseY);
        }

        public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
            if (this.selectingRegion && this.editingRegion >= 0 && this.editingRegion < this.tile.slotRegions.length) {
                this.selectEndX = MathHelper.clip((int)((mouseX - 6 - GuiDraconiumChest.this.guiLeft()) / 18), (int)0, (int)25);
                this.selectEndY = MathHelper.clip((int)((mouseY - 6 - GuiDraconiumChest.this.guiTop()) / 18), (int)0, (int)9);
                int xSize = this.selectEndX - this.selectStartX;
                int ySize = this.selectEndY - this.selectStartY;
                this.tile.slotRegions[this.editingRegion].xPos = xSize < 0 ? this.selectEndX : this.selectStartX;
                this.tile.slotRegions[this.editingRegion].yPos = ySize < 0 ? this.selectEndY : this.selectStartY;
                this.tile.slotRegions[this.editingRegion].xSize = Math.abs(xSize) + 1;
                this.tile.slotRegions[this.editingRegion].ySize = Math.abs(ySize) + 1;
                for (TileDraconiumChest.SlotRegion r : this.tile.slotRegions) {
                    r.validate();
                }
            }
            return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        }

        public boolean mouseReleased(int mouseX, int mouseY, int state) {
            this.selectingRegion = false;
            if (this.editingRegion >= 0 || this.editingRegion < this.tile.slotRegions.length) {
                for (TileDraconiumChest.SlotRegion r : this.tile.slotRegions) {
                    r.validate();
                }
                this.tile.setRegionState(this.editingRegion);
            }
            return super.mouseReleased(mouseX, mouseY, state);
        }

        public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
            if (eventElement instanceof MGuiButton && eventElement.isInGroup("R_SELECTORS") && ((MGuiButton)eventElement).buttonName.equals("SELECT_REGION")) {
                this.setChildGroupEnabled("R_SELECTORS", false);
                this.setChildGroupEnabled("REGION_EDITOR", true);
                this.editingRegion = ((MGuiButton)eventElement).buttonId;
                this.setChildGroupEnabled("EXCLUDE_DEFAULT", this.editingRegion != 6);
            } else if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("TOGGLE_REGION")) {
                if (this.editingRegion >= 0 || this.editingRegion < this.tile.slotRegions.length) {
                    this.tile.slotRegions[this.editingRegion].enabled = !this.tile.slotRegions[this.editingRegion].enabled;
                    for (TileDraconiumChest.SlotRegion r : this.tile.slotRegions) {
                        r.validate();
                    }
                    this.tile.setRegionState(this.editingRegion);
                }
            } else if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.equals("BACK")) {
                this.editingRegion = -1;
                this.setChildGroupEnabled("R_SELECTORS", true);
                this.setChildGroupEnabled("REGION_EDITOR", false);
            } else if (eventElement instanceof MGuiButton && ((MGuiButton)eventElement).buttonName.startsWith("TOGGLE_FACE_") && (this.editingRegion >= 0 || this.editingRegion < this.tile.slotRegions.length)) {
                int bID = ((MGuiButton)eventElement).buttonId;
                EnumFacing facing = bID == 6 ? null : EnumFacing.func_82600_a((int)bID);
                int io = this.tile.slotRegions[this.editingRegion].getFaceIO(facing);
                this.tile.slotRegions[this.editingRegion].setFaceIO(facing, io == 3 ? 0 : io + 1);
                this.tile.setRegionState(this.editingRegion);
            }
        }
    }
}

