/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor;

import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorComponent;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorEnergyInjector;
import com.brandon3055.draconicevolution.client.render.effect.ReactorBeamFX;
import com.brandon3055.draconicevolution.client.sound.ReactorSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ReactorEffectHandler {
    private TileReactorCore reactor;
    @SideOnly(value=Side.CLIENT)
    private ReactorBeamFX[] effects;
    @SideOnly(value=Side.CLIENT)
    private ReactorSound reactorSound;

    public ReactorEffectHandler(TileReactorCore reactor) {
        this.reactor = reactor;
    }

    @SideOnly(value=Side.CLIENT)
    public void updateEffects() {
        if (this.effects == null) {
            this.effects = new ReactorBeamFX[6];
        }
        if ((this.reactorSound == null || this.reactorSound.func_147667_k() || !Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)this.reactorSound)) && ((TileReactorCore.ReactorState)this.reactor.reactorState.value).isShieldActive() && this.reactor.shieldCharge.value > 0.0) {
            this.reactorSound = new ReactorSound(this.reactor);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.reactorSound);
        } else if (this.reactorSound != null && (!((TileReactorCore.ReactorState)this.reactor.reactorState.value).isShieldActive() || this.reactor.shieldCharge.value <= 0.0)) {
            this.reactorSound.donePlaying = true;
        }
        if (this.reactor.reactorState.value == TileReactorCore.ReactorState.INVALID || this.reactor.shieldAnimationState <= 0.0f) {
            return;
        }
        for (EnumFacing facing : EnumFacing.values()) {
            ReactorBeamFX beamFX;
            int index = facing.func_176745_a();
            TileReactorComponent component = this.reactor.getComponent(facing);
            if (component == null) {
                if (this.effects[index] == null) continue;
                this.effects[index].func_187112_i();
                this.effects[index] = null;
                continue;
            }
            if (this.effects[index] != null && this.effects[index].func_187113_k()) {
                this.effects[index].updateFX(this.reactor.shieldAnimationState, 1.0f);
                continue;
            }
            this.effects[index] = beamFX = new ReactorBeamFX(this.reactor.func_145831_w(), Vec3D.getCenter((BlockPos)component.func_174877_v()), (EnumFacing)component.facing.value, this.reactor, component instanceof TileReactorEnergyInjector);
            BCEffectHandler.spawnGLParticle((IGLFXHandler)ReactorBeamFX.FX_HANDLER, (BCParticle)beamFX);
        }
    }
}

