/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.thaumcraft;

import com.bewitchment.Util;
import com.bewitchment.api.BewitchmentAPI;
import com.bewitchment.api.misc.Weakness;
import com.bewitchment.registry.ModObjects;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectEventProxy;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.AspectRegistryEvent;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.parts.GolemMaterial;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ScanOreDictionary;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.common.golems.EntityThaumcraftGolem;

public class ThaumcraftCompat
implements IConditionFactory {
    public static final Aspect SUN = ThaumcraftCompat.getOrCreateAspect("sol", 16765696, new Aspect[]{Aspect.FIRE, Aspect.LIGHT}, Util.newResource("textures/thaumcraft/sol.png"));
    public static final Aspect MOON = ThaumcraftCompat.getOrCreateAspect("luna", 0x808080, new Aspect[]{Aspect.EARTH, Aspect.DARKNESS}, Util.newResource("textures/thaumcraft/luna.png"));
    public static final Aspect STAR = ThaumcraftCompat.getOrCreateAspect("stellae", 7586555, new Aspect[]{SUN, Aspect.VOID}, Util.newResource("textures/thaumcraft/stellae.png"));
    public static final Aspect DEMON = ThaumcraftCompat.getOrCreateAspect("diabolus", 9830424, new Aspect[]{Aspect.SOUL, Aspect.AVERSION}, Util.newResource("textures/thaumcraft/diabolus.png"));
    public static final EnumGolemTrait SPIRITUAL_WARD = (EnumGolemTrait)EnumHelper.addEnum(EnumGolemTrait.class, (String)"SPIRITUAL_WARD", (Class[])new Class[]{ResourceLocation.class}, (Object[])new Object[]{Util.newResource("textures/thaumcraft/golems/tag_blessed.png")});
    public static final EnumGolemTrait UNCANNY = (EnumGolemTrait)EnumHelper.addEnum(EnumGolemTrait.class, (String)"UNCANNY", (Class[])new Class[]{ResourceLocation.class}, (Object[])new Object[]{Util.newResource("textures/thaumcraft/golems/tag_uncanny.png")});
    public static final EnumGolemTrait BLESSED = (EnumGolemTrait)EnumHelper.addEnum(EnumGolemTrait.class, (String)"BLESSED", (Class[])new Class[]{ResourceLocation.class}, (Object[])new Object[]{Util.newResource("textures/thaumcraft/golems/tag_blessed.png")});

    public static void init() {
        ThaumcraftApi.registerResearchLocation((ResourceLocation)Util.newResource("tc/research/bewitchment"));
        ScanningManager.addScannableThing((IScanThing)new ScanOreDictionary("f_MATCOLDIRON", new String[]{"ingotColdIron", "blockColdIron", "nuggetColdIron", "plateColdIron", "dustColdIron"}));
        ScanningManager.addScannableThing((IScanThing)new ScanOreDictionary("f_MATDRAGONSBLOOD", new String[]{"resinDragonsBlood", "blockDragonsBloodResin"}));
        ScanningManager.addScannableThing((IScanThing)new ScanOreDictionary("f_MATSILVER", new String[]{"ingotSilver", "blockSilver", "plateSilver", "dustSilver", "nuggetSilver", "oreSilver"}));
        GolemMaterial.register((GolemMaterial)new GolemMaterial("COLDIRON", new String[]{"MATSTUDCOLDIRON"}, new ResourceLocation("bewitchment", "textures/entity/coldirongolem.png"), 2699070, 20, 8, 3, new ItemStack(ModObjects.cold_iron_plate), new ItemStack(ItemsTC.mechanismSimple), new EnumGolemTrait[]{EnumGolemTrait.HEAVY, EnumGolemTrait.FIREPROOF, EnumGolemTrait.BLASTPROOF, SPIRITUAL_WARD}));
        GolemMaterial.register((GolemMaterial)new GolemMaterial("DRAGONSBLOOD", new String[]{"MATSTUDDRAGONSBLOOD"}, new ResourceLocation("bewitchment", "textures/entity/dragonsbloodgolem.png"), 4786944, 10, 1, 1, new ItemStack(ModObjects.dragons_blood_resin), new ItemStack(ItemsTC.mechanismSimple), new EnumGolemTrait[]{EnumGolemTrait.FRAGILE, EnumGolemTrait.CLUMSY, EnumGolemTrait.LIGHT, UNCANNY}));
        GolemMaterial.register((GolemMaterial)new GolemMaterial("SILVER", new String[]{"MATSTUDSILVER"}, new ResourceLocation("bewitchment", "textures/entity/silvergolem.png"), 10922156, 14, 3, 2, new ItemStack(ModObjects.silver_plate), new ItemStack(ItemsTC.mechanismSimple), new EnumGolemTrait[]{EnumGolemTrait.LIGHT, BLESSED}));
    }

    private static Aspect getOrCreateAspect(String tag, int color, Aspect[] components, ResourceLocation image) {
        Aspect a = Aspect.getAspect((String)tag);
        return a != null ? a : new Aspect(tag, color, components, image, 1);
    }

    public static boolean isColdIronGolem(EntityLivingBase golem) {
        return golem instanceof EntityThaumcraftGolem && ((EntityThaumcraftGolem)golem).getProperties().hasTrait(SPIRITUAL_WARD);
    }

    public static boolean isSilverGolem(EntityLivingBase golem) {
        return golem instanceof EntityThaumcraftGolem && ((EntityThaumcraftGolem)golem).getProperties().hasTrait(BLESSED);
    }

    public static boolean isDragonsBloodGolem(EntityLivingBase golem) {
        return golem instanceof EntityThaumcraftGolem && ((EntityThaumcraftGolem)golem).getProperties().hasTrait(UNCANNY);
    }

    private static float getDamage(float initialDamage, @NotNull Weakness weakness, EntityLivingBase target, EntityLivingBase attacker, boolean predicate0, boolean predicate1) {
        float amount = weakness.get(target);
        if (amount > 1.0f && predicate0) {
            return initialDamage * amount * 2.0f;
        }
        amount = weakness.get(attacker);
        if (amount > 1.0f && predicate1) {
            attacker.func_70097_a(DamageSource.func_92087_a((Entity)target), 4.0f);
            return initialDamage * 0.4f;
        }
        return initialDamage;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void registerItemsLater(RegistryEvent.Register<Item> event) {
        try {
            Class.forName("thaumcraft.common.golems.GolemProperties");
        }
        catch (Exception ex) {
            System.out.println("GolemProperties appears to be missing. Please report this issue to the dev of BW, for someone has done something they shouldn't!");
        }
    }

    @SubscribeEvent
    public void handleDragonsBloodGolems(@NotNull LivingEvent.LivingUpdateEvent event) {
        if (ThaumcraftCompat.isDragonsBloodGolem(event.getEntityLiving()) && event.getEntityLiving().func_70681_au().nextInt(20) == 0) {
            EntityThaumcraftGolem golem = (EntityThaumcraftGolem)event.getEntityLiving();
            List mobsNearby = golem.field_70170_p.func_72872_a(EntityMob.class, golem.func_174813_aQ().func_186662_g(8.0));
            mobsNearby.forEach(mob -> {
                Path path;
                Vec3d vec3d = RandomPositionGenerator.func_75461_b((EntityCreature)golem, (int)16, (int)7, (Vec3d)new Vec3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v));
                if (vec3d != null && mob.func_70092_e(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) >= mob.func_70068_e((Entity)golem) && (path = mob.func_70661_as().func_75488_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c)) != null) {
                    mob.func_70661_as().func_75484_a(path, 1.0);
                }
            });
        }
    }

    @SubscribeEvent
    public void handleGolems(@NotNull LivingHurtEvent event) {
        Entity source;
        EntityLivingBase target = event.getEntityLiving();
        if (!target.field_70170_p.field_72995_K && (source = event.getSource().func_76364_f()) instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source;
            float damage = ThaumcraftCompat.getDamage(event.getAmount(), BewitchmentAPI.SILVER_WEAKNESS, target, attacker, ThaumcraftCompat.isSilverGolem(attacker), ThaumcraftCompat.isSilverGolem(target));
            event.setAmount(damage);
            damage = ThaumcraftCompat.getDamage(event.getAmount(), BewitchmentAPI.COLD_IRON_WEAKNESS, target, attacker, ThaumcraftCompat.isColdIronGolem(attacker), ThaumcraftCompat.isColdIronGolem(target));
            event.setAmount(damage);
            if (ThaumcraftCompat.isDragonsBloodGolem(target)) {
                attacker.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 0));
            }
            if (ThaumcraftCompat.isDragonsBloodGolem(attacker)) {
                target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 600, 0));
            }
        }
    }

    @SubscribeEvent
    public void aspectRegistrationEvent(AspectRegistryEvent event) {
        AspectEventProxy register = event.register;
        register.registerObjectTag(new ItemStack(ModObjects.salt_barrier), new AspectList().add(Aspect.PROTECT, 5).add(Aspect.EARTH, 5));
        register.registerObjectTag(new ItemStack(ModObjects.witches_oven), new AspectList().add(Aspect.FIRE, 25).add(Aspect.METAL, 30).add(Aspect.CRAFT, 30));
        register.registerObjectTag(new ItemStack(ModObjects.spinning_wheel), new AspectList().add(Aspect.PLANT, 30).add(Aspect.MAGIC, 15).add(Aspect.CRAFT, 25));
        register.registerObjectTag(new ItemStack(ModObjects.crystal_ball), new AspectList().add(Aspect.CRYSTAL, 25).add(Aspect.MAGIC, 25).add(Aspect.DESIRE, 25));
        register.registerObjectTag(new ItemStack(ModObjects.goblet), new AspectList().add(Aspect.METAL, 15).add(Aspect.MAGIC, 15).add(Aspect.VOID, 15));
        register.registerObjectTag(new ItemStack(ModObjects.filled_goblet), new AspectList().add(Aspect.METAL, 15).add(Aspect.MAGIC, 15).add(Aspect.ALCHEMY, 15));
        register.registerObjectTag(new ItemStack(ModObjects.purifying_earth), new AspectList().add(Aspect.EARTH, 5).add(SUN, 5));
        register.registerObjectTag(new ItemStack(ModObjects.greenwitch_fleece), new AspectList().add(Aspect.CRAFT, 4).add(SUN, 4));
        register.registerObjectTag(new ItemStack(ModObjects.alchemists_fleece), new AspectList().add(Aspect.CRAFT, 4).add(Aspect.ALCHEMY, 4));
        register.registerObjectTag(new ItemStack(ModObjects.besmirched_fleece), new AspectList().add(Aspect.CRAFT, 4).add(DEMON, 4));
        register.registerObjectTag(new ItemStack(ModObjects.amethyst_ore), new AspectList().add(Aspect.DESIRE, 4).add(Aspect.EARTH, 4).add(Aspect.ALCHEMY, 4).add(Aspect.LIFE, 4));
        register.registerObjectTag(new ItemStack(ModObjects.garnet_ore), new AspectList().add(Aspect.DESIRE, 4).add(Aspect.EARTH, 4).add(Aspect.PROTECT, 4).add(STAR, 4));
        register.registerObjectTag(new ItemStack(ModObjects.opal_ore), new AspectList().add(Aspect.DESIRE, 4).add(Aspect.EARTH, 4).add(Aspect.MAGIC, 4).add(MOON, 4));
        register.registerObjectTag(new ItemStack(ModObjects.silver_ore), new AspectList().add(Aspect.METAL, 10).add(Aspect.DESIRE, 5).add(Aspect.EARTH, 5).add(MOON, 3));
        register.registerObjectTag(new ItemStack(ModObjects.salt_ore), new AspectList().add(Aspect.EARTH, 4).add(Aspect.WATER, 4).add(Aspect.PROTECT, 4));
        for (Block block : ModObjects.coquina) {
            register.registerObjectTag(new ItemStack(block), new AspectList().add(Aspect.EARTH, 4).add(Aspect.WATER, 4).add(Aspect.PROTECT, 4));
        }
        for (Block block : ModObjects.nethersteel) {
            register.registerObjectTag(new ItemStack(block), new AspectList().add(Aspect.FIRE, 5).add(Aspect.MAGIC, 5).add(Aspect.METAL, 5).add(DEMON, 10));
        }
        register.registerObjectTag(new ItemStack(ModObjects.perpetual_ice), new AspectList().add(Aspect.COLD, 10).add(Aspect.MAGIC, 10));
        register.registerObjectTag(new ItemStack(ModObjects.embittered_bricks), new AspectList().add(Aspect.COLD, 10).add(Aspect.MAGIC, 10).add(Aspect.DARKNESS, 10));
        for (Block block : ModObjects.scorned_bricks) {
            register.registerObjectTag(new ItemStack(block), new AspectList().add(Aspect.FIRE, 10).add(Aspect.MAGIC, 10).add(Aspect.DARKNESS, 10).add(DEMON, 10));
        }
        register.registerObjectTag(new ItemStack(ModObjects.cracked_scorned_bricks), new AspectList().add(Aspect.FIRE, 10).add(Aspect.MAGIC, 10).add(Aspect.DARKNESS, 10).add(DEMON, 10));
        register.registerObjectTag(new ItemStack(ModObjects.cracked_embittered_bricks), new AspectList().add(Aspect.COLD, 10).add(Aspect.MAGIC, 10).add(Aspect.DARKNESS, 10));
        for (Block block : ModObjects.block_of_cold_iron) {
            register.registerObjectTag(new ItemStack(block), new AspectList().add(Aspect.AVERSION, 30).add(Aspect.COLD, 20).add(Aspect.METAL, 67));
        }
        for (Block block : ModObjects.block_of_silver) {
            register.registerObjectTag(new ItemStack(block), new AspectList().add(Aspect.METAL, 67).add(Aspect.DESIRE, 30).add(MOON, 20));
        }
        register.registerObjectTag(new ItemStack(ModObjects.embergrass), new AspectList().add(Aspect.PLANT, 8).add(Aspect.FIRE, 8).add(Aspect.AVERSION, 8));
        register.registerObjectTag(new ItemStack(ModObjects.spanish_moss), new AspectList().add(Aspect.PLANT, 2).add(Aspect.AIR, 2).add(Aspect.MAGIC, 2));
        register.registerObjectTag(new ItemStack(ModObjects.torchwood), new AspectList().add(Aspect.PLANT, 8).add(Aspect.FIRE, 8).add(Aspect.MAGIC, 8));
        register.registerObjectTag(new ItemStack(ModObjects.frostflower), new AspectList().add(Aspect.PLANT, 8).add(Aspect.COLD, 8));
        register.registerObjectTag(new ItemStack(ModObjects.blue_ink_cap), new AspectList().add(Aspect.SENSES, 4).add(Aspect.DARKNESS, 4));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_allium), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_azure_bluet), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_blue_orchid), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_dandelion), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_oxeye_daisy), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_poppy), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_tulip_orange), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_tulip_pink), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_tulip_red), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.flower_siphoning_tulip_white), new AspectList().add(Aspect.PLANT, 8).add(Aspect.DARKNESS, 8));
        register.registerObjectTag(new ItemStack(ModObjects.cypress_sapling), new AspectList().add(Aspect.PLANT, 15).add(Aspect.LIFE, 5).add(Aspect.DEATH, 3));
        register.registerObjectTag(new ItemStack(ModObjects.elder_sapling), new AspectList().add(Aspect.PLANT, 15).add(Aspect.LIFE, 5).add(Aspect.MIND, 3));
        register.registerObjectTag(new ItemStack(ModObjects.juniper_sapling), new AspectList().add(Aspect.PLANT, 15).add(Aspect.LIFE, 5).add(Aspect.MAGIC, 3));
        register.registerObjectTag(new ItemStack(ModObjects.dragons_blood_sapling), new AspectList().add(Aspect.PLANT, 15).add(Aspect.FIRE, 5).add(Aspect.ENERGY, 3));
        register.registerObjectTag(new ItemStack(ModObjects.dragons_blood_resin), new AspectList().add(Aspect.PLANT, 3).add(Aspect.FIRE, 3).add(Aspect.ENERGY, 3));
        register.registerObjectTag(new ItemStack(ModObjects.dragons_blood_wood), new AspectList().add(Aspect.PLANT, 10).add(Aspect.FIRE, 10).add(Aspect.ENERGY, 10));
        register.registerObjectTag(new ItemStack(ModObjects.juniper_wood), new AspectList().add(Aspect.PLANT, 10).add(Aspect.LIFE, 10).add(Aspect.MAGIC, 10));
        register.registerObjectTag(new ItemStack(ModObjects.elder_wood), new AspectList().add(Aspect.PLANT, 10).add(Aspect.LIFE, 10).add(Aspect.MIND, 10));
        register.registerObjectTag(new ItemStack(ModObjects.cypress_wood), new AspectList().add(Aspect.PLANT, 10).add(Aspect.LIFE, 10).add(Aspect.DEATH, 10));
        register.registerObjectTag(new ItemStack(ModObjects.juniper_key), new AspectList().add(Aspect.PLANT, 3).add(Aspect.LIFE, 3).add(Aspect.MAGIC, 3));
        register.registerObjectTag(new ItemStack(ModObjects.aconitum), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DEATH, 2));
        register.registerObjectTag(new ItemStack(ModObjects.belladonna), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DEATH, 2).add(Aspect.MAGIC, 2));
        register.registerObjectTag(new ItemStack(ModObjects.garlic), new AspectList().add(Aspect.PLANT, 2).add(Aspect.SENSES, 2).add(Aspect.AVERSION, 2));
        register.registerObjectTag(new ItemStack(ModObjects.hellebore), new AspectList().add(Aspect.PLANT, 2).add(Aspect.MAGIC, 2).add(Aspect.FIRE, 2).add(DEMON, 2));
        register.registerObjectTag(new ItemStack(ModObjects.mandrake_root), new AspectList().add(Aspect.PLANT, 2).add(Aspect.MAGIC, 2).add(Aspect.EARTH, 2));
        register.registerObjectTag(new ItemStack(ModObjects.white_sage), new AspectList().add(Aspect.PLANT, 2).add(Aspect.AURA, 2).add(Aspect.SOUL, 2));
        register.registerObjectTag(new ItemStack(ModObjects.wormwood), new AspectList().add(Aspect.PLANT, 2).add(Aspect.SOUL, 2));
        register.registerObjectTag(new ItemStack(ModObjects.aconitum_seeds), new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 1));
        register.registerObjectTag(new ItemStack(ModObjects.belladonna_seeds), new AspectList().add(Aspect.PLANT, 1).add(Aspect.DEATH, 1).add(Aspect.MAGIC, 1));
        register.registerObjectTag(new ItemStack(ModObjects.garlic_seeds), new AspectList().add(Aspect.PLANT, 1).add(Aspect.SENSES, 1).add(Aspect.AVERSION, 1));
        register.registerObjectTag(new ItemStack(ModObjects.hellebore_seeds), new AspectList().add(Aspect.PLANT, 1).add(DEMON, 1));
        register.registerObjectTag(new ItemStack(ModObjects.mandrake_seeds), new AspectList().add(Aspect.PLANT, 1).add(Aspect.MAGIC, 1).add(Aspect.EARTH, 1));
        register.registerObjectTag(new ItemStack(ModObjects.white_sage_seeds), new AspectList().add(Aspect.PLANT, 1).add(Aspect.AURA, 1).add(Aspect.SOUL, 1));
        register.registerObjectTag(new ItemStack(ModObjects.wormwood_seeds), new AspectList().add(Aspect.PLANT, 1).add(Aspect.SOUL, 1));
        register.registerObjectTag(new ItemStack((Item)ModObjects.girdle_of_the_dryads), new AspectList().add(Aspect.PLANT, 20).add(Aspect.LIFE, 20).add(Aspect.PROTECT, 20).add(Aspect.MAGIC, 20));
        register.registerObjectTag(new ItemStack(ModObjects.horseshoe), new AspectList().add(Aspect.METAL, 8).add(Aspect.BEAST, 8).add(Aspect.PROTECT, 8));
        register.registerObjectTag(new ItemStack(ModObjects.nazar), new AspectList().add(Aspect.DESIRE, 8).add(Aspect.METAL, 8).add(Aspect.CRYSTAL, 8).add(Aspect.PROTECT, 8).add(Aspect.MAGIC, 8));
        register.registerObjectTag(new ItemStack(ModObjects.grimoire_magia), new AspectList().add(Aspect.MIND, 8).add(Aspect.MAGIC, 8).add(Aspect.AURA, 8));
        register.registerObjectTag(new ItemStack(ModObjects.diabolical_vein), new AspectList().add(Aspect.CRAFT, 4).add(DEMON, 4));
        register.registerObjectTag(new ItemStack(ModObjects.pure_filament), new AspectList().add(Aspect.CRAFT, 4).add(Aspect.AURA, 4));
        register.registerObjectTag(new ItemStack(ModObjects.witches_stitching), new AspectList().add(Aspect.CRAFT, 4).add(Aspect.MAGIC, 4));
        register.registerObjectTag(new ItemStack(ModObjects.sanguine_cloth), new AspectList().add(Aspect.CRAFT, 4).add(DEMON, 4));
        register.registerObjectTag(new ItemStack(ModObjects.golden_thread), new AspectList().add(Aspect.CRAFT, 4).add(Aspect.DESIRE, 4));
        register.registerObjectTag(new ItemStack(ModObjects.spirit_string), new AspectList().add(Aspect.CRAFT, 4).add(Aspect.SOUL, 4));
        register.registerObjectTag(new ItemStack(ModObjects.witches_cowl), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(MOON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.witches_hat), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(MOON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.witches_robes), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(MOON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.witches_pants), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(MOON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.alchemist_cowl), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.ALCHEMY, 6));
        register.registerObjectTag(new ItemStack(ModObjects.alchemist_hat), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.ALCHEMY, 6));
        register.registerObjectTag(new ItemStack(ModObjects.alchemist_robes), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.ALCHEMY, 6));
        register.registerObjectTag(new ItemStack(ModObjects.alchemist_pants), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.ALCHEMY, 6));
        register.registerObjectTag(new ItemStack(ModObjects.green_witch_cowl), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.green_witch_hat), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.green_witch_robes), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.green_witch_pants), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.besmirched_cowl), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(DEMON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.besmirched_hat), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(DEMON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.besmirched_robes), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(DEMON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.besmirched_pants), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(DEMON, 6));
        register.registerObjectTag(new ItemStack(ModObjects.amethyst), new AspectList().add(Aspect.DESIRE, 4).add(Aspect.CRYSTAL, 4).add(Aspect.ALCHEMY, 4).add(Aspect.LIFE, 4));
        register.registerObjectTag(new ItemStack(ModObjects.garnet), new AspectList().add(Aspect.DESIRE, 4).add(Aspect.CRYSTAL, 4).add(Aspect.PROTECT, 4).add(STAR, 4));
        register.registerObjectTag(new ItemStack(ModObjects.opal), new AspectList().add(Aspect.DESIRE, 4).add(Aspect.CRYSTAL, 4).add(Aspect.MAGIC, 4).add(MOON, 4));
        register.registerObjectTag(new ItemStack(ModObjects.silver_ingot), new AspectList().add(Aspect.METAL, 10).add(Aspect.DESIRE, 5).add(MOON, 3));
        register.registerObjectTag(new ItemStack(ModObjects.cold_iron_ingot), new AspectList().add(Aspect.AVERSION, 10).add(Aspect.COLD, 3).add(Aspect.METAL, 15));
        register.registerObjectTag(new ItemStack(ModObjects.salt), new AspectList().add(Aspect.EARTH, 4).add(Aspect.WATER, 4).add(Aspect.PROTECT, 4));
        register.registerObjectTag(new ItemStack(ModObjects.elderberries), new AspectList().add(Aspect.PLANT, 3).add(Aspect.MIND, 3));
        register.registerObjectTag(new ItemStack(ModObjects.juniper_berries), new AspectList().add(Aspect.PLANT, 3).add(Aspect.MAGIC, 3));
        register.registerObjectTag(new ItemStack((Item)ModObjects.stew_of_the_grotesque), new AspectList().add(DEMON, 3).add(Aspect.MAGIC, 3).add(Aspect.SENSES, 3).add(MOON, 3));
        register.registerObjectTag(new ItemStack(ModObjects.lizard_leg), new AspectList().add(Aspect.MOTION, 4).add(Aspect.EARTH, 4));
        register.registerObjectTag(new ItemStack(ModObjects.owlets_wing), new AspectList().add(Aspect.BEAST, 3).add(Aspect.AIR, 2).add(MOON, 2));
        register.registerObjectTag(new ItemStack(ModObjects.ravens_feather), new AspectList().add(Aspect.BEAST, 3).add(Aspect.AIR, 2).add(Aspect.DARKNESS, 2));
        register.registerObjectTag(new ItemStack(ModObjects.adders_fork), new AspectList().add(Aspect.DEATH, 4).add(DEMON, 4));
        register.registerObjectTag(new ItemStack(ModObjects.toe_of_frog), new AspectList().add(Aspect.WATER, 4).add(Aspect.ALCHEMY, 4));
        register.registerObjectTag(new ItemStack(ModObjects.hellhound_horn), new AspectList().add(DEMON, 6).add(Aspect.AVERSION, 6));
        register.registerObjectTag(new ItemStack(ModObjects.heart), new AspectList().add(Aspect.DEATH, 7).add(Aspect.MAN, 7));
        register.registerObjectTag(new ItemStack(ModObjects.demon_heart), new AspectList().add(DEMON, 6).add(Aspect.AVERSION, 6).add(Aspect.FIRE, 6));
        register.registerObjectTag(new ItemStack(ModObjects.snake_venom), new AspectList().add(Aspect.DEATH, 9).add(Aspect.CRYSTAL, 9));
        register.registerObjectTag(new ItemStack(ModObjects.hoof), new AspectList().add(Aspect.BEAST, 4).add(Aspect.MOTION, 4));
        register.registerObjectTag(new ItemStack(ModObjects.eye_of_old), new AspectList().add(Aspect.SENSES, 4).add(Aspect.WATER, 2).add(Aspect.ELDRITCH, 2).add(STAR, 2));
        register.registerObjectTag(new ItemStack(ModObjects.tongue_of_dog), new AspectList().add(Aspect.SENSES, 4).add(Aspect.BEAST, 4).add(Aspect.DEATH, 4));
        register.registerObjectTag(new ItemStack(ModObjects.focal_chalk), new AspectList().add(Aspect.MAGIC, 4).add(Aspect.EARTH, 4).add(Aspect.MIND, 4).add(SUN, 4));
        register.registerObjectTag(new ItemStack(ModObjects.ritual_chalk), new AspectList().add(Aspect.MAGIC, 4).add(Aspect.EARTH, 4).add(Aspect.MIND, 4));
        register.registerObjectTag(new ItemStack(ModObjects.fiery_chalk), new AspectList().add(Aspect.MAGIC, 4).add(Aspect.EARTH, 4).add(Aspect.MIND, 4).add(DEMON, 4));
        register.registerObjectTag(new ItemStack(ModObjects.phasing_chalk), new AspectList().add(Aspect.MAGIC, 4).add(Aspect.EARTH, 4).add(Aspect.MIND, 4).add(Aspect.ELDRITCH, 4));
        register.registerObjectTag(new ItemStack(ModObjects.taglock), new AspectList().add(Aspect.SOUL, 8).add(Aspect.LIFE, 8));
        register.registerObjectTag(new ItemStack(ModObjects.sigil), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_battle), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_binding), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_cleansing), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_disorientation), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_failure), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_luck), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_mending), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_purity), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_ruin), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_sentinel), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.sigil_shrieking), new AspectList().add(Aspect.CRAFT, 6).add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack((Item)ModObjects.garlic_grilled), new AspectList().add(Aspect.PLANT, 2).add(Aspect.SENSES, 2).add(Aspect.CRAFT, 2));
        register.registerObjectTag(new ItemStack((Item)ModObjects.juniper_tea), new AspectList().add(Aspect.PLANT, 3).add(Aspect.MAGIC, 3).add(Aspect.WATER, 3).add(Aspect.VOID, 3));
        register.registerObjectTag(new ItemStack((Item)ModObjects.elderberry_jelly), new AspectList().add(Aspect.PLANT, 3).add(Aspect.MIND, 3).add(Aspect.ALCHEMY, 3));
        register.registerObjectTag(new ItemStack(ModObjects.demonic_elixir), new AspectList().add(DEMON, 6).add(Aspect.FIRE, 6));
        register.registerObjectTag(new ItemStack(ModObjects.cleansing_balm), new AspectList().add(Aspect.PROTECT, 6).add(Aspect.AURA, 6));
        register.registerObjectTag(new ItemStack(ModObjects.ebb_of_death), new AspectList().add(Aspect.DEATH, 6).add(Aspect.ENTROPY, 6));
        register.registerObjectTag(new ItemStack(ModObjects.acacia_resin), new AspectList().add(Aspect.PLANT, 6).add(Aspect.AURA, 6));
        register.registerObjectTag(new ItemStack(ModObjects.fiery_unguent), new AspectList().add(Aspect.FIRE, 6).add(Aspect.ENERGY, 6));
        register.registerObjectTag(new ItemStack(ModObjects.spruce_heart), new AspectList().add(Aspect.PLANT, 6).add(Aspect.COLD, 6));
        register.registerObjectTag(new ItemStack(ModObjects.liquid_witchcraft), new AspectList().add(Aspect.MAGIC, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.essence_of_vitality), new AspectList().add(Aspect.PLANT, 6).add(Aspect.LIFE, 6));
        register.registerObjectTag(new ItemStack(ModObjects.droplet_of_wisdom), new AspectList().add(Aspect.MIND, 6).add(Aspect.PLANT, 6));
        register.registerObjectTag(new ItemStack(ModObjects.cloudy_oil), new AspectList().add(Aspect.ENTROPY, 6).add(Aspect.DARKNESS, 6));
        register.registerObjectTag(new ItemStack(ModObjects.oak_spirit), new AspectList().add(Aspect.PLANT, 6).add(Aspect.SOUL, 6));
        register.registerObjectTag(new ItemStack(ModObjects.unfired_jar), new AspectList().add(Aspect.VOID, 6).add(Aspect.EARTH, 6));
        register.registerObjectTag(new ItemStack(ModObjects.empty_jar), new AspectList().add(Aspect.VOID, 6).add(Aspect.EARTH, 6));
        register.registerObjectTag(new ItemStack(ModObjects.bottled_frostfire), new AspectList().add(Aspect.FIRE, 6).add(Aspect.COLD, 6).add(Aspect.EXCHANGE, 6));
        register.registerObjectTag(new ItemStack(ModObjects.bottled_hellfire), new AspectList().add(Aspect.FIRE, 6).add(DEMON, 6).add(Aspect.DARKNESS, 6));
        register.registerObjectTag(new ItemStack(ModObjects.birch_soul), new AspectList().add(Aspect.PLANT, 6).add(Aspect.SOUL, 6));
        register.registerObjectTag(new ItemStack(ModObjects.swirl_of_depths), new AspectList().add(Aspect.WATER, 6).add(Aspect.DARKNESS, 6));
        register.registerObjectTag(new ItemStack(ModObjects.oil_of_vitriol), new AspectList().add(Aspect.ALCHEMY, 6).add(Aspect.AVERSION, 6));
        register.registerObjectTag(new ItemStack(ModObjects.otherworldly_tears), new AspectList().add(STAR, 6).add(Aspect.WATER, 6));
        register.registerObjectTag(new ItemStack(ModObjects.heaven_extract), new AspectList().add(SUN, 6).add(Aspect.AIR, 6));
        register.registerObjectTag(new ItemStack(ModObjects.stone_ichor), new AspectList().add(Aspect.EARTH, 6).add(Aspect.ENTROPY, 6));
        register.registerObjectTag(new ItemStack(ModObjects.hellfire), new AspectList().add(Aspect.FIRE, 6).add(DEMON, 6).add(Aspect.DARKNESS, 6));
        register.registerObjectTag(new ItemStack(ModObjects.frostfire), new AspectList().add(Aspect.FIRE, 6).add(Aspect.COLD, 6).add(Aspect.EXCHANGE, 6));
        register.registerObjectTag(new ItemStack(ModObjects.black_candle), new AspectList().add(Aspect.DARKNESS, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.cyan_candle), new AspectList().add(Aspect.LIFE, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.white_candle), new AspectList().add(Aspect.AURA, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.purple_candle), new AspectList().add(Aspect.MAGIC, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.blue_candle), new AspectList().add(Aspect.WATER, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.green_candle), new AspectList().add(Aspect.PLANT, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.pink_candle), new AspectList().add(Aspect.PROTECT, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.yellow_candle), new AspectList().add(Aspect.MIND, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.orange_candle), new AspectList().add(Aspect.FIRE, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.red_candle), new AspectList().add(DEMON, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.brown_candle), new AspectList().add(Aspect.EARTH, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.gray_candle), new AspectList().add(Aspect.VOID, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.light_gray_candle), new AspectList().add(Aspect.COLD, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.magenta_candle), new AspectList().add(Aspect.EXCHANGE, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.lime_candle), new AspectList().add(Aspect.ALCHEMY, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.light_blue_candle), new AspectList().add(Aspect.AIR, 10).add(Aspect.LIGHT, 10).add(Aspect.CRAFT, 10));
        register.registerObjectTag(new ItemStack(ModObjects.cypress_broom), new AspectList().add(Aspect.PLANT, 35).add(Aspect.MAGIC, 35).add(Aspect.FLIGHT, 30).add(MOON, 25).add(STAR, 25));
        register.registerObjectTag(new ItemStack(ModObjects.elder_broom), new AspectList().add(Aspect.PLANT, 35).add(Aspect.MAGIC, 35).add(Aspect.FLIGHT, 30).add(MOON, 25).add(STAR, 25));
        register.registerObjectTag(new ItemStack(ModObjects.juniper_broom), new AspectList().add(Aspect.PLANT, 35).add(Aspect.MAGIC, 35).add(Aspect.FLIGHT, 30).add(MOON, 25).add(STAR, 25));
        register.registerObjectTag(new ItemStack(ModObjects.dragons_blood_broom), new AspectList().add(Aspect.PLANT, 35).add(Aspect.MAGIC, 35).add(Aspect.FLIGHT, 30).add(MOON, 25).add(STAR, 25));
        register.registerObjectTag(new ItemStack(ModObjects.vampiric_amulet), new AspectList().add(Aspect.MAGIC, 16).add(Aspect.DARKNESS, 16).add(MOON, 16));
        register.registerObjectTag(new ItemStack(ModObjects.triskelion), new AspectList().add(Aspect.DESIRE, 16).add(Aspect.AVERSION, 16).add(SUN, 16));
        register.registerObjectTag(new ItemStack(ModObjects.fortunes_favor), new AspectList().add(Aspect.DESIRE, 16).add(Aspect.EARTH, 16).add(Aspect.MAGIC, 16));
        register.registerObjectTag(new ItemStack(ModObjects.gluttons_sash), new AspectList().add(Aspect.DESIRE, 16).add(DEMON, 16).add(Aspect.MAGIC, 16));
        register.registerObjectTag(new ItemStack(ModObjects.silver_arrow), new AspectList().add(MOON, 2).add(Aspect.AVERSION, 2).add(Aspect.METAL, 2).add(Aspect.AIR, 2));
        register.registerObjectTag(new ItemStack(ModObjects.cold_iron_arrow), new AspectList().add(Aspect.COLD, 2).add(Aspect.AVERSION, 2).add(Aspect.METAL, 2).add(Aspect.AIR, 2));
        register.registerObjectTag(new ItemStack(ModObjects.skeleton_key), new AspectList().add(Aspect.DESIRE, 16).add(DEMON, 16).add(Aspect.MAGIC, 16));
        register.registerObjectTag(new ItemStack((Item)ModObjects.hecates_visage), new AspectList().add(Aspect.AURA, 16).add(Aspect.FIRE, 16).add(Aspect.MAGIC, 16));
        register.registerObjectTag(new ItemStack(ModObjects.dimensional_sand), new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.DARKNESS, 4).add(STAR, 4));
        register.registerObjectTag(new ItemStack(ModObjects.ectoplasm), new AspectList().add(Aspect.SOUL, 5).add(Aspect.DEATH, 5));
        register.registerObjectTag(new ItemStack(ModObjects.oak_apple_gall), new AspectList().add(Aspect.PLANT, 2).add(Aspect.SENSES, 2).add(Aspect.ENTROPY, 2));
        register.registerObjectTag(new ItemStack(ModObjects.bone_needle), new AspectList().add(Aspect.DEATH, 2).add(Aspect.CRAFT, 2));
        register.registerObjectTag(new ItemStack(ModObjects.spectral_dust), new AspectList().add(Aspect.VOID, 4).add(Aspect.SOUL, 4));
        register.registerObjectTag(new ItemStack(ModObjects.tallow), new AspectList().add(Aspect.CRAFT, 8).add(Aspect.ALCHEMY, 8).add(Aspect.BEAST, 4));
        register.registerObjectTag(new ItemStack(ModObjects.wood_ash), new AspectList().add(Aspect.PLANT, 3).add(Aspect.ENTROPY, 3));
        register.registerObjectTag(new ItemStack(ModObjects.bottle_of_blood), new AspectList().add(Aspect.WATER, 3).add(Aspect.LIFE, 3));
        register.registerObjectTag(new ItemStack(ModObjects.bottle_of_vampire_blood), new AspectList().add(Aspect.WATER, 3).add(Aspect.DEATH, 3).add(DEMON, 3));
        register.registerObjectTag(new ItemStack(ModObjects.box_of_sealed_evil), new AspectList().add(Aspect.DESIRE, 15).add(DEMON, 15).add(Aspect.DARKNESS, 15).add(Aspect.VOID, 15));
        register.registerObjectTag(new ItemStack(ModObjects.leonards_wand), new AspectList().add(Aspect.MAGIC, 15).add(Aspect.ALCHEMY, 15).add(DEMON, 15).add(Aspect.ENERGY, 15));
        register.registerObjectTag(new ItemStack(ModObjects.caduceus), new AspectList().add(Aspect.MAGIC, 15).add(Aspect.FIRE, 15).add(DEMON, 15).add(Aspect.DARKNESS, 15));
        register.registerObjectTag(new ItemStack(ModObjects.thyrsus), new AspectList().add(SUN, 16).add(Aspect.AVERSION, 16).add(Aspect.PLANT, 16));
        register.registerObjectTag(new ItemStack(ModObjects.cleaver_sword), new AspectList().add(DEMON, 16).add(Aspect.AVERSION, 16).add(Aspect.FIRE, 16));
        register.registerObjectTag(new ItemStack((Block)Blocks.field_150398_cm, 1, 0), new AspectList().add(Aspect.PLANT, 5).add(Aspect.SENSES, 5).add(SUN, 3).add(Aspect.AIR, 1).add(Aspect.LIFE, 1));
        register.registerObjectTag(new ItemStack(Items.field_151043_k), new AspectList().add(Aspect.METAL, 10).add(Aspect.DESIRE, 10).add(SUN, 5));
        ThaumcraftApi.registerEntityTag((String)"bewitchment.owl", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.FLIGHT, 10).add(MOON, 8), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.snake", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.AVERSION, 10).add(DEMON, 8), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.raven", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.FLIGHT, 10).add(Aspect.DARKNESS, 8), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.toad", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.WATER, 10).add(Aspect.ALCHEMY, 8), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.lizard", (AspectList)new AspectList().add(Aspect.BEAST, 10).add(Aspect.EARTH, 10).add(SUN, 8), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.black_dog", (AspectList)new AspectList().add(Aspect.SOUL, 25).add(Aspect.BEAST, 25).add(Aspect.AVERSION, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.hellhound", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(DEMON, 25).add(Aspect.FIRE, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.feuerwurm", (AspectList)new AspectList().add(Aspect.BEAST, 25).add(DEMON, 25).add(Aspect.DARKNESS, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.demon", (AspectList)new AspectList().add(Aspect.SOUL, 25).add(DEMON, 25).add(Aspect.FIRE, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.demoness", (AspectList)new AspectList().add(Aspect.SOUL, 25).add(DEMON, 25).add(Aspect.FIRE, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.imp", (AspectList)new AspectList().add(Aspect.SOUL, 25).add(DEMON, 25).add(Aspect.FIRE, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.druden", (AspectList)new AspectList().add(Aspect.PLANT, 25).add(DEMON, 25).add(Aspect.DARKNESS, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.shadow_person", (AspectList)new AspectList().add(Aspect.SOUL, 25).add(DEMON, 25).add(Aspect.DARKNESS, 25), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.cleaver", (AspectList)new AspectList().add(Aspect.AVERSION, 25).add(DEMON, 25).add(Aspect.BEAST, 25), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.cambion", (AspectList)new AspectList().add(Aspect.MIND, 25).add(DEMON, 25).add(Aspect.BEAST, 25), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.bafometyr", (AspectList)new AspectList().add(Aspect.AVERSION, 25).add(DEMON, 25).add(Aspect.BEAST, 25).add(Aspect.MAGIC, 25), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.ghost", (AspectList)new AspectList().add(Aspect.SOUL, 25).add(Aspect.DEATH, 25).add(Aspect.MIND, 16), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.leonard", (AspectList)new AspectList().add(Aspect.SOUL, 45).add(DEMON, 45).add(Aspect.ALCHEMY, 45), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag((String)"bewitchment.baphomet", (AspectList)new AspectList().add(Aspect.SOUL, 45).add(DEMON, 45).add(Aspect.FIRE, 45), (ThaumcraftApi.EntityTagsNBT[])new ThaumcraftApi.EntityTagsNBT[0]);
    }

    public BooleanSupplier parse(JsonContext context, JsonObject json) {
        return () -> Loader.isModLoaded((String)"thaumcraft");
    }
}

