/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.integration.dynamictrees;

import com.bewitchment.common.integration.dynamictrees.DropCreatorFruit;
import com.bewitchment.common.integration.dynamictrees.DynamicTreesCompat;
import com.bewitchment.registry.ModObjects;
import com.ferreusveritas.dynamictrees.api.IGenFeature;
import com.ferreusveritas.dynamictrees.api.treedata.IDropCreator;
import com.ferreusveritas.dynamictrees.blocks.BlockSurfaceRoot;
import com.ferreusveritas.dynamictrees.systems.featuregen.FeatureGenClearVolume;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.trees.TreeFamily;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class TreeElder
extends TreeFamily {
    private final BlockSurfaceRoot surfaceRootBlock;

    public TreeElder() {
        super(new ResourceLocation("bewitchment", "elder"));
        IBlockState primLog = ModObjects.elder_wood.func_176223_P();
        this.setPrimitiveLog(primLog, new ItemStack(ModObjects.elder_wood));
        DynamicTreesCompat.elderLeavesProperties.setTree((TreeFamily)this);
        this.surfaceRootBlock = new BlockSurfaceRoot(Material.field_151575_d, this.getName() + "root");
    }

    public void createSpecies() {
        this.setCommonSpecies(new SpeciesElder(this));
    }

    public List<Block> getRegisterableBlocks(List<Block> blockList) {
        blockList.add((Block)this.surfaceRootBlock);
        return super.getRegisterableBlocks(blockList);
    }

    public boolean isThick() {
        return false;
    }

    public BlockSurfaceRoot getSurfaceRoots() {
        return this.surfaceRootBlock;
    }

    public class SpeciesElder
    extends Species {
        SpeciesElder(TreeFamily treeFamily) {
            super(treeFamily.getName(), treeFamily, DynamicTreesCompat.elderLeavesProperties);
            this.setBasicGrowingParameters(0.4f, 14.0f, 3, 2, 1.0f);
            this.envFactor(BiomeDictionary.Type.FOREST, 1.05f);
            this.addDropCreator((IDropCreator)new DropCreatorFruit(ModObjects.elderberries, 45));
            this.addGenFeature((IGenFeature)new FeatureGenClearVolume(6));
        }

        public boolean isThick() {
            return true;
        }

        public boolean isBiomePerfect(Biome biome) {
            return BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST);
        }
    }
}

