/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.entity.living;

import com.bewitchment.common.entity.spirit.demon.EntityCambion;
import com.bewitchment.common.entity.util.ModEntityMob;
import com.bewitchment.registry.ModSounds;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EntityWerewolf
extends ModEntityMob {
    private static final DataParameter<Integer> WEREWOLF_TYPE = EntityDataManager.func_187226_a(EntityWerewolf.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityWerewolf(World world) {
        super(world, new ResourceLocation("bewitchment", "entities/werewolf"));
        this.func_70105_a(1.2f, 3.2f);
        this.field_70728_aV = 35;
    }

    @Override
    protected boolean func_70814_o() {
        return true;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WEREWOLF_TYPE, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("WerewolfType", this.getWerewolfType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setWerewolfType(compound.func_74762_e("WerewolfType"));
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.getRandomWerewolfType();
        boolean flag = false;
        if (livingdata instanceof WerewolfTypeData) {
            i = ((WerewolfTypeData)livingdata).typeData;
            flag = true;
        } else {
            livingdata = new WerewolfTypeData(i);
        }
        this.setWerewolfType(i);
        return livingdata;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.5, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 5.0f, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.6666666666666666));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 10, false, false, e -> e instanceof EntityVillager || e instanceof AbstractIllager || e instanceof EntityWitch || e instanceof EntityIronGolem || e instanceof EntitySheep || e instanceof EntityCow || e instanceof EntityChicken || e instanceof EntityLlama || e instanceof EntityPig || e instanceof EntityRabbit || e instanceof EntityCambion || e instanceof AbstractHorse));
    }

    public int func_70627_aG() {
        return 2000;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.WEREWOLF_HOWL;
    }

    protected boolean func_70692_ba() {
        return !this.func_145818_k_();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 200 <= 5) {
            this.func_70691_i(4.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_72935_r() && this.func_70692_ba()) {
            this.func_70106_y();
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187861_gG;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70601_bi() {
        if (!this.field_70170_p.func_72935_r() && (double)this.field_70170_p.func_130001_d() == 1.0) {
            return super.func_70601_bi();
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(55.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
    }

    private int getRandomWerewolfType() {
        boolean flag = this.field_70146_Z.nextBoolean();
        Biome biome = this.field_70170_p.func_180494_b(this.func_180425_c());
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return flag ? 1 : 5;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.CONIFEROUS)) {
            return flag ? 3 : 2;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return flag ? 3 : 0;
        }
        return flag ? 4 : 0;
    }

    public int getWerewolfType() {
        return (Integer)this.field_70180_af.func_187225_a(WEREWOLF_TYPE);
    }

    public void setWerewolfType(int werewolfTypeId) {
        this.field_70180_af.func_187227_b(WEREWOLF_TYPE, (Object)werewolfTypeId);
    }

    public static class WerewolfTypeData
    implements IEntityLivingData {
        public int typeData;

        public WerewolfTypeData(int type) {
            this.typeData = type;
        }
    }
}

