/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity.util;

import com.bewitchment.Util;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.oredict.OreDictionary;

public abstract class ModTileEntity
extends TileEntity {
    public static boolean contains(ItemStackHandler handler, ItemStack stack) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!OreDictionary.itemMatches((ItemStack)handler.getStackInSlot(i), (ItemStack)stack, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public static int getFirstEmptySlot(ItemStackHandler handler) {
        return ModTileEntity.getFirstValidSlot(handler, ItemStack.field_190927_a);
    }

    public static int getLastNonEmptySlot(ItemStackHandler handler) {
        for (int i = handler.getSlots() - 1; i >= 0; --i) {
            if (handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstValidSlot(ItemStackHandler handler, ItemStack stack) {
        boolean hasEmpty = false;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (Util.canMerge(handler.getStackInSlot(i), stack)) {
                return i;
            }
            if (!handler.getStackInSlot(i).func_190926_b()) continue;
            hasEmpty = true;
        }
        return hasEmpty ? ModTileEntity.getFirstEmptySlot(handler) : -1;
    }

    public static int canMerge(ItemStackHandler handler, ItemStack stack) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!Util.canMergeNonEmpty(handler.getStackInSlot(i), stack)) continue;
            return i;
        }
        return -1;
    }

    public static int getEmptySlots(ItemStackHandler handler) {
        int emptyCount = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (!handler.getStackInSlot(i).func_190926_b()) continue;
            ++emptyCount;
        }
        return emptyCount;
    }

    public static void clear(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            handler.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        for (int i = 0; i < this.getInventories().length; ++i) {
            this.getInventories()[i].deserializeNBT(tag.func_74775_l("inventory_" + i));
        }
        super.func_145839_a(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        for (int i = 0; i < this.getInventories().length; ++i) {
            tag.func_74782_a("inventory_" + i, (NBTBase)this.getInventories()[i].serializeNBT());
        }
        this.func_70296_d();
        this.syncToClient();
        return super.func_189515_b(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 3, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.handleUpdateTag(packet.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public ItemStackHandler[] getInventories() {
        return new ItemStackHandler[0];
    }

    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        return false;
    }

    public void syncToClient() {
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        this.field_145850_b.func_180497_b(this.field_174879_c, this.field_145854_h, 0, 0);
        this.func_70296_d();
    }
}

