/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.Bewitchment;
import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.common.handler.GuiHandler;
import com.bewitchment.common.item.ItemSigil;
import com.bewitchment.common.item.ItemTaglock;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityDBChest
extends ModTileEntity
implements ITickable {
    private final ItemStackHandler inventory = new ItemStackHandler(36);
    public ItemSigil sigil;
    public int cooldown = 0;
    public boolean whiteList;
    public Set<String> playerUUIDSet = new HashSet<String>();
    public float lidAngle;
    public float prevLidAngle;
    public int using;

    public void func_73660_a() {
        this.prevLidAngle = this.lidAngle;
        if (this.using > 0 && this.lidAngle == 0.0f) {
            this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.using == 0 && this.lidAngle > 0.0f || this.using > 0 && this.lidAngle < 1.0f) {
            this.lidAngle = this.using > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
            if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
                this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.using = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing face) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, face);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing face) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, face));
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.readUpdateTag(tag);
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.writeUpdateTag(tag);
        return super.func_189515_b(tag);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeUpdateTag(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeUpdateTag(tag);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.readUpdateTag(tag);
    }

    @Override
    public ItemStackHandler[] getInventories() {
        return new ItemStackHandler[]{this.inventory};
    }

    @Override
    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        if (this.sigil == null) {
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemSigil) {
                this.sigil = (ItemSigil)player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1).func_77973_b();
                this.whiteList = this.sigil.positive;
                this.playerUUIDSet.add(player.func_110124_au().toString());
                this.func_70296_d();
                return true;
            }
        } else {
            if (player.func_184586_b(hand).func_77973_b() instanceof ItemTaglock && player.func_184586_b(hand).func_77942_o()) {
                this.modifyList(this, player.func_184586_b(hand).func_77978_p().func_74779_i("boundId"));
                this.func_70296_d();
                return true;
            }
            if (this.cooldown <= 0 && this.isPlayerOnList(this, player) == this.whiteList) {
                this.sigil.applyEffects((EntityLivingBase)player);
                this.cooldown = this.sigil.cooldown;
                this.func_70296_d();
            }
        }
        player.openGui((Object)Bewitchment.instance, GuiHandler.ModGui.DRAGONS_BLOOD_CHEST.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    private void writeUpdateTag(NBTTagCompound tag) {
        tag.func_74778_a("sigil", this.sigil == null ? "" : this.sigil.getRegistryName().toString());
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74757_a("whitelist", this.whiteList);
        NBTTagList playerList = new NBTTagList();
        for (String s : this.playerUUIDSet) {
            playerList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        tag.func_74782_a("playerList", (NBTBase)playerList);
    }

    private void readUpdateTag(NBTTagCompound tag) {
        this.sigil = tag.func_74779_i("sigil").isEmpty() ? null : (ItemSigil)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("sigil")));
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.cooldown = tag.func_74762_e("cooldown");
        this.whiteList = tag.func_74767_n("whitelist");
        NBTTagList playerList = tag.func_150295_c("playerList", 8);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            this.playerUUIDSet.add(playerList.func_150307_f(i));
        }
    }

    private boolean isPlayerOnList(TileEntityDBChest te, EntityPlayer player) {
        return te.playerUUIDSet.contains(player.func_110124_au().toString());
    }

    private void modifyList(TileEntityDBChest te, String uuid) {
        if (te.playerUUIDSet.contains(uuid)) {
            te.playerUUIDSet.remove(uuid);
        } else {
            te.playerUUIDSet.add(uuid);
        }
    }
}

