/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.registry;

import com.bewitchment.Util;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class Curse
extends IForgeRegistryEntry.Impl<Curse> {
    public final double chance;
    public final List<Ingredient> input;
    private final boolean lesser;
    private final boolean positive;
    private final CurseCondition condition;

    public Curse(ResourceLocation name, List<Ingredient> input, boolean lesser, boolean positive, CurseCondition condition) {
        this(name, input, lesser, positive, condition, 1.0);
    }

    public Curse(ResourceLocation name, List<Ingredient> input, boolean lesser, boolean positive, CurseCondition condition, double chance) {
        this.setRegistryName(name);
        this.input = input;
        this.lesser = lesser;
        this.positive = positive;
        this.condition = condition;
        this.chance = chance;
    }

    public final boolean matches(ItemStackHandler input) {
        return Util.areISListsEqual(this.input, input);
    }

    public boolean apply(@Nullable EntityPlayer player, int days) {
        if (player != null && player.hasCapability(ExtendedPlayer.CAPABILITY, null)) {
            ExtendedPlayer ep = (ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null);
            ep.addCurse(this, days);
            return true;
        }
        return false;
    }

    public boolean isLesser() {
        return this.lesser;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public abstract boolean doCurse(Event var1, EntityPlayer var2);

    public CurseCondition getCurseCondition() {
        return this.condition;
    }

    public static enum CurseCondition {
        EXIST,
        REACTION,
        BLOCK_BREAK,
        BLOCK_DROP,
        KILL,
        DAMAGE,
        HURT,
        INSTANT;

    }
}

