/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.api.capability.extendedplayer;

import com.bewitchment.Util;
import com.bewitchment.api.capability.extendedplayer.ExtendedPlayer;
import com.bewitchment.api.registry.Contract;
import com.bewitchment.api.registry.Curse;
import com.bewitchment.common.item.ItemContract;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.AnimalTameEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ExtendedPlayerHandler {
    private static final ResourceLocation LOC = new ResourceLocation("bewitchment", "extended_player");

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(LOC, (ICapabilityProvider)new ExtendedPlayer());
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        ((ExtendedPlayer)event.getEntityPlayer().getCapability(ExtendedPlayer.CAPABILITY, null)).deserializeNBT(((ExtendedPlayer)event.getOriginal().getCapability(ExtendedPlayer.CAPABILITY, null)).serializeNBT());
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            ExtendedPlayer cap = (ExtendedPlayer)event.player.getCapability(ExtendedPlayer.CAPABILITY, null);
            if (cap.fortune != null) {
                if (event.player.field_70170_p.func_82737_E() % 20L == 0L) {
                    --cap.fortuneTime;
                }
                if (cap.fortuneTime == 0) {
                    if (cap.fortune.apply(event.player)) {
                        cap.fortune = null;
                    } else {
                        cap.fortuneTime = event.player.func_70681_au().nextInt(cap.fortune.maxTime - cap.fortune.minTime) + cap.fortune.minTime;
                    }
                    ExtendedPlayer.syncToClient(event.player);
                }
            }
            if (cap.curses != null) {
                List<Curse> curses = cap.getCurses();
                for (Curse curse : curses) {
                    if (curse.getCurseCondition() == Curse.CurseCondition.EXIST && event.player.func_70681_au().nextDouble() < curse.chance) {
                        curse.doCurse((Event)event, event.player);
                    }
                    if (curse.getCurseCondition() != Curse.CurseCondition.INSTANT) continue;
                    curse.doCurse((Event)event, event.player);
                    cap.removeCurse(curse);
                }
                if (event.player.field_70170_p.func_72820_D() % 20L == 0L) {
                    cap.updateCurses();
                }
            }
            if (cap.ritualDisabledTime > 0) {
                --cap.ritualDisabledTime;
                cap.canRitual = false;
                ExtendedPlayer.syncToClient(event.player);
            } else {
                cap.canRitual = true;
                ExtendedPlayer.syncToClient(event.player);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getSource().func_76346_g();
            ExtendedPlayer ep = (ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null);
            if (!event.getEntityLiving().func_184222_aU()) {
                NBTTagList list = ep.uniqueDefeatedBosses;
                String name = EntityRegistry.getEntry(event.getEntityLiving().getClass()).getName();
                boolean found = false;
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    if (!list.func_150307_f(i).equals(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    list.func_74742_a((NBTBase)new NBTTagString(name));
                    ExtendedPlayer.syncToClient(player);
                }
            }
            if (ep.curses != null) {
                for (Curse curse : ep.getCurses()) {
                    if (curse.getCurseCondition() != Curse.CurseCondition.KILL) continue;
                    curse.doCurse((Event)event, player);
                }
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!(stack.func_77973_b() instanceof ItemContract) || ((ItemContract)stack.func_77973_b()).complete(stack) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("mobsTotal") || !stack.func_77978_p().func_74764_b("mobsComplete") || !stack.func_77978_p().func_74764_b("boundId") || Util.findPlayer(stack.func_77978_p().func_74779_i("boundId")) != player) continue;
                Contract contract = (Contract)GameRegistry.findRegistry(Curse.class).getValue(new ResourceLocation(stack.func_77978_p().func_74779_i("contract")));
                if (!contract.entities.test(event.getEntityLiving())) continue;
                stack.func_77978_p().func_74768_a("mobsComplete", stack.func_77978_p().func_74762_e("mobsComplete") + 1);
                break;
            }
            if (event.getEntityLiving() instanceof EntityMob) {
                ++((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).mobsKilled;
                ExtendedPlayer.syncToClient(player);
            }
            if (event.getEntityLiving() instanceof EntityPlayer || event.getEntityLiving() instanceof EntityVillager) {
                ++((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).peopleKilled;
                ExtendedPlayer.syncToClient(player);
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K && event.getPlayer().hasCapability(ExtendedPlayer.CAPABILITY, null)) {
            ExtendedPlayer ep = (ExtendedPlayer)event.getPlayer().getCapability(ExtendedPlayer.CAPABILITY, null);
            if (ep.curses != null) {
                for (Curse curse : ep.getCurses()) {
                    if (curse.getCurseCondition() != Curse.CurseCondition.BLOCK_BREAK) continue;
                    curse.doCurse((Event)event, event.getPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockDrop(BlockEvent.HarvestDropsEvent event) {
        if (!event.getWorld().field_72995_K && event.getHarvester() != null && event.getHarvester().hasCapability(ExtendedPlayer.CAPABILITY, null)) {
            ExtendedPlayer ep = (ExtendedPlayer)event.getHarvester().getCapability(ExtendedPlayer.CAPABILITY, null);
            if (ep.curses != null) {
                for (Curse curse : ep.getCurses()) {
                    if (curse.getCurseCondition() != Curse.CurseCondition.BLOCK_DROP) continue;
                    curse.doCurse((Event)event, event.getHarvester());
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            ExtendedPlayer ep;
            if (event.getSource().func_76346_g() instanceof EntityPlayer && event.getSource().func_76346_g().hasCapability(ExtendedPlayer.CAPABILITY, null)) {
                ep = (ExtendedPlayer)event.getSource().func_76346_g().getCapability(ExtendedPlayer.CAPABILITY, null);
                if (ep.curses != null) {
                    for (Curse curse : ep.getCurses()) {
                        if (curse.getCurseCondition() != Curse.CurseCondition.DAMAGE) continue;
                        curse.doCurse((Event)event, (EntityPlayer)event.getSource().func_76346_g());
                    }
                }
            }
            if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().hasCapability(ExtendedPlayer.CAPABILITY, null)) {
                ep = (ExtendedPlayer)event.getEntityLiving().getCapability(ExtendedPlayer.CAPABILITY, null);
                if (ep.curses != null) {
                    for (Curse curse : ep.getCurses()) {
                        if (curse.getCurseCondition() != Curse.CurseCondition.HURT) continue;
                        curse.doCurse((Event)event, (EntityPlayer)event.getEntityLiving());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMobTamed(AnimalTameEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getTamer() instanceof EntityPlayer) {
            EntityPlayer player = event.getTamer();
            ++((ExtendedPlayer)player.getCapability(ExtendedPlayer.CAPABILITY, null)).pets;
        }
    }

    @SubscribeEvent
    public void pickUpItems(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            boolean found = false;
            if (!(stack.func_77973_b() instanceof ItemContract) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("contract") || !stack.func_77978_p().func_74764_b("boundId") || !stack.func_77978_p().func_74764_b("items") || ((ItemContract)stack.func_77973_b()).complete(stack) || !stack.func_77978_p().func_74779_i("boundId").equals(player.getPersistentID().toString())) continue;
            NBTTagList list = stack.func_77978_p().func_150295_c("items", 10);
            for (int t = 0; t < list.func_74745_c(); ++t) {
                NBTTagCompound tag = list.func_150305_b(t);
                if (event.getItem().func_92059_d().func_77973_b() != ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("item")))) continue;
                int complete = tag.func_74762_e("amountComplete");
                int gained = event.getItem().func_92059_d().func_190916_E();
                int toShrink = Math.min(tag.func_74762_e("amountTotal") - complete, gained);
                event.getItem().func_92059_d().func_190918_g(toShrink);
                tag.func_74768_a("amountComplete", complete + toShrink);
                if (toShrink <= 0) break;
                found = true;
                break;
            }
            if (found) break;
        }
    }
}

