/*
 * Decompiled with CFR 0.152.
 */
package com.projecturanus.enhancedp2p.network;

import com.projecturanus.enhancedp2p.network.P2PInfo;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"readInfo", "Lcom/projecturanus/enhancedp2p/network/P2PInfo;", "buf", "Lio/netty/buffer/ByteBuf;", "writeInfo", "", "info", "betterp2p"})
public final class S2CRefreshInfoKt {
    @NotNull
    public static final P2PInfo readInfo(@NotNull ByteBuf buf) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        int index = buf.readInt();
        short freq = buf.readShort();
        BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
        EnumFacing facing = EnumFacing.values()[buf.readInt()];
        boolean output = buf.readBoolean();
        boolean hasChannel = buf.readBoolean();
        int displayNameLength = buf.readInt();
        String displayName = ((Object)buf.readCharSequence(displayNameLength, StandardCharsets.UTF_8)).toString();
        BlockPos blockPos = pos;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos, (String)"pos");
        return new P2PInfo(index, freq, blockPos, facing, output, hasChannel, displayName);
    }

    public static final void writeInfo(@NotNull ByteBuf buf, @NotNull P2PInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)buf, (String)"buf");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        buf.writeInt(info.getIndex());
        buf.writeShort((int)info.getFrequency());
        buf.writeLong(info.getPos().func_177986_g());
        buf.writeInt(info.getFacing().func_176745_a());
        buf.writeBoolean(info.getOutput());
        buf.writeBoolean(info.getHasChannel());
        buf.writeInt(info.getDisplayName().length());
        buf.writeCharSequence(info.getDisplayName(), StandardCharsets.UTF_8);
    }
}

