/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.advancements.RepeatableHandler;
import com.bloodnbonesgaming.triumph.advancements.criterion.CriterionType;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph.CompletedAdvancementData;
import com.bloodnbonesgaming.triumph.advancements.display.HiddenAlways;
import com.bloodnbonesgaming.triumph.advancements.display.HiddenIf;
import com.bloodnbonesgaming.triumph.advancements.display.HiddenUnless;
import com.bloodnbonesgaming.triumph.advancements.display.VisibilityOption;
import com.bloodnbonesgaming.triumph.advancements.display.VisibleAlways;
import com.bloodnbonesgaming.triumph.advancements.display.VisibleIf;
import com.bloodnbonesgaming.triumph.advancements.display.VisibleUnless;
import com.bloodnbonesgaming.triumph.config.IOHelper;
import com.bloodnbonesgaming.triumph.config.data.AdvancementDisplayData;
import com.bloodnbonesgaming.triumph.config.data.AdvancementRequirementData;
import com.bloodnbonesgaming.triumph.config.data.AdvancementRewardsData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.Criterion;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/script/ScriptAdvancement", classExplaination="These are the functions which can be called directly in a script advancement file.")
public class AdvancementData {
    public final String advancementID;
    private String parent;
    private AdvancementDisplayData displayData;
    private Map<String, CriterionTriggerData> criteriaDataMap = new HashMap<String, CriterionTriggerData>();
    private AdvancementRequirementData requirementData;
    private String requirementType;
    public String[] exceptionRequirements;
    private AdvancementRewardsData rewardsData;
    private boolean pageRequiresRoot = false;
    private final List<VisibilityOption> pageVisibilityOptions = new ArrayList<VisibilityOption>();
    public boolean requiresParents = false;

    public AdvancementData(String advancementID) {
        this.advancementID = advancementID;
    }

    public Advancement.Builder makeBuilder(ResourceLocation advancementName) throws Exception {
        Map<String, Criterion> criterionMap = this.buildCriterionMap();
        if (criterionMap != null) {
            String[][] requirements = this.buildRequirementsArray();
            if (requirements != null) {
                Advancement.Builder builder = new Advancement.Builder(this.parent != null ? new ResourceLocation(this.parent) : null, this.getDisplayData().buildDisplayInfo(advancementName), this.getRewardsData().buildAdvancementRewards(), criterionMap, requirements);
                if (builder != null) {
                    String[][] stringArray = requirements;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String[] inner;
                        for (String requirement : inner = stringArray[i]) {
                            if (criterionMap.containsKey(requirement) && criterionMap.get(requirement) != null) continue;
                            throw new Exception("Advancement '" + this.advancementID + "' contains requirement '" + requirement + "' which has no corresponding criteria!");
                        }
                    }
                    return builder;
                }
            } else {
                Triumph.instance.getLog().error((Object)("Requirements could not be built! For advancement " + this.advancementID));
            }
        } else {
            Triumph.instance.getLog().error((Object)("Criteria could not be built! For advancement " + this.advancementID));
        }
        return null;
    }

    private Map<String, Criterion> buildCriterionMap() throws Exception {
        if (!this.criteriaDataMap.isEmpty()) {
            HashMap<String, Criterion> criterionMap = new HashMap<String, Criterion>();
            for (Map.Entry<String, CriterionTriggerData> entry : this.criteriaDataMap.entrySet()) {
                Criterion criterion;
                if (entry.getKey() == null || entry.getValue() == null || (criterion = entry.getValue().buildCriterion()) == null) continue;
                entry.getValue().buildPlayerPredicate();
                criterionMap.put(entry.getKey(), criterion);
            }
            if (!criterionMap.isEmpty()) {
                return criterionMap;
            }
        }
        return null;
    }

    public String[][] buildRequirementsArray() {
        String[][] requirements = this.getRequirementData().buildRequirementsArray();
        if (requirements == null && this.requirementType != null && !this.criteriaDataMap.isEmpty()) {
            if (this.requirementType.equals("any")) {
                if (this.exceptionRequirements == null) {
                    return new String[][]{this.criteriaDataMap.keySet().toArray(new String[0])};
                }
                ArrayList<String[]> stringList = new ArrayList<String[]>();
                for (int i = 0; i < this.exceptionRequirements.length; ++i) {
                    stringList.add(new String[]{this.exceptionRequirements[i]});
                }
                Iterator<String> iterator = this.criteriaDataMap.keySet().iterator();
                ArrayList<String> temp = new ArrayList<String>();
                block1: while (iterator.hasNext()) {
                    String next = iterator.next();
                    for (int i = 0; i < this.exceptionRequirements.length; ++i) {
                        if (next.equals(this.exceptionRequirements[i])) continue block1;
                    }
                    temp.add(next);
                }
                stringList.add(temp.toArray(new String[0]));
                return (String[][])stringList.toArray((T[])new String[0][]);
            }
            if (this.requirementType.equals("all")) {
                requirements = new String[this.criteriaDataMap.keySet().size()][];
                int i = 0;
                for (String key : this.criteriaDataMap.keySet()) {
                    requirements[i++] = new String[]{key};
                }
                return requirements;
            }
        }
        if (requirements == null && !this.criteriaDataMap.isEmpty()) {
            requirements = new String[this.criteriaDataMap.keySet().size()][];
            int i = 0;
            for (String key : this.criteriaDataMap.keySet()) {
                requirements[i++] = new String[]{key};
            }
        }
        return requirements;
    }

    public AdvancementRewardsData getRewardsData() {
        if (this.rewardsData == null) {
            this.rewardsData = new AdvancementRewardsData();
        }
        return this.rewardsData;
    }

    public void setParent(String parent) throws Exception {
        this.addParent(parent);
    }

    public String getParent() {
        return this.parent;
    }

    @ScriptMethodDocumentation(args="String", usage="", notes="Adds a parent for the advancement. This only effects its position on the advancement page and connection lines. By default parents are not required for the advancement to be completed. At least one parent is required for non-root advancements. If the string ends with a / it will be treated as a folder, and all advancements within that folder will be added as parents.")
    public void addParent(String parent) {
        if (parent.endsWith("/")) {
            for (String location : IOHelper.getAdvancementsInFolder(parent, this.advancementID)) {
                if (this.parent == null) {
                    this.parent = location.toLowerCase();
                    continue;
                }
                this.getDisplayData().addExtraConnection(new ResourceLocation(location));
            }
        } else if (this.parent == null) {
            this.parent = parent.toLowerCase();
        } else {
            this.getDisplayData().addExtraConnection(new ResourceLocation(parent));
        }
    }

    public AdvancementRequirementData getRequirementData() {
        if (this.requirementData == null) {
            this.requirementData = new AdvancementRequirementData();
        }
        return this.requirementData;
    }

    @ScriptMethodDocumentation(args="String", usage="Requirements type. This type can be either \"any\" or \"all\"", notes="This is a helper method designed to make setting criteria requirements easier. If set to \"all\" this will make all criteria required for completion. If set to \"any\" this will make any criteria complete the advancement.")
    public void setRequirements(String type) {
        this.setRequirements(type, null);
    }

    @ScriptMethodDocumentation(args="String, String array", usage="Requirements type, criteria exception array", notes="This is a helper method designed to make setting criteria requirements easier. If set to \"all\" this will make all criteria required for completion. If set to \"any\" this will make any criteria complete the advancement. If set to \"any\" the array of criteria exceptions is used to configure the requirements where all exceptions are required plus any other single criteria.")
    public void setRequirements(String type, String[] exceptions) {
        if (type.equals("any")) {
            this.requirementType = type;
            if (exceptions != null) {
                this.exceptionRequirements = exceptions;
            }
        } else if (type.equals("all")) {
            this.requirementType = type;
        } else {
            Triumph.instance.getLog().error((Object)("Error found while building advancement " + this.advancementID + ". " + type + " is not a requirement type! Only \"any\" and \"all\" are acceptable."));
        }
    }

    @ScriptMethodDocumentation(args="String array", usage="array of criteria requirements", notes="This is the manual way of adding requirements. The array of criteria requirements will be added as a requirement array. This is done in basically the same way as vanilla Json advancements, where an array of requirements is a group of criteria that, if all are completed, the advancement is completed. Multiple arrays can be added by calling this function multiple times.")
    public void addRequirements(String[] requirements) {
        this.getRequirementData().addRequirements(requirements);
    }

    @ScriptMethodDocumentation(args="String, String", usage="criteria name, criteria trigger type", notes="Adds a criteria to the advancement with the specified type. Returns the criteria object for use as a variable.")
    public CriterionTriggerData addCriteria(String name, String trigger) {
        CriterionTriggerData data = CriterionType.getData(trigger, name, this.advancementID);
        if (data != null) {
            if (this.criteriaDataMap.containsKey(name)) {
                String newName = name + "-duplicate";
                while (this.criteriaDataMap.containsKey(newName)) {
                    newName = newName + "-duplicate";
                }
                Triumph.instance.getLog().error((Object)("Error found while building advancement " + this.advancementID + ". There is already a criteria named " + name + ". Renaming to '" + newName + "'"));
                return this.addCriteria(newName, trigger);
            }
            this.criteriaDataMap.put(name, data);
            return data;
        }
        Triumph.instance.getLog().error((Object)("Error found while building advancement " + this.advancementID + ". " + trigger + " is not a criterion trigger type!"));
        return null;
    }

    public void setRequiresParent(boolean requires) throws Exception {
        if (requires) {
            this.setRequiresParents();
        }
    }

    @ScriptMethodDocumentation(usage="", notes="This is a helper method which adds criteria either named 'completedParent'/'completedParent2'/etc or if the 'useNewParentCompletionCriteriaNames' option is set in the main config named the same as their title or resource location (Example: \"Completed Some Advancement Title\") with type \"triumph:completed_advancement\", and makes them a requirement. This effectively makes the advancement require its parents to be completed before it can be completed.")
    public void setRequiresParents() throws Exception {
        this.requiresParents = true;
    }

    public void requireRoot() throws Exception {
        String root = IOHelper.findRootForAdvancement(this.advancementID);
        if (root == this.advancementID) {
            throw new Exception("This advancement is the root. You can't have an advancement require itself!");
        }
        ArrayList<String> exceptions = new ArrayList<String>();
        CompletedAdvancementData parentData = (CompletedAdvancementData)this.addCriteria("Completed Root", "triumph:completed_advancement");
        parentData.setAdvancement(root);
        exceptions.add("Completed Root");
        this.exceptionRequirements = exceptions.toArray(new String[0]);
    }

    public void requireRoot(String root) {
        ArrayList<String> exceptions = new ArrayList<String>();
        CompletedAdvancementData parentData = (CompletedAdvancementData)this.addCriteria("Completed Root", "triumph:completed_advancement");
        parentData.setAdvancement(root);
        exceptions.add("Completed Root");
        this.exceptionRequirements = exceptions.toArray(new String[0]);
    }

    @ScriptMethodDocumentation(usage="", notes="Convenience method to add a 'triumph:completed_advancement' criteria for this root to every advancement on the page. Can only be used in a root advancement.")
    public void pageRequiresRoot() {
        this.pageRequiresRoot = true;
    }

    public boolean doesPageRequireRoot() {
        return this.pageRequiresRoot;
    }

    @ScriptMethodDocumentation(args="String", usage="loottable resource location", notes="Adds a loot table reward.")
    public void addRewardLootTable(String table) {
        this.getRewardsData().addLootTable(new ResourceLocation(table));
    }

    @ScriptMethodDocumentation(args="String, int", usage="skill, levels", notes="Adds a Skillable skill level up reward.")
    public void addRewardSkillable(String skill, int levels) {
        if (Triumph.skillable) {
            this.getRewardsData().addSkillable(skill, levels);
        }
    }

    @ScriptMethodDocumentation(args="String", usage="recipe name", notes="Adds a recipe as a reward for completing the advancement. You can get the name of the recipe you want to grant from NEI or JEI.")
    public void addRewardRecipe(String recipe) throws Exception {
        this.getRewardsData().addRecipe(recipe);
    }

    public void setRewardItem(ItemBlockData item) throws Exception {
        this.addRewardItem(item);
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Adds the item as a reward for completing this advancement.")
    public void addRewardItem(ItemBlockData item) throws Exception {
        this.getRewardsData().addItem(item);
    }

    public void setRewardItem(String itemName) throws Exception {
        this.setRewardItem(itemName, 0);
    }

    public void setRewardItem(String itemName, int meta) throws Exception {
        this.setRewardItem(itemName, meta, 1);
    }

    public void setRewardItem(String itemName, int meta, int amount) throws Exception {
        this.getRewardsData().setItem(itemName, meta, amount);
    }

    public void setRewardItem(String itemName, int meta, int amount, String nbtString) throws Exception {
        this.getRewardsData().setItem(itemName, meta, amount, nbtString);
    }

    public void setRewardFunction(String function) {
        this.addRewardFunction(function);
    }

    @ScriptMethodDocumentation(args="String", usage="function name", notes="Adds the function with the provided name as a reward for completing the advancement.")
    public void addRewardFunction(String function) {
        if (function != null) {
            this.getRewardsData().addFunction(function);
        }
    }

    @ScriptMethodDocumentation(args="int", usage="experience", notes="Sets the experience amount for the reward for completing the advancement. This is in xp, not in levels.")
    public void setRewardExperience(int experience) {
        this.getRewardsData().setExperience(experience);
    }

    @ScriptMethodDocumentation(args="int", usage="color int", notes="Sets the uncompleted icon color for the advancement.")
    public void setUncompletedIconColor(int color) {
        this.getDisplayData().setUncompletedIconColor(color);
    }

    @ScriptMethodDocumentation(args="int, int, int", usage="red, green, blue", notes="Sets the uncompleted icon color for the advancement.")
    public void setUncompletedIconColor(int red, int green, int blue) {
        this.getDisplayData().setUncompletedIconColor(red, green, blue);
    }

    @ScriptMethodDocumentation(args="int", usage="color", notes="Sets the completed icon color for the advancement.")
    public void setCompletedIconColor(int color) {
        this.getDisplayData().setCompletedIconColor(color);
    }

    @ScriptMethodDocumentation(args="int, int, int", usage="red, green, blue", notes="Sets the completed icon color for the advancement.")
    public void setCompletedIconColor(int red, int green, int blue) {
        this.getDisplayData().setCompletedIconColor(red, green, blue);
    }

    @ScriptMethodDocumentation(args="int", usage="color int", notes="Sets the uncompleted title color for the advancement.")
    public void setUncompletedTitleColor(int color) {
        this.getDisplayData().setUncompletedTitleColor(color);
    }

    @ScriptMethodDocumentation(args="int, int, int", usage="red, green, blue", notes="Sets the uncompleted title color for the advancement.")
    public void setUncompletedTitleColor(int red, int green, int blue) {
        this.getDisplayData().setUncompletedTitleColor(red, green, blue);
    }

    @ScriptMethodDocumentation(args="int", usage="color", notes="Sets the completed title color for the advancement.")
    public void setCompletedTitleColor(int color) {
        this.getDisplayData().setCompletedTitleColor(color);
    }

    @ScriptMethodDocumentation(args="int, int, int", usage="red, green, blue", notes="Sets the completed title color for the advancement.")
    public void setCompletedTitleColor(int red, int green, int blue) {
        this.getDisplayData().setCompletedTitleColor(red, green, blue);
    }

    @ScriptMethodDocumentation(args="int", usage="color int", notes="Sets the uncompleted line color for the advancement.")
    public void setUncompletedLineColor(int color) {
        this.getDisplayData().setUncompletedLineColor(color);
    }

    @ScriptMethodDocumentation(args="int, int, int", usage="red, green, blue", notes="Sets the uncompleted line color for the advancement.")
    public void setUncompletedLineColor(int red, int green, int blue) {
        this.getDisplayData().setUncompletedLineColor(new Color(red, green, blue).getRGB());
    }

    @ScriptMethodDocumentation(args="int", usage="color int", notes="Sets the completed line color for the advancement.")
    public void setCompletedLineColor(int color) {
        this.getDisplayData().setCompletedLineColor(color);
    }

    @ScriptMethodDocumentation(args="int, int, int", usage="red, green, blue", notes="Sets the completed line color for the advancement.")
    public void setCompletedLineColor(int red, int green, int blue) {
        this.getDisplayData().setCompletedLineColor(new Color(red, green, blue).getRGB());
    }

    public void drawDirectLines(boolean bool) {
        this.getDisplayData().drawDirectLines(bool);
    }

    @ScriptMethodDocumentation(args="", usage="", notes="Sets the advancement to draw direct lines to parents.")
    public void drawDirectLines() {
        this.getDisplayData().drawDirectLines(true);
    }

    @ScriptMethodDocumentation(args="", usage="", notes="Sets the advancement to hide connection lines to parents.")
    public void hideLines() {
        this.getDisplayData().hideLines();
    }

    @ScriptMethodDocumentation(args="int, int", usage="x pos, y pos", notes="Sets the x and y coordinates of the advancement.")
    public void setPos(int x, int y) {
        this.getDisplayData().setPos(x, y);
    }

    @ScriptMethodDocumentation(args="boolean", usage="if the toast should be shown", notes="Sets if a toast should be shown to the player when the advancement is completed.")
    public void setShowToast(boolean showToast) {
        this.getDisplayData().setShowToast(showToast);
    }

    @ScriptMethodDocumentation(args="boolean", usage="if the advancement should be hidden", notes="Sets if the advancement should be hidden until it is completed. Not compatible with other visibility options.")
    public void setHidden(boolean hidden) {
        this.getDisplayData().setHidden(hidden);
    }

    @ScriptMethodDocumentation(args="boolean", usage="if advancement completion should be announced in chat", notes="Sets if the advancement completion should be announced in chat.")
    public void setAnnounceToChat(boolean announceToChat) {
        this.getDisplayData().setAnnounceToChat(announceToChat);
    }

    @ScriptMethodDocumentation(args="boolean", usage="background resource location", notes="Sets the background for the advancement page. This is required and only used by root advancements. Be aware the background is tiled.")
    public void setBackground(String location) {
        this.getDisplayData().setBackground(location);
    }

    @ScriptMethodDocumentation(args="boolean", usage="frame type", notes="Sets the frame type for the advancement. Options are \"TASK\", \"CHALLENGE\", \"GOAL\". Default is TASK.")
    public void setFrameType(String frameType) {
        this.getDisplayData().setFrameType(frameType);
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the item icon for the advancement. This is required.")
    public void setIcon(ItemBlockData icon) {
        this.getDisplayData().setIcon(icon);
    }

    public void setIcon(String itemName) {
        this.setIcon(itemName, 0);
    }

    public void setIcon(String itemName, int meta) {
        this.getDisplayData().setIcon(itemName, meta);
    }

    public void setIcon(String itemName, int meta, String nbt) throws Exception {
        this.getDisplayData().setIcon(itemName, meta, nbt);
    }

    public AdvancementDisplayData getDisplayData() {
        if (this.displayData == null) {
            this.displayData = new AdvancementDisplayData();
        }
        return this.displayData;
    }

    @ScriptMethodDocumentation(args="String", usage="title", notes="Sets the title for the advancement. This or setTranslatedTitle is required.")
    public void setTitle(String title) {
        this.getDisplayData().setTitle(title);
    }

    @ScriptMethodDocumentation(args="String", usage="description", notes="Sets the description for the advancement. This or setTranslatedDescription is required.")
    public void setDescription(String description) {
        this.getDisplayData().setDescription(description);
    }

    @ScriptMethodDocumentation(args="String", usage="title translation path", notes="Sets the translated title for the advancement. Used for localization. This or setTitle is required.")
    public void setTranslatedTitle(String title) {
        this.getDisplayData().setTranslatedTitle(title);
    }

    @ScriptMethodDocumentation(args="String", usage="description translation path", notes="Sets the description for the advancement. Used for localization. This or setDescription is required.")
    public void setTranslatedDescription(String description) {
        this.getDisplayData().setTranslatedDescription(description);
    }

    @ScriptMethodDocumentation(usage="", notes="Makes the advancement always visible. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void alwaysVisible() {
        this.getDisplayData().alwaysVisible();
    }

    @ScriptMethodDocumentation(usage="", notes="Makes the advancement always hidden. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void alwaysHidden() {
        this.getDisplayData().alwaysHidden();
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Makes the advancement visible if the provided advancement/gamestage is complete. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void visibleIf(String string) {
        this.getDisplayData().visibleIf(string);
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Makes the advancement hidden if the provided advancement/gamestage is complete. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void hiddenIf(String string) {
        this.getDisplayData().hiddenIf(string);
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Makes the advancement visible if the provided advancement/gamestage is not completed. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void visibleUnless(String string) {
        this.getDisplayData().visibleUnless(string);
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Makes the advancement hidden if the provided advancement/gamestage is not completed. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void hiddenUnless(String string) {
        this.getDisplayData().hiddenUnless(string);
    }

    @ScriptMethodDocumentation(usage="", notes="Only usable in root advancements. Makes the page always visible. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void pageAlwaysVisible() {
        this.pageVisibilityOptions.add(new VisibleAlways());
    }

    @ScriptMethodDocumentation(usage="", notes="Only usable in root advancements. Makes the page always hidden. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void pageAlwaysHidden() {
        this.pageVisibilityOptions.add(new HiddenAlways());
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Only usable in root advancements. Makes the page visible if the provided advancement/gamestage is complete. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void pageVisibleIf(String string) {
        this.pageVisibilityOptions.add(new VisibleIf(string));
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Only usable in root advancements. Makes the page hidden if the provided advancement/gamestage is complete. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void pageHiddenIf(String string) {
        this.pageVisibilityOptions.add(new HiddenIf(string));
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Only usable in root advancements. Makes the page visible if the provided advancement/gamestage is not completed. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void pageVisibleUnless(String string) {
        this.pageVisibilityOptions.add(new VisibleUnless(string));
    }

    @ScriptMethodDocumentation(args="String", usage="Advancement resource location or gamestage name", notes="Only usable in root advancements. Makes the page hidden if the provided advancement/gamestage is not completed. All visibility options (alwaysVisible, alwaysHidden, visibleIf, hiddenIf, visibleUnless and hiddenUnless) are run in order of addition to the script. The first one in the list to be completed is the one which enforces its visibility option.")
    public void pageHiddenUnless(String string) {
        this.pageVisibilityOptions.add(new HiddenUnless(string));
    }

    public List<VisibilityOption> getPageVisibilityOptions() {
        return this.pageVisibilityOptions;
    }

    public void addVisibilityOption(VisibilityOption option) {
        this.getDisplayData().addVisibilityOption(option);
    }

    @ScriptMethodDocumentation(args="long", usage="number of seconds before the advancement can be repeated", notes="Sets the number of seconds real time between advancement completion and when it will be completable again.")
    public void setRepeatTime(long time) {
        RepeatableHandler.addAdvancement(this.advancementID, time);
    }
}

