/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.VillagerTradeTrigger;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/villager_trade", classExplaination="These are the functions which can be called on a minecraft:villager_trade criteria trigger.")
public class VillagerTradeTriggerData
extends CriterionTriggerData {
    private final EntityData entityData = new EntityData();
    ItemPredicate itemPredicate = ItemPredicate.field_192495_a;
    private ItemBlockData itemData = new ItemBlockData();

    public VillagerTradeTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        ItemPredicate item = this.itemPredicate == ItemPredicate.field_192495_a ? this.itemData.buildItemPredicate() : this.itemPredicate;
        return new Criterion((ICriterionInstance)new VillagerTradeTrigger.Instance(this.entityData.buildPredicate(), item));
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object so functions can be called on it.")
    public EntityData getEntityData() {
        return this.entityData;
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the entity type.")
    public void setEntityType(String type) {
        this.entityData.setType(type);
    }

    @ScriptMethodDocumentation(args="ItemBlockData", usage="item data", notes="Sets the required item that must be traded for from the villager.")
    public void setItem(ItemBlockData data) throws Exception {
        this.itemPredicate = data.buildItemPredicate();
    }

    public ItemBlockData getItemData() {
        return this.itemData;
    }

    public void setItem(String itemName) {
        this.setItem(itemName, null);
    }

    public void setItem(String itemName, Integer meta) {
        this.itemData.setLocation(itemName);
        this.itemData.setMeta(meta != null ? new MinMaxBounds(Float.valueOf(meta.floatValue()), Float.valueOf(meta.floatValue())) : MinMaxBounds.field_192516_a);
    }

    public void setOreDict(String oreDict) throws Exception {
        this.itemData.setOre(oreDict);
    }
}

