/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion;

import com.bloodnbonesgaming.lib.util.JsonHelper;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CountHandler {
    private static final Map<String, Map<String, Map<String, Integer>>> countMap = new HashMap<String, Map<String, Map<String, Integer>>>();
    private static final Map<String, Map<String, Integer>> requiredCountMap = new HashMap<String, Map<String, Integer>>();

    public static void addRequiredCount(String advancement, String criterionName, int count) {
        if (!requiredCountMap.containsKey(advancement)) {
            requiredCountMap.put(advancement, new HashMap());
        }
        requiredCountMap.get(advancement).put(criterionName, count);
    }

    public static boolean increment(String playerUUID, String advancement, String criterionName) {
        Map<String, Map<String, Integer>> advancementMap;
        Map<String, Integer> innerMap;
        Integer requiredCountInteger;
        int requiredCount = 1;
        if (requiredCountMap.containsKey(advancement) && (requiredCountInteger = (innerMap = requiredCountMap.get(advancement)).get(criterionName)) != null) {
            requiredCount = requiredCountInteger;
        }
        if (requiredCount <= 1) {
            return true;
        }
        if (!countMap.containsKey(playerUUID)) {
            countMap.put(playerUUID, new HashMap());
        }
        if (!(advancementMap = countMap.get(playerUUID)).containsKey(advancement)) {
            advancementMap.put(advancement, new HashMap());
        }
        Map<String, Integer> criterionMap = advancementMap.get(advancement);
        int count = 0;
        if (criterionMap.containsKey(criterionName)) {
            count = criterionMap.get(criterionName);
        }
        if (++count >= requiredCount) {
            criterionMap.remove(criterionName);
            if (criterionMap.isEmpty()) {
                advancementMap.remove(advancement);
                if (advancementMap.isEmpty()) {
                    countMap.remove(playerUUID);
                }
            }
            return true;
        }
        criterionMap.put(criterionName, count);
        return false;
    }

    public static void loadPlayer(MinecraftServer server, String uuid) {
        Map map;
        File file = !server.func_71262_S() ? new File(FMLCommonHandler.instance().getSavesDirectory(), server.func_71270_I() + "/advancements/triumph/" + uuid + ".json") : new File(FMLCommonHandler.instance().getSavesDirectory(), "world/advancements/triumph/" + uuid + ".json");
        if (file.exists() && (map = (Map)JsonHelper.readGson((Type)new TypeToken<Map<String, Map<String, Integer>>>(){}.getType(), (File)file)) != null) {
            countMap.put(uuid, map);
        }
    }

    public static void savePlayer(MinecraftServer server, String uuid) {
        if (countMap.containsKey(uuid)) {
            File file = !server.func_71262_S() ? new File(FMLCommonHandler.instance().getSavesDirectory(), server.func_71270_I() + "/advancements/triumph/" + uuid + ".json") : new File(FMLCommonHandler.instance().getSavesDirectory(), "world/advancements/triumph/" + uuid + ".json");
            file.getParentFile().mkdirs();
            JsonHelper.writeGson(countMap.get(uuid), (File)file);
        } else {
            File file = !server.func_71262_S() ? new File(FMLCommonHandler.instance().getSavesDirectory(), server.func_71270_I() + "/advancements/triumph/" + uuid + ".json") : new File(FMLCommonHandler.instance().getSavesDirectory(), "world/advancements/triumph/" + uuid + ".json");
            if (file.exists()) {
                file.delete();
            }
        }
    }

    public static void onAdvancementReload() {
        requiredCountMap.clear();
    }

    public static void onServerAboutToStart() {
        countMap.clear();
        requiredCountMap.clear();
    }
}

