/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.api.data;

public class SourceProductMapping {
    protected String source;
    protected String product;
    protected int sourceAmount;
    protected int productAmount;

    public SourceProductMapping(String sourceKey, int sourceAmount, String productKey, int productAmount) {
        if (sourceKey == null) {
            throw new IllegalArgumentException("Cannot create mapping with null source name string");
        }
        if (productKey == null) {
            throw new IllegalArgumentException("Cannot create mapping with null product name string");
        }
        if (sourceAmount <= 0) {
            throw new IllegalArgumentException("Cannot create mapping which consumes less than 1 unit of source item");
        }
        if (productAmount <= 0) {
            throw new IllegalArgumentException("Cannot create mapping which produces less than 1 unit of product item");
        }
        this.source = sourceKey;
        this.product = productKey;
        this.sourceAmount = sourceAmount;
        this.productAmount = productAmount;
    }

    public String getSource() {
        return this.source;
    }

    public String getProduct() {
        return this.product;
    }

    public int getSourceAmount() {
        return this.sourceAmount;
    }

    public int getProductAmount() {
        return this.productAmount;
    }

    public SourceProductMapping getReverse() {
        return new SourceProductMapping(this.product, this.productAmount, this.source, this.sourceAmount);
    }

    public int getProductAmount(int sourceQty) {
        return sourceQty / this.sourceAmount * this.productAmount;
    }

    public int getSourceAmount(int productQty) {
        return productQty / this.productAmount * this.sourceAmount;
    }
}

