/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.modifier;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import hellfirepvp.modularmachinery.common.machine.MachineLoader;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.BlockArray;
import hellfirepvp.modularmachinery.common.util.MiscUtils;
import hellfirepvp.modularmachinery.common.util.nbt.NBTJsonDeserializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;

public class ModifierReplacement {
    private final BlockArray.BlockInformation info;
    private final List<RecipeModifier> modifier;
    private final List<String> description;

    public ModifierReplacement(BlockArray.BlockInformation info, List<RecipeModifier> modifier, String description) {
        this.info = info;
        this.modifier = modifier;
        this.description = description.isEmpty() ? Lists.newArrayList() : MiscUtils.splitStringBy(description, "\n");
    }

    public BlockArray.BlockInformation getBlockInformation() {
        return this.info;
    }

    public List<RecipeModifier> getModifiers() {
        return Collections.unmodifiableList(this.modifier);
    }

    public List<String> getDescriptionLines() {
        return this.description;
    }

    public static class Deserializer
    implements JsonDeserializer<ModifierReplacement> {
        public ModifierReplacement deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            BlockArray.BlockInformation blockInfo;
            NBTTagCompound match = null;
            JsonObject part = json.getAsJsonObject();
            if (part.has("nbt")) {
                JsonElement je = part.get("nbt");
                if (!je.isJsonObject()) {
                    throw new JsonParseException("The ComponentType 'nbt' expects a json compound that defines the NBT tag to match the tileentity's nbt against!");
                }
                String jsonStr = je.toString();
                try {
                    match = NBTJsonDeserializer.deserialize(jsonStr);
                }
                catch (NBTException exc) {
                    throw new JsonParseException("Error trying to parse NBTTag! Rethrowing exception...", (Throwable)exc);
                }
            }
            if (!part.has("elements")) {
                throw new JsonParseException("Modifier-tag contained no element!");
            }
            JsonElement partElement = part.get("elements");
            if (partElement.isJsonPrimitive() && partElement.getAsJsonPrimitive().isString()) {
                String strDesc = partElement.getAsString();
                blockInfo = MachineLoader.variableContext.get(strDesc);
                blockInfo = blockInfo == null ? new BlockArray.BlockInformation(Lists.newArrayList((Object[])new BlockArray.IBlockStateDescriptor[]{BlockArray.BlockInformation.getDescriptor(partElement.getAsString())})) : blockInfo.copy();
                if (match != null) {
                    blockInfo.setMatchingTag(match);
                }
            } else if (partElement.isJsonArray()) {
                JsonArray elementArray = partElement.getAsJsonArray();
                ArrayList descriptors = Lists.newArrayList();
                for (int xx = 0; xx < elementArray.size(); ++xx) {
                    JsonElement p = elementArray.get(xx);
                    if (!p.isJsonPrimitive() || !p.getAsJsonPrimitive().isString()) {
                        throw new JsonParseException("Part elements of 'elements' have to be blockstate descriptions!");
                    }
                    String prim = p.getAsString();
                    BlockArray.BlockInformation descr = MachineLoader.variableContext.get(prim);
                    if (descr != null) {
                        descriptors.addAll(descr.copy().matchingStates);
                        continue;
                    }
                    descriptors.add(BlockArray.BlockInformation.getDescriptor(prim));
                }
                if (descriptors.isEmpty()) {
                    throw new JsonParseException("'elements' array didn't contain any blockstate descriptors!");
                }
                blockInfo = new BlockArray.BlockInformation(descriptors);
                if (match != null) {
                    blockInfo.setMatchingTag(match);
                }
            } else {
                throw new JsonParseException("'elements' has to either be a blockstate description, variable or array of blockstate descriptions!");
            }
            if (!part.has("modifier") && !part.has("modifiers")) {
                throw new JsonParseException("'modifiers' tag not found!");
            }
            JsonElement elementModifiers = part.has("modifier") ? part.get("modifier") : part.get("modifiers");
            ArrayList modifiers = Lists.newArrayList();
            if (elementModifiers.isJsonObject()) {
                modifiers.add(context.deserialize(elementModifiers, RecipeModifier.class));
            } else if (elementModifiers.isJsonArray()) {
                JsonArray modifierArray = elementModifiers.getAsJsonArray();
                for (JsonElement modifierElement : modifierArray) {
                    if (!modifierElement.isJsonObject()) {
                        throw new JsonParseException("'modifiers' array needs to consist of json objects, each a modifier object!");
                    }
                    modifiers.add(context.deserialize(modifierElement, RecipeModifier.class));
                }
            } else {
                throw new JsonParseException("'modifiers' tag needs to be either a single modifier object or an array of modifier objects!");
            }
            String description = part.has("description") ? part.getAsJsonPrimitive("description").getAsString() : "";
            return new ModifierReplacement(blockInfo, modifiers, description);
        }
    }
}

