/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.machine;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.util.HybridTank;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.IOInventory;
import javax.annotation.Nullable;

public abstract class MachineComponent<T> {
    private final IOType ioType;

    public MachineComponent(IOType ioType) {
        this.ioType = ioType;
    }

    public final IOType getIOType() {
        return this.ioType;
    }

    public abstract ComponentType getComponentType();

    public abstract T getContainerProvider();

    public static abstract class EnergyHatch
    extends MachineComponent<IEnergyHandler> {
        public EnergyHatch(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentType.Registry.getComponent("energy");
        }
    }

    public static abstract class FluidHatch
    extends MachineComponent<HybridTank> {
        public FluidHatch(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentType.Registry.getComponent("fluid");
        }
    }

    public static abstract class ItemBus
    extends MachineComponent<IOInventory> {
        public ItemBus(IOType ioType) {
            super(ioType);
        }

        @Override
        public ComponentType getComponentType() {
            return ComponentType.Registry.getComponent("item");
        }
    }

    public static enum IOType {
        INPUT,
        OUTPUT;


        @Nullable
        public static IOType getByString(String name) {
            for (IOType val : IOType.values()) {
                if (!val.name().equalsIgnoreCase(name)) continue;
                return val;
            }
            return null;
        }
    }
}

