/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.integration.recipe;

import hellfirepvp.modularmachinery.common.base.Mods;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluid;
import hellfirepvp.modularmachinery.common.integration.ingredient.HybridFluidRenderer;
import hellfirepvp.modularmachinery.common.integration.recipe.RecipeLayoutHelper;
import java.awt.Point;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.plugins.vanilla.ingredients.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

public abstract class RecipeLayoutPart<T> {
    private final Point offset;

    protected RecipeLayoutPart(Point offset) {
        this.offset = offset;
    }

    public abstract int getComponentWidth();

    public abstract int getComponentHeight();

    public final Point getOffset() {
        return this.offset;
    }

    public abstract Class<T> getLayoutTypeClass();

    public abstract IIngredientRenderer<T> provideIngredientRenderer();

    public abstract int getRendererPaddingX();

    public abstract int getRendererPaddingY();

    public abstract int getMaxHorizontalCount();

    public abstract int getComponentHorizontalGap();

    public abstract int getComponentVerticalGap();

    public abstract int getComponentHorizontalSortingOrder();

    @Deprecated
    public abstract boolean canBeScaled();

    public abstract void drawBackground(Minecraft var1);

    public static class Item
    extends RecipeLayoutPart<ItemStack> {
        public Item(Point offset) {
            super(offset);
        }

        @Override
        public int getComponentHeight() {
            return 18;
        }

        @Override
        public int getComponentWidth() {
            return 18;
        }

        @Override
        public Class<ItemStack> getLayoutTypeClass() {
            return ItemStack.class;
        }

        @Override
        public int getMaxHorizontalCount() {
            return 3;
        }

        @Override
        public int getComponentVerticalGap() {
            return 0;
        }

        @Override
        public int getComponentHorizontalGap() {
            return 0;
        }

        @Override
        public int getComponentHorizontalSortingOrder() {
            return 10;
        }

        @Override
        public boolean canBeScaled() {
            return false;
        }

        @Override
        public IIngredientRenderer<ItemStack> provideIngredientRenderer() {
            return new ItemStackRenderer();
        }

        @Override
        public int getRendererPaddingX() {
            return 1;
        }

        @Override
        public int getRendererPaddingY() {
            return 1;
        }

        @Override
        public void drawBackground(Minecraft mc) {
            RecipeLayoutHelper.PART_INVENTORY_CELL.drawable.draw(mc, this.getOffset().x, this.getOffset().y);
        }
    }

    public static class Energy
    extends RecipeLayoutPart<Long> {
        public Energy(Point offset) {
            super(offset);
        }

        @Override
        public int getComponentWidth() {
            return 22;
        }

        @Override
        public int getComponentHeight() {
            return 63;
        }

        @Override
        public Class<Long> getLayoutTypeClass() {
            return Long.class;
        }

        @Override
        public int getMaxHorizontalCount() {
            return 1;
        }

        @Override
        public int getComponentHorizontalGap() {
            return 0;
        }

        @Override
        public int getComponentVerticalGap() {
            return 4;
        }

        @Override
        public int getComponentHorizontalSortingOrder() {
            return 1000;
        }

        @Override
        public boolean canBeScaled() {
            return true;
        }

        @Override
        public IIngredientRenderer<Long> provideIngredientRenderer() {
            throw new UnsupportedOperationException("Cannot provide Energy ingredientrenderer as this is no ingredient!");
        }

        @Override
        public int getRendererPaddingX() {
            return 0;
        }

        @Override
        public int getRendererPaddingY() {
            return 0;
        }

        @Override
        public void drawBackground(Minecraft mc) {
            RecipeLayoutHelper.PART_ENERGY_BACKGROUND.drawable.draw(mc, this.getOffset().x, this.getOffset().y);
        }

        public void drawEnergy(Minecraft mc, Long energy) {
            if (energy > 0L) {
                RecipeLayoutHelper.PART_ENERGY_FOREGROUND.drawable.draw(mc, this.getOffset().x, this.getOffset().y);
            }
        }
    }

    public static class Tank
    extends RecipeLayoutPart<HybridFluid> {
        public Tank(Point offset) {
            super(offset);
        }

        @Override
        public int getComponentHeight() {
            return 63;
        }

        @Override
        public int getComponentWidth() {
            return 22;
        }

        @Override
        public Class<HybridFluid> getLayoutTypeClass() {
            return HybridFluid.class;
        }

        @Override
        public int getComponentHorizontalGap() {
            return 4;
        }

        @Override
        public int getComponentVerticalGap() {
            return 4;
        }

        @Override
        public int getMaxHorizontalCount() {
            return 2;
        }

        @Override
        public int getComponentHorizontalSortingOrder() {
            return 100;
        }

        @Override
        public boolean canBeScaled() {
            return true;
        }

        @Override
        public IIngredientRenderer<HybridFluid> provideIngredientRenderer() {
            HybridFluidRenderer<HybridFluid> copy = new HybridFluidRenderer().copyPrepareFluidRender(this.getComponentWidth(), this.getComponentHeight(), 1000, false, RecipeLayoutHelper.PART_TANK_SHELL.drawable);
            if (Mods.MEKANISM.isPresent()) {
                copy = this.addGasRenderer(copy);
            }
            return copy;
        }

        @Override
        public int getRendererPaddingX() {
            return 0;
        }

        @Override
        public int getRendererPaddingY() {
            return 0;
        }

        @Optional.Method(modid="mekanism")
        private HybridFluidRenderer<HybridFluid> addGasRenderer(HybridFluidRenderer<HybridFluid> copy) {
            return copy.copyPrepareGasRender(this.getComponentWidth(), this.getComponentHeight(), 1000, false, RecipeLayoutHelper.PART_TANK_SHELL.drawable);
        }

        @Override
        public void drawBackground(Minecraft mc) {
        }
    }
}

