/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.modularmachinery.common.crafting.requirements;

import com.google.common.collect.Lists;
import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentOutputRestrictor;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.CraftCheck;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.crafting.requirements.jei.JEIComponentEnergy;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import hellfirepvp.modularmachinery.common.util.IEnergyHandler;
import hellfirepvp.modularmachinery.common.util.ResultChance;
import java.util.List;
import javax.annotation.Nonnull;

public class RequirementEnergy
extends ComponentRequirement.PerTick<Long> {
    public final long requirementPerTick;
    private long activeIO;

    public RequirementEnergy(MachineComponent.IOType ioType, long requirementPerTick) {
        super(ComponentType.Registry.COMPONENT_ENERGY, ioType);
        this.activeIO = this.requirementPerTick = requirementPerTick;
    }

    @Override
    public ComponentRequirement<Long> deepCopy() {
        RequirementEnergy energy = new RequirementEnergy(this.getActionType(), this.requirementPerTick);
        energy.activeIO = this.activeIO;
        return energy;
    }

    @Override
    public ComponentRequirement<Long> deepCopyModified(List<RecipeModifier> modifiers) {
        int requirement = Math.round(RecipeModifier.applyModifiers(modifiers, this, (float)this.requirementPerTick, false));
        RequirementEnergy energy = new RequirementEnergy(this.getActionType(), requirement);
        energy.activeIO = this.activeIO;
        return energy;
    }

    @Override
    public void startRequirementCheck(ResultChance contextChance, RecipeCraftingContext context) {
    }

    @Override
    public void endRequirementCheck() {
    }

    public long getRequiredEnergyPerTick() {
        return this.requirementPerTick;
    }

    @Override
    public ComponentRequirement.JEIComponent<Long> provideJEIComponent() {
        return new JEIComponentEnergy(this);
    }

    @Override
    @Nonnull
    public CraftCheck canStartCrafting(MachineComponent component, RecipeCraftingContext context, List<ComponentOutputRestrictor> restrictions) {
        if (!component.getComponentType().equals(this.getRequiredComponentType()) || !(component instanceof MachineComponent.EnergyHatch) || component.getIOType() != this.getActionType()) {
            return CraftCheck.skipComponent();
        }
        IEnergyHandler handler = (IEnergyHandler)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                if (!((float)handler.getCurrentEnergy() >= RecipeModifier.applyModifiers(context, this, (float)this.requirementPerTick, false))) break;
                return CraftCheck.success();
            }
            case OUTPUT: {
                return CraftCheck.success();
            }
        }
        return CraftCheck.failure("craftcheck.failure.energy.input");
    }

    @Override
    public boolean startCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        return this.canStartCrafting(component, context, Lists.newArrayList()).isSuccess();
    }

    @Override
    public boolean finishCrafting(MachineComponent component, RecipeCraftingContext context, ResultChance chance) {
        return true;
    }

    @Override
    public void startIOTick(RecipeCraftingContext context, float durationMultiplier) {
        this.activeIO = Math.round((double)RecipeModifier.applyModifiers(context, this, (float)this.activeIO, false) * (double)durationMultiplier);
    }

    @Override
    @Nonnull
    public CraftCheck resetIOTick(RecipeCraftingContext context) {
        boolean enough = this.activeIO <= 0L;
        this.activeIO = this.requirementPerTick;
        return enough ? CraftCheck.success() : CraftCheck.failure("craftcheck.failure.energy.input");
    }

    @Override
    @Nonnull
    public CraftCheck doIOTick(MachineComponent component, RecipeCraftingContext context) {
        if (!component.getComponentType().equals(this.getRequiredComponentType()) || !(component instanceof MachineComponent.EnergyHatch) || component.getIOType() != this.getActionType()) {
            return CraftCheck.skipComponent();
        }
        IEnergyHandler handler = (IEnergyHandler)context.getProvidedCraftingComponent(component);
        switch (this.getActionType()) {
            case INPUT: {
                if (handler.getCurrentEnergy() >= this.activeIO) {
                    handler.setCurrentEnergy(handler.getCurrentEnergy() - this.activeIO);
                    this.activeIO = 0L;
                    return CraftCheck.success();
                }
                this.activeIO -= handler.getCurrentEnergy();
                handler.setCurrentEnergy(0L);
                return CraftCheck.partialSuccess();
            }
            case OUTPUT: {
                long remaining = handler.getRemainingCapacity();
                if (remaining - this.activeIO < 0L) {
                    handler.setCurrentEnergy(handler.getMaxEnergy());
                    this.activeIO -= remaining;
                    return CraftCheck.partialSuccess();
                }
                handler.setCurrentEnergy(Math.min(handler.getCurrentEnergy() + this.activeIO, handler.getMaxEnergy()));
                this.activeIO = 0L;
                return CraftCheck.success();
            }
        }
        return CraftCheck.skipComponent();
    }
}

