/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import thelm.packagedauto.integration.jei.EncoderTransferHandler;

@JEIPlugin
public class PackagedAutoJEIPlugin
implements IModPlugin {
    public static IModRegistry registry;
    public static IJeiRuntime jeiRuntime;
    public static List<String> allCategories;

    public void register(IModRegistry registry) {
        PackagedAutoJEIPlugin.registry = registry;
        registry.getRecipeTransferRegistry().addUniversalRecipeTransferHandler((IRecipeTransferHandler)EncoderTransferHandler.INSTANCE);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        PackagedAutoJEIPlugin.jeiRuntime = jeiRuntime;
        allCategories = Lists.transform((List)jeiRuntime.getRecipeRegistry().getRecipeCategories(), IRecipeCategory::getUid);
    }

    public static List<String> getAllRecipeCategories() {
        return allCategories;
    }

    public static void showCategories(List<String> categories) {
        if (jeiRuntime != null && !categories.isEmpty()) {
            jeiRuntime.getRecipesGui().showCategories(categories);
        }
    }

    static {
        allCategories = Collections.emptyList();
    }
}

